/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.pagecache;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class FilePageCacheStatistics {
    private static final boolean MEASURE_TIMESTAMPS = true;
    private final AtomicLong totalNativeBytesAllocated = new AtomicLong();
    private final AtomicLong totalNativeBytesReclaimed = new AtomicLong();
    private final AtomicLong totalHeapBytesAllocated = new AtomicLong();
    private final AtomicLong totalHeapBytesReclaimed = new AtomicLong();
    private final AtomicInteger totalPagesAllocated = new AtomicInteger();
    private final AtomicInteger totalPagesReclaimed = new AtomicInteger();
    private final AtomicInteger totalPagesHandedOver = new AtomicInteger();
    private final AtomicLong totalBytesRead = new AtomicLong();
    private final AtomicLong totalBytesWritten = new AtomicLong();
    private final AtomicLong totalPagesWritten = new AtomicLong();
    private final AtomicLong totalPagesRequested = new AtomicLong();
    private final AtomicLong totalBytesRequested = new AtomicLong();
    private final AtomicLong totalPagesRequestsNs = new AtomicLong();
    private final AtomicLong totalPagesReadNs = new AtomicLong();
    private final AtomicLong totalPagesWriteNs = new AtomicLong();
    private volatile long housekeeperTurnDone = 0L;
    private volatile long housekeeperTurnSkipped = 0L;
    private volatile int totalClosedStoragesReclaimed;

    public long startTimestampNs() {
        return System.nanoTime();
    }

    public void pageAllocatedNative(int pageSize) {
        this.totalNativeBytesAllocated.addAndGet(pageSize);
        this.totalPagesAllocated.incrementAndGet();
    }

    public void pageAllocatedHeap(int pageSize) {
        this.totalHeapBytesAllocated.addAndGet(pageSize);
        this.totalPagesAllocated.incrementAndGet();
    }

    public void pageReclaimedNative(int pageSize) {
        this.totalNativeBytesReclaimed.addAndGet(pageSize);
        this.totalPagesReclaimed.incrementAndGet();
    }

    public void pageReclaimedHeap(int pageSize) {
        this.totalHeapBytesReclaimed.addAndGet(pageSize);
        this.totalPagesReclaimed.incrementAndGet();
    }

    public void pageReclaimedByHandover(int pageSize, boolean direct) {
        this.totalPagesHandedOver.incrementAndGet();
        if (direct) {
            this.pageReclaimedNative(pageSize);
            this.pageAllocatedNative(pageSize);
        } else {
            this.pageReclaimedHeap(pageSize);
            this.pageAllocatedHeap(pageSize);
        }
    }

    public void pageRequested(int pageSize, long requestStartedAtNs) {
        this.totalBytesRequested.addAndGet(pageSize);
        this.totalPagesRequested.incrementAndGet();
        this.totalPagesRequestsNs.addAndGet(System.nanoTime() - requestStartedAtNs);
    }

    public void pageRead(int bytesRead, long readStartedAtNs) {
        this.totalBytesRead.addAndGet(bytesRead);
        this.totalPagesReadNs.addAndGet(System.nanoTime() - readStartedAtNs);
    }

    public void pageWritten(int bytesWritten, long writeStartedAtNs) {
        this.totalPagesWritten.incrementAndGet();
        this.totalBytesWritten.addAndGet(bytesWritten);
        this.totalPagesWriteNs.addAndGet(System.nanoTime() - writeStartedAtNs);
    }

    public void cacheMaintenanceTurnDone() {
        ++this.housekeeperTurnDone;
    }

    public void cacheMaintenanceTurnSkipped() {
        ++this.housekeeperTurnSkipped;
    }

    public void closedStoragesReclaimed(int reclaimed) {
        this.totalClosedStoragesReclaimed += reclaimed;
    }

    public long totalNativeBytesAllocated() {
        return this.totalNativeBytesAllocated.get();
    }

    public long totalNativeBytesReclaimed() {
        return this.totalNativeBytesReclaimed.get();
    }

    public long totalHeapBytesAllocated() {
        return this.totalHeapBytesAllocated.get();
    }

    public long totalHeapBytesReclaimed() {
        return this.totalHeapBytesReclaimed.get();
    }

    public int totalPagesAllocated() {
        return this.totalPagesAllocated.get();
    }

    public int totalPagesReclaimed() {
        return this.totalPagesReclaimed.get();
    }

    public long totalBytesRead() {
        return this.totalBytesRead.get();
    }

    public long totalBytesWritten() {
        return this.totalBytesWritten.get();
    }

    public long totalPagesWritten() {
        return this.totalPagesWritten.get();
    }

    public long totalPagesRequested() {
        return this.totalPagesRequested.get();
    }

    public long totalBytesRequested() {
        return this.totalBytesRequested.get();
    }

    public long totalPagesRequestsNs() {
        return this.totalPagesRequestsNs.get();
    }

    public long totalPagesReadNs() {
        return this.totalPagesReadNs.get();
    }

    public long totalPagesWriteNs() {
        return this.totalPagesWriteNs.get();
    }

    public long housekeeperTurnDone() {
        return this.housekeeperTurnDone;
    }

    public long housekeeperTurnSkipped() {
        return this.housekeeperTurnSkipped;
    }

    public int totalClosedStoragesReclaimed() {
        return this.totalClosedStoragesReclaimed;
    }

    public String toString() {
        return "Statistics[pages: {requested: " + this.totalPagesRequested + ", allocated: " + this.totalPagesAllocated + ", flushed: " + this.totalPagesWritten + ", reclaimed: " + this.totalPagesReclaimed + "}, nativeBytes: {allocated: " + this.totalNativeBytesAllocated + ", reclaimed: " + this.totalNativeBytesReclaimed + "}, heapBytes: {allocated: " + this.totalHeapBytesAllocated + ", reclaimed: " + this.totalHeapBytesReclaimed + "}, pages handed over: " + this.totalPagesHandedOver + ", bytes: {requested: " + this.totalBytesRequested + ", read: " + this.totalBytesRead + ", written=" + this.totalBytesWritten + "}, housekeeperTurns: {done: " + this.housekeeperTurnDone + ", skipped: " + this.housekeeperTurnSkipped + "}, closedStoragesReclaimed: " + this.totalClosedStoragesReclaimed + ']';
    }

    public String toPrettyString() {
        long totalBytesAllocated = this.totalNativeBytesAllocated.get() + this.totalHeapBytesAllocated.get();
        return String.format("Statistics: {\n pages: {\n   requested:   %s\n   allocated:   %s (~%2.1f%% of requested)\n   written:     %s (~%2.1f%% of allocated)\n   reclaimed:   %s (~%2.1f%% of allocated)\n   handed over: %s (~%2.1f%% of allocated)\n }\n total bytes: {\n   requested: %s\n   read:      %s (~%.1f%% of requested)\n   written:   %s\n }\n\n average durations: {\n   page request: %5.1f us (~%.0f MiB/s)\n   page load:    %5.1f us (~%.0f MiB/s)\n   page write:   %5.1f us (~%.0f MiB/s)\n }\n\n native memory: {\n   allocated: %s b (~%2.1f%% of total)\n   reclaimed: %s b (~%2.1f%% of allocated)\n }\n heap memory: {\n   allocated: %s b (~%.1f%% of total)\n   reclaimed: %s b (~%.1f%% of allocated)\n }\n housekeeperTurns: {done: %d, skipped: %d}\n closedStoragesReclaimed: %d\n}", this.totalPagesRequested, this.totalPagesAllocated, (double)this.totalPagesAllocated.get() * 100.0 / (double)this.totalPagesRequested.get(), this.totalPagesWritten, (double)this.totalPagesWritten.get() * 100.0 / (double)this.totalPagesAllocated.get(), this.totalPagesReclaimed, (double)this.totalPagesReclaimed.get() * 100.0 / (double)this.totalPagesAllocated.get(), this.totalPagesHandedOver, (double)this.totalPagesHandedOver.get() * 100.0 / (double)this.totalPagesAllocated.get(), this.totalBytesRequested, this.totalBytesRead, (double)this.totalBytesRead.get() * 100.0 / (double)this.totalBytesRequested.get(), this.totalBytesWritten, (double)this.totalPagesRequestsNs.get() / 1000.0 / (double)this.totalPagesRequested.get(), (double)this.totalBytesRequested.get() * 1.0E9 / 1048576.0 / (double)this.totalPagesRequestsNs.get(), (double)this.totalPagesReadNs.get() / 1000.0 / (double)this.totalPagesAllocated.get(), (double)this.totalBytesRead.get() * 1.0E9 / 1048576.0 / (double)this.totalPagesReadNs.get(), (double)this.totalPagesWriteNs.get() / 1000.0 / (double)this.totalPagesWritten.get(), (double)this.totalBytesWritten.get() * 1.0E9 / 1048576.0 / (double)this.totalPagesWriteNs.get(), this.totalNativeBytesAllocated, (double)this.totalNativeBytesAllocated.get() * 100.0 / (double)totalBytesAllocated, this.totalNativeBytesReclaimed, (double)this.totalNativeBytesReclaimed.get() * 100.0 / (double)this.totalNativeBytesAllocated.get(), this.totalHeapBytesAllocated, (double)this.totalHeapBytesAllocated.get() * 100.0 / (double)totalBytesAllocated, this.totalHeapBytesReclaimed, (double)this.totalHeapBytesReclaimed.get() * 100.0 / (double)this.totalHeapBytesAllocated.get(), this.housekeeperTurnDone, this.housekeeperTurnSkipped, this.totalClosedStoragesReclaimed);
    }
}

