/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashSetInterner;
import com.intellij.util.containers.Interner;
import com.intellij.util.io.IOUtil;
import com.intellij.util.text.CharArrayUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class PathInterner {
    private final HashSetInterner<CharSegment> myInternMap = new HashSetInterner();

    @Contract(value="_,true->!null")
    private CharSegment[] internParts(@NotNull CharSequence path, boolean forAddition) {
        if (path == null) {
            PathInterner.$$$reportNull$$$0(0);
        }
        boolean asBytes = forAddition && IOUtil.isAscii(path);
        ArrayList<CharSegment> key = new ArrayList<CharSegment>();
        SubSegment flyweightKey = new SubSegment();
        for (int start = 0; start < path.length(); start += flyweightKey.length()) {
            flyweightKey.findSubStringUntilNextSeparator(path, start);
            CharSegment interned = this.myInternMap.get(flyweightKey);
            if (interned == null) {
                if (!forAddition) {
                    return null;
                }
                interned = flyweightKey.createPersistentCopy(asBytes);
                this.myInternMap.intern(interned);
            }
            key.add(interned);
        }
        return key.toArray(new CharSegment[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/containers/PathInterner", "internParts"));
    }

    private static class CharSegment {
        private final Object encodedString;
        private final int hc;

        private CharSegment(@NotNull Object encodedString, int hc) {
            if (encodedString == null) {
                CharSegment.$$$reportNull$$$0(0);
            }
            this.encodedString = encodedString;
            this.hc = hc;
        }

        void appendTo(@NotNull StringBuilder sb) {
            if (sb == null) {
                CharSegment.$$$reportNull$$$0(1);
            }
            if (this.encodedString instanceof CharSequence) {
                sb.append(this.encodedString);
                return;
            }
            int oldLen = sb.length();
            sb.setLength(oldLen + this.length());
            byte[] bytes = (byte[])this.encodedString;
            for (int i = 0; i < bytes.length; ++i) {
                sb.setCharAt(oldLen + i, (char)bytes[i]);
            }
        }

        char charAt(int i) {
            if (this.encodedString instanceof CharSequence) {
                return ((CharSequence)this.encodedString).charAt(i);
            }
            return (char)((byte[])this.encodedString)[i];
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CharSegment)) {
                return false;
            }
            CharSegment wrapper = (CharSegment)o;
            if (this.hashCode() != wrapper.hashCode()) {
                return false;
            }
            if (this.length() != wrapper.length()) {
                return false;
            }
            for (int i = 0; i < this.length(); ++i) {
                if (this.charAt(i) == wrapper.charAt(i)) continue;
                return false;
            }
            return true;
        }

        int length() {
            if (this.encodedString instanceof CharSequence) {
                return ((CharSequence)this.encodedString).length();
            }
            return (char)((byte[])this.encodedString).length;
        }

        public int hashCode() {
            return this.hc;
        }

        public String toString() {
            return this.encodedString instanceof String ? (String)this.encodedString : new String((byte[])this.encodedString, StandardCharsets.ISO_8859_1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "encodedString";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/containers/PathInterner$CharSegment";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SubSegment
    extends CharSegment {
        private Object encodedString;
        private int start;
        private int end;
        private int computedHc;

        private SubSegment() {
            super("", 0);
        }

        void findSubStringUntilNextSeparator(@NotNull CharSequence s, int start) {
            if (s == null) {
                SubSegment.$$$reportNull$$$0(0);
            }
            this.encodedString = s;
            this.start = start;
            while (start < s.length() && SubSegment.isSeparator(s.charAt(start))) {
                ++start;
            }
            while (start < s.length() && !SubSegment.isSeparator(s.charAt(start))) {
                ++start;
            }
            this.end = start;
            this.computedHc = StringUtil.stringHashCode(s, this.start, this.end);
        }

        private static boolean isSeparator(char c) {
            return c == '/' || c == '\\' || c == '.' || c == ' ' || c == '_' || c == '$';
        }

        @Override
        char charAt(int i) {
            if (this.encodedString instanceof CharSequence) {
                return ((CharSequence)this.encodedString).charAt(this.start + i);
            }
            return (char)((byte[])this.encodedString)[this.start + i];
        }

        @Override
        int length() {
            return this.end - this.start;
        }

        @Override
        public int hashCode() {
            return this.computedHc;
        }

        @NotNull
        CharSegment createPersistentCopy(boolean asBytes) {
            Object newEncodedString;
            CharSequence string2 = (CharSequence)this.encodedString;
            if (asBytes) {
                byte[] bytes = ArrayUtil.newByteArray(this.length());
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = (byte)string2.charAt(i + this.start);
                }
                newEncodedString = bytes;
            } else {
                newEncodedString = string2.subSequence(this.start, this.end);
            }
            return new CharSegment(newEncodedString, this.computedHc);
        }

        @Override
        public String toString() {
            return (this.encodedString instanceof String ? (String)this.encodedString : new String((byte[])this.encodedString, StandardCharsets.ISO_8859_1)).substring(this.start, this.end);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/util/containers/PathInterner$SubSegment", "findSubStringUntilNextSeparator"));
        }
    }

    public static class PathEnumerator
    extends Interner<CharSequence> {
        private final Object2IntMap<CharSegment[]> mySeqToIdx = new Object2IntOpenCustomHashMap<CharSegment[]>(ObjectArrays.HASH_STRATEGY);
        private final List<CharSequence> myIdxToSeq = new ArrayList<CharSequence>();
        private final PathInterner myInterner = new PathInterner();

        public PathEnumerator() {
            this.myIdxToSeq.add(null);
        }

        @NotNull
        public List<CharSequence> getAllPaths() {
            List<CharSequence> list = this.myIdxToSeq.subList(1, this.myIdxToSeq.size());
            if (list == null) {
                PathEnumerator.$$$reportNull$$$0(0);
            }
            return list;
        }

        public int addPath(@NotNull CharSequence path) {
            CharSegment[] seq;
            if (path == null) {
                PathEnumerator.$$$reportNull$$$0(1);
            }
            if (!this.mySeqToIdx.containsKey(seq = this.myInterner.internParts(path, true))) {
                this.mySeqToIdx.put(seq, this.myIdxToSeq.size());
                this.myIdxToSeq.add(new SegmentedCharSequence(seq));
            }
            return this.mySeqToIdx.getInt(seq);
        }

        @NotNull
        public CharSequence retrievePath(int idx) {
            CharSequence charSequence;
            try {
                charSequence = this.myIdxToSeq.get(idx);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Illegal index: " + idx);
            }
            if (charSequence == null) {
                PathEnumerator.$$$reportNull$$$0(2);
            }
            return charSequence;
        }

        public boolean containsPath(@NotNull CharSequence path) {
            CharSegment[] key;
            if (path == null) {
                PathEnumerator.$$$reportNull$$$0(3);
            }
            return (key = this.myInterner.internParts(path, false)) != null && this.mySeqToIdx.containsKey(key);
        }

        @Override
        @NotNull
        public CharSequence intern(@NotNull CharSequence path) {
            if (path == null) {
                PathEnumerator.$$$reportNull$$$0(4);
            }
            CharSequence charSequence = this.retrievePath(this.addPath(path));
            if (charSequence == null) {
                PathEnumerator.$$$reportNull$$$0(5);
            }
            return charSequence;
        }

        @Override
        @NotNull
        public Set<CharSequence> getValues() {
            Set<CharSequence> set = CollectionFactory.createSmallMemoryFootprintSet(this.getAllPaths());
            if (set == null) {
                PathEnumerator.$$$reportNull$$$0(6);
            }
            return set;
        }

        @Override
        public void clear() {
            this.myInterner.myInternMap.clear();
            this.mySeqToIdx.clear();
            this.myIdxToSeq.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/PathInterner$PathEnumerator";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllPaths";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/PathInterner$PathEnumerator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "retrievePath";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intern";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addPath";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "containsPath";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "intern";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class SegmentedCharSequence
    implements CharSequenceWithStringHash {
        private final CharSegment[] myWrappers;
        private transient int hash;

        private SegmentedCharSequence(CharSegment @NotNull [] wrappers) {
            if (wrappers == null) {
                SegmentedCharSequence.$$$reportNull$$$0(0);
            }
            this.myWrappers = wrappers;
        }

        @Override
        public int length() {
            int length = 0;
            for (CharSegment wrapper : this.myWrappers) {
                length += wrapper.length();
            }
            return length;
        }

        @Override
        public char charAt(int index) {
            for (CharSegment wrapper : this.myWrappers) {
                int length = wrapper.length();
                if (index < length) {
                    return wrapper.charAt(index);
                }
                index -= length;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.toString().substring(start, end);
        }

        @Override
        @NotNull
        public String toString() {
            StringBuilder b = new StringBuilder(this.length());
            for (CharSegment wrapper : this.myWrappers) {
                wrapper.appendTo(b);
            }
            String string2 = b.toString();
            if (string2 == null) {
                SegmentedCharSequence.$$$reportNull$$$0(1);
            }
            return string2;
        }

        private static int pow31(int p) {
            int base = 31;
            int r = 1;
            while (p != 0) {
                if ((p & 1) != 0) {
                    r *= base;
                }
                base *= base;
                p >>= 1;
            }
            return r;
        }

        @Override
        public int hashCode() {
            int h = this.hash;
            if (h == 0) {
                h = this.myWrappers[0].hc;
                for (int i = 1; i < this.myWrappers.length; ++i) {
                    CharSegment wrapper = this.myWrappers[i];
                    h = h * SegmentedCharSequence.pow31(wrapper.length()) + wrapper.hc;
                }
                this.hash = h;
                return h;
            }
            return h;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CharSequence)) {
                return false;
            }
            CharSequence other = (CharSequence)obj;
            if (this.length() != other.length()) {
                return false;
            }
            int i = 0;
            for (CharSegment wrapper : this.myWrappers) {
                byte[] bytes;
                if (wrapper.encodedString instanceof String) {
                    if (!CharArrayUtil.regionMatches(other, i, i + wrapper.length(), (CharSequence)((String)wrapper.encodedString))) {
                        return false;
                    }
                    i += wrapper.length();
                    continue;
                }
                for (byte b : bytes = (byte[])wrapper.encodedString) {
                    char c = (char)b;
                    if (c == other.charAt(i++)) continue;
                    return false;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrappers";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/PathInterner$SegmentedCharSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/PathInterner$SegmentedCharSequence";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

