/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.websocket;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.projector.common.protocol.toClient.MainWindow;
import org.jetbrains.projector.server.ProjectorServer;
import org.jetbrains.projector.server.core.websocket.HttpWsClientBuilder;
import org.jetbrains.projector.server.core.websocket.HttpWsServerBuilder;
import org.jetbrains.projector.server.core.websocket.WsTransportBuilder;
import org.jetbrains.projector.server.websocket.WebsocketServer;
import org.jetbrains.projector.util.loading.OptionKt;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0000\u00a2\u0006\u0002\b\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/projector/server/websocket/WebsocketServer;", "", "()V", "ENABLE_WS_SERVER_PROPERTY", "", "RELAY_PROPERTY_NAME", "RELAY_USE_WSS", "SERVER_ID_PROPERTY_NAME", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "createTransportBuilders", "", "Lorg/jetbrains/projector/server/core/websocket/WsTransportBuilder;", "createTransportBuilders$projector_server_common", "projector-server-common"})
public final class WebsocketServer {
    @NotNull
    public static final WebsocketServer INSTANCE = new WebsocketServer();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String RELAY_PROPERTY_NAME = "ORG_JETBRAINS_PROJECTOR_SERVER_RELAY_URL";
    @NotNull
    private static final String SERVER_ID_PROPERTY_NAME = "ORG_JETBRAINS_PROJECTOR_SERVER_RELAY_SERVER_ID";
    @NotNull
    private static final String RELAY_USE_WSS = "ORG_JETBRAINS_PROJECTOR_SERVER_RELAY_USE_WSS";
    @NotNull
    public static final String ENABLE_WS_SERVER_PROPERTY = "ORG_JETBRAINS_PROJECTOR_SERVER_ENABLE_WS_SERVER";

    private WebsocketServer() {
    }

    @NotNull
    public final List<WsTransportBuilder> createTransportBuilders$projector_server_common() {
        ArrayList<WsTransportBuilder> builders = new ArrayList<WsTransportBuilder>();
        String relayUrl = OptionKt.getOption(RELAY_PROPERTY_NAME);
        String serverId = OptionKt.getOption(SERVER_ID_PROPERTY_NAME);
        if (relayUrl != null && serverId != null) {
            String string;
            boolean bl = Boolean.parseBoolean(OptionKt.getOption(RELAY_USE_WSS, "true"));
            if (!bl) {
                string = "ws";
            } else if (bl) {
                string = "wss";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String scheme = string;
            Logger.DefaultImpls.info$default(logger, null, (Function0)new Function0<String>(relayUrl, serverId){
                final /* synthetic */ String $relayUrl;
                final /* synthetic */ String $serverId;
                {
                    this.$relayUrl = $relayUrl;
                    this.$serverId = $serverId;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return Reflection.getOrCreateKotlinClass(ProjectorServer.class).getSimpleName() + " connecting to relay " + this.$relayUrl + " with serverId " + this.$serverId;
                }
            }, 1, null);
            builders.add(new HttpWsClientBuilder(scheme + "://" + relayUrl, serverId));
        }
        if (Boolean.parseBoolean(OptionKt.getOption(ENABLE_WS_SERVER_PROPERTY, "true"))) {
            InetAddress host = ProjectorServer.Companion.getEnvHost$projector_server_common();
            int port = ProjectorServer.Companion.getEnvPort();
            Logger.DefaultImpls.info$default(logger, null, (Function0)new Function0<String>(host, port){
                final /* synthetic */ InetAddress $host;
                final /* synthetic */ int $port;
                {
                    this.$host = $host;
                    this.$port = $port;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return Reflection.getOrCreateKotlinClass(ProjectorServer.class).getSimpleName() + " is starting on host " + this.$host + " and port " + this.$port;
                }
            }, 1, null);
            HttpWsServerBuilder serverBuilder = new HttpWsServerBuilder(host, port);
            serverBuilder.setGetMainWindows((Function0<? extends List<MainWindow>>)((Function0)createTransportBuilders.3.INSTANCE));
            builders.add(serverBuilder);
        }
        return builders;
    }

    static {
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(WebsocketServer.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger(string);
    }
}

