/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.util;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.java_websocket.WebSocketServerFactory;
import org.java_websocket.server.DefaultSSLWebSocketServerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.server.core.util.SSLProperties;
import org.jetbrains.projector.util.loading.OptionKt;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001\u001a\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"SSL_ENV_NAME", "", "SSL_FILE_PATH", "SSL_KEY_PASSWORD", "SSL_STORE_PASSWORD", "SSL_STORE_TYPE", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "loadSSLProperties", "Lorg/jetbrains/projector/server/core/util/SSLProperties;", "path", "setSsl", "setWebSocketFactory", "Lkotlin/Function1;", "Lorg/java_websocket/WebSocketServerFactory;", "", "projector-server-core"})
public final class SslKt {
    @NotNull
    private static final Logger logger = LoggerKt.Logger("KeyKt");
    @NotNull
    public static final String SSL_ENV_NAME = "ORG_JETBRAINS_PROJECTOR_SERVER_SSL_PROPERTIES_PATH";
    @NotNull
    public static final String SSL_STORE_TYPE = "STORE_TYPE";
    @NotNull
    public static final String SSL_FILE_PATH = "FILE_PATH";
    @NotNull
    public static final String SSL_STORE_PASSWORD = "STORE_PASSWORD";
    @NotNull
    public static final String SSL_KEY_PASSWORD = "KEY_PASSWORD";

    @NotNull
    public static final SSLProperties loadSSLProperties(@NotNull String path) {
        Properties properties;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Properties $this$loadSSLProperties_u24lambda_u2d1 = properties = new Properties();
        boolean bl = false;
        $this$loadSSLProperties_u24lambda_u2d1.load(new FileInputStream(path));
        Properties props = properties;
        return new SSLProperties(SslKt.loadSSLProperties$getOrThrow(props, SSL_STORE_TYPE), SslKt.loadSSLProperties$getOrThrow(props, SSL_FILE_PATH), SslKt.loadSSLProperties$getOrThrow(props, SSL_STORE_PASSWORD), SslKt.loadSSLProperties$getOrThrow(props, SSL_KEY_PASSWORD));
    }

    @Nullable
    public static final String setSsl(@NotNull Function1<? super WebSocketServerFactory, Unit> setWebSocketFactory) {
        Intrinsics.checkNotNullParameter(setWebSocketFactory, (String)"setWebSocketFactory");
        String string = OptionKt.getOption(SSL_ENV_NAME);
        if (string == null) {
            return null;
        }
        String sslPropertiesFilePath = string;
        try {
            SSLContext sSLContext;
            SSLProperties sslProperties = SslKt.loadSSLProperties(sslPropertiesFilePath);
            KeyStore keyStore = KeyStore.getInstance(sslProperties.getStoreType());
            Object $this$setSsl_u24lambda_u2d2 = keyStore;
            boolean bl = false;
            InputStream inputStream = new FileInputStream(sslProperties.getFilePath());
            char[] cArray = sslProperties.getStorePassword().toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
            ((KeyStore)$this$setSsl_u24lambda_u2d2).load(inputStream, cArray);
            KeyStore keyStore2 = keyStore;
            Object $this$setSsl_u24lambda_u2d3 = $this$setSsl_u24lambda_u2d2 = KeyManagerFactory.getInstance("SunX509");
            boolean bl2 = false;
            char[] cArray2 = sslProperties.getKeyPassword().toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"this as java.lang.String).toCharArray()");
            ((KeyManagerFactory)$this$setSsl_u24lambda_u2d3).init(keyStore2, cArray2);
            Object keyManagerFactory = $this$setSsl_u24lambda_u2d2;
            Object $this$setSsl_u24lambda_u2d4 = $this$setSsl_u24lambda_u2d3 = TrustManagerFactory.getInstance("SunX509");
            boolean bl3 = false;
            ((TrustManagerFactory)$this$setSsl_u24lambda_u2d4).init(keyStore2);
            Object trustManagerFactory = $this$setSsl_u24lambda_u2d3;
            SSLContext $this$setSsl_u24lambda_u2d5 = sSLContext = SSLContext.getInstance("TLS");
            boolean bl4 = false;
            $this$setSsl_u24lambda_u2d5.init(((KeyManagerFactory)keyManagerFactory).getKeyManagers(), ((TrustManagerFactory)trustManagerFactory).getTrustManagers(), null);
            SSLContext sslContext = sSLContext;
            setWebSocketFactory.invoke((Object)new DefaultSSLWebSocketServerFactory(sslContext));
            return sslPropertiesFilePath;
        }
        catch (Throwable t) {
            logger.info(t, (Function0<String>)((Function0)new Function0<String>(sslPropertiesFilePath){
                final /* synthetic */ String $sslPropertiesFilePath;
                {
                    this.$sslPropertiesFilePath = $sslPropertiesFilePath;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Can't enable SSL from '" + this.$sslPropertiesFilePath + "' file";
                }
            }));
            return null;
        }
    }

    private static final String loadSSLProperties$getOrThrow(Properties $this$loadSSLProperties_u24getOrThrow, String key) {
        String string = $this$loadSSLProperties_u24getOrThrow.getProperty(key);
        if (string == null) {
            boolean bl = false;
            String string2 = "Can't find " + key + " in properties file";
            throw new IllegalArgumentException(string2.toString());
        }
        return string;
    }
}

