/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.ast;

import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.DataKeyBase;
import com.vladsch.flexmark.util.data.DataSet;
import com.vladsch.flexmark.util.data.DataValueFactory;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.data.MutableDataSetter;
import com.vladsch.flexmark.util.data.NullableDataKey;
import com.vladsch.flexmark.util.misc.Utils;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Document
extends Block
implements MutableDataHolder {
    public static final Document NULL = new Document(null, BasedSequence.NULL);
    private final MutableDataSet dataSet;

    @Override
    @NotNull
    public BasedSequence[] getSegments() {
        return EMPTY_SEGMENTS;
    }

    public Document(DataHolder options, BasedSequence chars) {
        super(chars);
        this.dataSet = new MutableDataSet(options);
    }

    @Override
    @NotNull
    public MutableDataHolder clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> MutableDataHolder set(@NotNull DataKey<T> key, @NotNull T value) {
        return this.dataSet.set((DataKey)key, (Object)value);
    }

    @Override
    @NotNull
    public <T> MutableDataHolder set(@NotNull NullableDataKey<T> key, @Nullable T value) {
        return this.dataSet.set((NullableDataKey)key, (Object)value);
    }

    @Override
    @NotNull
    public MutableDataSet setFrom(@NotNull MutableDataSetter dataSetter) {
        return this.dataSet.setFrom(dataSetter);
    }

    @Override
    @NotNull
    public MutableDataSet setAll(@NotNull DataHolder other) {
        return this.dataSet.setAll(other);
    }

    public static MutableDataSet merge(DataHolder ... dataHolders) {
        return MutableDataSet.merge(dataHolders);
    }

    @Override
    @NotNull
    public MutableDataHolder setIn(@NotNull MutableDataHolder dataHolder) {
        return this.dataSet.setIn(dataHolder);
    }

    @Override
    @NotNull
    public MutableDataSet remove(@NotNull DataKeyBase<?> key) {
        return this.dataSet.remove((DataKeyBase)key);
    }

    @Override
    @Nullable
    public Object getOrCompute(@NotNull DataKeyBase<?> key, @NotNull DataValueFactory<?> factory) {
        return this.dataSet.getOrCompute(key, factory);
    }

    @Override
    @NotNull
    public MutableDataSet toMutable() {
        return this.dataSet.toMutable();
    }

    @Override
    @NotNull
    public DataSet toImmutable() {
        return this.dataSet.toImmutable();
    }

    @Override
    @NotNull
    public MutableDataSet toDataSet() {
        return this.dataSet.toDataSet();
    }

    @NotNull
    public static DataHolder aggregateActions(@NotNull DataHolder other, @NotNull DataHolder overrides) {
        return DataSet.aggregateActions(other, overrides);
    }

    @NotNull
    public DataHolder aggregate() {
        return this.dataSet.aggregate();
    }

    @NotNull
    public static DataHolder aggregate(@Nullable DataHolder other, @Nullable DataHolder overrides) {
        return DataSet.aggregate(other, overrides);
    }

    @Override
    @NotNull
    public Map<? extends DataKeyBase<?>, Object> getAll() {
        return this.dataSet.getAll();
    }

    @Override
    @NotNull
    public Collection<? extends DataKeyBase<?>> getKeys() {
        return this.dataSet.getKeys();
    }

    @Override
    public boolean contains(@NotNull DataKeyBase<?> key) {
        return this.dataSet.contains(key);
    }

    @Override
    public int getLineCount() {
        if (this.lineSegments == BasedSequence.EMPTY_LIST) {
            char c = this.getChars().lastChar();
            return (c == '\n' || c == '\r' ? 0 : 1) + this.getLineNumber(this.getChars().length());
        }
        return this.lineSegments.size();
    }

    public int getLineNumber(int offset) {
        if (this.lineSegments == BasedSequence.EMPTY_LIST) {
            BasedSequence preText = this.getChars().baseSubSequence(0, Utils.maxLimit(offset + 1, this.getChars().length()));
            if (preText.isEmpty()) {
                return 0;
            }
            int lineNumber = 0;
            int nextLineEnd = preText.endOfLineAnyEOL(0);
            int length = preText.length();
            while (nextLineEnd < length) {
                int eolLength = preText.eolStartLength(nextLineEnd);
                int lengthWithEOL = nextLineEnd + eolLength;
                if (offset >= lengthWithEOL) {
                    ++lineNumber;
                }
                int oldNextLineEnd = nextLineEnd;
                nextLineEnd = preText.endOfLineAnyEOL(lengthWithEOL);
                assert (nextLineEnd > oldNextLineEnd);
            }
            return lineNumber;
        }
        int iMax = this.lineSegments.size();
        for (int i = 0; i < iMax; ++i) {
            if (offset >= ((BasedSequence)this.lineSegments.get(i)).getEndOffset()) continue;
            return i;
        }
        return iMax;
    }
}

