/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.performancePlugin.Timer;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class RunConfigurationCommand
extends AbstractCommand {
    public static final String PREFIX = "%runConfiguration";
    private static final String WAIT_FOR_PROCESS_STARTED = "TILL_STARTED";
    private static final String WAIT_FOR_PROCESS_TERMINATED = "TILL_TERMINATED";
    private ExecutionEnvironment myExecutionEnvironment;
    private static final Logger LOG = Logger.getInstance(RunConfigurationCommand.class);

    public RunConfigurationCommand(@NotNull String text, int line) {
        if (text == null) {
            RunConfigurationCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
        this.myExecutionEnvironment = new ExecutionEnvironment();
    }

    @NotNull
    protected Promise<Object> _execute(final @NotNull PlaybackContext context) {
        if (context == null) {
            RunConfigurationCommand.$$$reportNull$$$0(1);
        }
        String[] command = this.extractCommandArgument(PREFIX).split(" ", 2);
        final String mode = command[0];
        String configurationNameToRun = command[1];
        final Timer timer = new Timer();
        final ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        Project project = context.getProject();
        final MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarting(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (handler == null) {
                    1.$$$reportNull$$$0(2);
                }
                timer.start();
                RunConfigurationCommand.this.myExecutionEnvironment = env;
                context.message("processStarting: " + env, RunConfigurationCommand.this.getLine());
            }

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (handler == null) {
                    1.$$$reportNull$$$0(5);
                }
                RunConfigurationCommand.this.myExecutionEnvironment = env;
                if (mode.equals(RunConfigurationCommand.WAIT_FOR_PROCESS_STARTED)) {
                    timer.stop();
                    long executionTime = timer.getTotalTime();
                    context.message("processStarted in: " + env + ": " + executionTime, RunConfigurationCommand.this.getLine());
                    actionCallback.setDone();
                }
            }

            public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler, int exitCode) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (handler == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (mode.equals(RunConfigurationCommand.WAIT_FOR_PROCESS_TERMINATED)) {
                    timer.stop();
                    long executionTime = timer.getTotalTime();
                    context.message("processTerminated in: " + env + ": " + executionTime, RunConfigurationCommand.this.getLine());
                    if (env.equals(RunConfigurationCommand.this.myExecutionEnvironment)) {
                        if (exitCode == 0) {
                            actionCallback.setDone();
                        } else {
                            actionCallback.reject("Run configuration is finished with exitCode: " + exitCode);
                        }
                        connection.disconnect();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executorId";
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "env";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/RunConfigurationCommand$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStarting";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStarted";
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)project);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!mode.contains(WAIT_FOR_PROCESS_STARTED) && !mode.contains(WAIT_FOR_PROCESS_TERMINATED)) {
                actionCallback.reject("Specified mode is neither TILL_STARTED nor TILL_TERMINATED");
            }
            DefaultRunExecutor executor = new DefaultRunExecutor();
            ExecutionTarget target = DefaultExecutionTarget.INSTANCE;
            RunConfiguration configurationToRun = RunConfigurationCommand.getConfigurationByName((RunManager)runManager, configurationNameToRun);
            if (configurationToRun == null) {
                actionCallback.reject("Specified configuration is not found: " + configurationNameToRun);
                RunConfigurationCommand.printAllConfigurationsNames((RunManager)runManager);
            } else {
                RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettings = new RunnerAndConfigurationSettingsImpl(runManager, configurationToRun);
                ExecutionManager.getInstance((Project)project).restartRunProfile(project, (Executor)executor, target, (RunnerAndConfigurationSettings)runnerAndConfigurationSettings, null);
            }
        });
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            RunConfigurationCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    public static RunConfiguration getConfigurationByName(RunManager runManager, String configurationName) {
        return (RunConfiguration)ContainerUtil.find((Iterable)runManager.getAllConfigurationsList(), configuration -> configurationName.equals(configuration.getName()));
    }

    private static void printAllConfigurationsNames(RunManager runManager) {
        LOG.info("*****************************");
        LOG.info("Available configurations are:");
        runManager.getAllConfigurationsList().stream().map(RunProfile::getName).forEach(arg_0 -> ((Logger)LOG).info(arg_0));
        LOG.info("*****************************");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/RunConfigurationCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/RunConfigurationCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

