/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.MouseEventAdapter;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.MouseWheelUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/MouseWheelUtils;", "", "()V", "wrapEditorMouseWheelListeners", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "wrapMouseWheelListeners", "component", "Ljava/awt/Component;", "disposable", "Lcom/intellij/openapi/Disposable;", "EditorMouseWheelListenerWrapper", "MouseWheelListenerWrapper", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nMouseWheelUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MouseWheelUtils.kt\norg/jetbrains/plugins/notebooks/visualization/r/inlays/MouseWheelUtils\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,95:1\n37#2,2:96\n37#2,2:98\n*S KotlinDebug\n*F\n+ 1 MouseWheelUtils.kt\norg/jetbrains/plugins/notebooks/visualization/r/inlays/MouseWheelUtils\n*L\n64#1:96,2\n84#1:98,2\n*E\n"})
public final class MouseWheelUtils {
    @NotNull
    public static final MouseWheelUtils INSTANCE = new MouseWheelUtils();

    private MouseWheelUtils() {
    }

    public final void wrapEditorMouseWheelListeners(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        JScrollPane jScrollPane = editor.getScrollPane();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"editor.scrollPane");
        MouseWheelUtils.wrapEditorMouseWheelListeners$addListener(jScrollPane);
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Disposable disposable = editor.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"editor.disposable");
        MessageBusConnection messageBusConnection = messageBus.connect(disposable);
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> MouseWheelUtils.wrapEditorMouseWheelListeners$lambda$1(editor, arg_0));
    }

    public final void wrapMouseWheelListeners(@NotNull Component component, @Nullable Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        MouseWheelUtils.wrapMouseWheelListeners$addListener$3(component);
        if (disposable != null) {
            MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect(disposable);
            Topic topic = LafManagerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, arg_0 -> MouseWheelUtils.wrapMouseWheelListeners$lambda$4(component, arg_0));
        }
    }

    private static final boolean wrapEditorMouseWheelListeners$addListener$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void wrapEditorMouseWheelListeners$addListener(Component component) {
        MouseWheelListener[] mouseWheelListenerArray = component.getMouseWheelListeners();
        Intrinsics.checkNotNullExpressionValue((Object)mouseWheelListenerArray, (String)"component.mouseWheelListeners");
        ArrayList lst = (ArrayList)ArraysKt.toCollection((Object[])mouseWheelListenerArray, (Collection)new ArrayList());
        for (MouseWheelListener listener2 : lst) {
            component.removeMouseWheelListener(listener2);
        }
        lst.removeIf(arg_0 -> MouseWheelUtils.wrapEditorMouseWheelListeners$addListener$lambda$0(wrapEditorMouseWheelListeners.addListener.1.INSTANCE, arg_0));
        Collection $this$toTypedArray$iv = lst;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        component.addMouseWheelListener(new EditorMouseWheelListenerWrapper(thisCollection$iv.toArray(new MouseWheelListener[0])));
    }

    private static final void wrapEditorMouseWheelListeners$lambda$1(EditorImpl $editor, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JScrollPane jScrollPane = $editor.getScrollPane();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"editor.scrollPane");
        MouseWheelUtils.wrapEditorMouseWheelListeners$addListener(jScrollPane);
    }

    private static final boolean wrapMouseWheelListeners$addListener$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void wrapMouseWheelListeners$addListener$3(Component component) {
        MouseWheelListener[] mouseWheelListenerArray = component.getMouseWheelListeners();
        Intrinsics.checkNotNullExpressionValue((Object)mouseWheelListenerArray, (String)"component.mouseWheelListeners");
        ArrayList lst = (ArrayList)ArraysKt.toCollection((Object[])mouseWheelListenerArray, (Collection)new ArrayList());
        for (MouseWheelListener listener2 : lst) {
            component.removeMouseWheelListener(listener2);
        }
        lst.removeIf(arg_0 -> MouseWheelUtils.wrapMouseWheelListeners$addListener$3$lambda$2(wrapMouseWheelListeners.addListener.1.INSTANCE, arg_0));
        Collection $this$toTypedArray$iv = lst;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        component.addMouseWheelListener(new MouseWheelListenerWrapper(component, thisCollection$iv.toArray(new MouseWheelListener[0])));
    }

    private static final void wrapMouseWheelListeners$lambda$4(Component $component, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)$component, (String)"$component");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MouseWheelUtils.wrapMouseWheelListeners$addListener$3($component);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/MouseWheelUtils$EditorMouseWheelListenerWrapper;", "Ljava/awt/event/MouseWheelListener;", "listeners", "", "([Ljava/awt/event/MouseWheelListener;)V", "[Ljava/awt/event/MouseWheelListener;", "mouseWheelMoved", "", "e", "Ljava/awt/event/MouseWheelEvent;", "intellij.notebooks.visualization"})
    private static final class EditorMouseWheelListenerWrapper
    implements MouseWheelListener {
        @NotNull
        private final MouseWheelListener[] listeners;

        public EditorMouseWheelListenerWrapper(@NotNull MouseWheelListener[] listeners) {
            Intrinsics.checkNotNullParameter((Object)listeners, (String)"listeners");
            this.listeners = listeners;
        }

        @Override
        public void mouseWheelMoved(@NotNull MouseWheelEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            for (MouseWheelListener listener2 : this.listeners) {
                listener2.mouseWheelMoved(e);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/MouseWheelUtils$MouseWheelListenerWrapper;", "Ljava/awt/event/MouseWheelListener;", "component", "Ljava/awt/Component;", "listeners", "", "(Ljava/awt/Component;[Ljava/awt/event/MouseWheelListener;)V", "[Ljava/awt/event/MouseWheelListener;", "mouseWheelMoved", "", "e", "Ljava/awt/event/MouseWheelEvent;", "intellij.notebooks.visualization"})
    private static final class MouseWheelListenerWrapper
    implements MouseWheelListener {
        @NotNull
        private final Component component;
        @NotNull
        private final MouseWheelListener[] listeners;

        public MouseWheelListenerWrapper(@NotNull Component component, @NotNull MouseWheelListener[] listeners) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)listeners, (String)"listeners");
            this.component = component;
            this.listeners = listeners;
        }

        @Override
        public void mouseWheelMoved(@NotNull MouseWheelEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            for (MouseWheelListener listener2 : this.listeners) {
                listener2.mouseWheelMoved(e);
            }
            if (!e.isConsumed()) {
                MouseEventAdapter.redispatch((MouseEvent)e, (Component)((Component)ComponentUtil.getParentOfType(JScrollPane.class, (Component)this.component.getParent())));
            }
        }
    }
}

