/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import dk.brics.automaton.RunAutomaton;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import org.editorconfig.core.EditorConfigAutomatonBuilder;
import org.editorconfig.language.codeinsight.inspections.EditorConfigNoMatchingFilesInspection;
import org.editorconfig.language.codeinsight.quickfixes.EditorConfigRemoveSectionQuickFix;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.editorconfig.language.psi.EditorConfigVisitor;
import org.editorconfig.language.util.EditorConfigPsiTreeUtil;
import org.editorconfig.language.util.core.EditorConfigPsiTreeUtilCore;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/editorconfig/language/codeinsight/inspections/EditorConfigNoMatchingFilesInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lorg/editorconfig/language/psi/EditorConfigVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Companion", "intellij.editorconfig"})
public final class EditorConfigNoMatchingFilesInspection
extends LocalInspectionTool {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private static final int CancellationCheckFrequency = 20;

    @NotNull
    public EditorConfigVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new EditorConfigVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitHeader(@NotNull EditorConfigHeader header) {
                boolean found;
                Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                if (!header.isValidGlob()) {
                    return;
                }
                RunAutomaton runAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderRunAutomaton(header);
                EditorConfigPsiTreeUtil editorConfigPsiTreeUtil = EditorConfigPsiTreeUtil.INSTANCE;
                PsiFile file$iv = header.getContainingFile();
                boolean $i$f$getOriginalFile = false;
                PsiFile psiFile = EditorConfigPsiTreeUtilCore.INSTANCE.getOriginalFile(file$iv, Reflection.getOrCreateKotlinClass(PsiFile.class));
                VirtualFile virtualFile = psiFile != null && (psiFile = psiFile.getVirtualFile()) != null ? psiFile.getParent() : null;
                if (virtualFile == null) {
                    return;
                }
                VirtualFile folder = virtualFile;
                Ref.IntRef pass = new Ref.IntRef();
                boolean bl = found = !VfsUtilCore.iterateChildrenRecursively((VirtualFile)folder, null, arg_0 -> buildVisitor.1.visitHeader$lambda$0(pass, runAutomaton, arg_0));
                if (found) {
                    return;
                }
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)folder.getName(), (String)"folder.name");
                String message2 = EditorConfigBundle.INSTANCE.get("inspection.no-matching-files.message", objectArray);
                objectArray = new LocalQuickFix[]{new EditorConfigRemoveSectionQuickFix()};
                this.$holder.registerProblem((PsiElement)header, message2, ProblemHighlightType.LIKE_UNUSED_SYMBOL, (LocalQuickFix[])objectArray);
            }

            private static final boolean visitHeader$lambda$0(Ref.IntRef $pass, RunAutomaton $runAutomaton, VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)$pass, (String)"$pass");
                Intrinsics.checkNotNullParameter((Object)$runAutomaton, (String)"$runAutomaton");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ++$pass.element;
                if ($pass.element % 20 == 0) {
                    ProgressManager.checkCanceled();
                }
                return !it.isValid() || !$runAutomaton.run(it.getPath());
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/editorconfig/language/codeinsight/inspections/EditorConfigNoMatchingFilesInspection$Companion;", "", "()V", "CancellationCheckFrequency", "", "intellij.editorconfig"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

