/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs.importer;

import com.google.gson.JsonElement;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.linter.jscs.importer.AppliedRule;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;

public abstract class ImportRule
implements AppliedRule {
    private String myTextValue;
    private final StringBuilder myResultDescription = new StringBuilder();
    private boolean myApplied;

    protected ImportRule() {
    }

    protected void append(String text) {
        if (this.myResultDescription.length() > 0) {
            this.myResultDescription.append("<br/>");
        }
        this.myResultDescription.append(text);
    }

    public boolean apply(JsonElement element, CommonCodeStyleSettings settings, JSCodeStyleSettings jsCodeStyleSettings) {
        this.myTextValue = element.toString();
        this.myApplied = this.applyImpl(element, settings, jsCodeStyleSettings);
        return this.myApplied;
    }

    protected abstract boolean applyImpl(JsonElement var1, CommonCodeStyleSettings var2, JSCodeStyleSettings var3);

    @Override
    public String getTextValue() {
        return this.myTextValue;
    }

    @Override
    public String getResultDescription() {
        return this.myResultDescription.toString();
    }

    @Override
    public boolean isApplied() {
        return this.myApplied;
    }
}

