/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lexer.FlexLexer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JSLexerUtil {
    public static boolean canBeFlowGenericArgumentList(FlexLexer lexer) throws IOException {
        IElementType next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        if (next != JSTokenTypes.IDENTIFIER) {
            return false;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        return next == JSTokenTypes.GT || next == JSTokenTypes.COMMA || next == JSTokenTypes.EXTENDS_KEYWORD;
    }

    public static boolean isAfterTagGenerics(FlexLexer lexer, CharSequence buffer) throws IOException {
        int initialPosition = lexer.getTokenStart();
        int start = initialPosition;
        if (start >= buffer.length() || start - 1 < 0) {
            return false;
        }
        if (buffer.charAt(start - 1) != '>') {
            return false;
        }
        if (start == buffer.length()) {
            return true;
        }
        Ref posRef = Ref.create();
        while (start + 1 < buffer.length()) {
            if (StringUtil.isWhiteSpace((char)buffer.charAt(start + 1))) {
                ++start;
                continue;
            }
            if (JSLexerUtil.isIllegalCharAfterTagGenerics(buffer.charAt(start + 1))) {
                return false;
            }
            int balance = 1;
            for (int i = initialPosition + 1; i >= 0; --i) {
                posRef.set((Object)i);
                if (JSLexerUtil.skipCommentsBackwards((Ref<Integer>)posRef, buffer.charAt(i), buffer)) {
                    i = (Integer)posRef.get();
                }
                if (i < 0) break;
                char ch = buffer.charAt(i);
                if (ch == '<') {
                    ++balance;
                }
                if (ch == '>') {
                    --balance;
                }
                if (balance > 1) break;
            }
            return balance > 1;
        }
        return false;
    }

    private static boolean isIllegalCharAfterTagGenerics(char c) {
        return c == '<' || c == '/' || c == '{';
    }

    public static boolean shouldLexRegex(FlexLexer lexer, boolean hasTags, CharSequence buffer) {
        int start = lexer.getTokenStart();
        if (start >= buffer.length()) {
            return true;
        }
        --start;
        while (start >= 0) {
            char c = buffer.charAt(start);
            if (Character.isWhitespace(c)) {
                --start;
                continue;
            }
            if (c != '!') {
                if (hasTags && c == '<') {
                    return start + 1 >= buffer.length() || buffer.charAt(start + 1) != '/';
                }
                return true;
            }
            if (start - 1 < 0) {
                return true;
            }
            char ch = buffer.charAt(start - 1);
            if (!Character.isLetter(ch)) {
                return true;
            }
            if (ch != 'n') {
                return false;
            }
            int possible = start - 1 - "return".length();
            if (possible < 0) {
                return false;
            }
            return "return".contentEquals(buffer.subSequence(possible + 1, start));
        }
        return true;
    }

    public static boolean shouldLexTagGenerics(FlexLexer lexer, CharSequence buffer) throws IOException {
        int start = lexer.getTokenStart();
        if (start >= buffer.length()) {
            return false;
        }
        --start;
        Ref startRef = Ref.create();
        while (start >= 0) {
            char c = buffer.charAt(start);
            if (!Character.isLetterOrDigit(c) && c != '.') {
                if (c == '<') {
                    int shift;
                    boolean skip = false;
                    for (shift = start - 1; shift >= 0 && !StringUtil.isLineBreak((char)buffer.charAt(shift)); --shift) {
                        if (buffer.charAt(shift) != '/' || shift - 1 < 0 || buffer.charAt(shift - 1) != '/') continue;
                        skip = true;
                        break;
                    }
                    if (skip) {
                        start = shift;
                        continue;
                    }
                    return true;
                }
                startRef.set((Object)start);
                if (!JSLexerUtil.skipCommentsBackwards((Ref<Integer>)startRef, c, buffer)) {
                    return false;
                }
                start = (Integer)startRef.get();
            }
            --start;
        }
        return false;
    }

    private static boolean skipCommentsBackwards(@NotNull Ref<Integer> startRef, char c, @NotNull CharSequence buffer) {
        int start;
        if (startRef == null) {
            JSLexerUtil.$$$reportNull$$$0(0);
        }
        if (buffer == null) {
            JSLexerUtil.$$$reportNull$$$0(1);
        }
        if (c == '/' && start > 0 && buffer.charAt(start - 1) == '*') {
            for (start = ((Integer)startRef.get()).intValue(); start > 0 && (buffer.charAt(start) != '*' || buffer.charAt(start - 1) != '/'); --start) {
            }
            if (--start < 0) {
                return false;
            }
        } else if (!Character.isWhitespace(c)) {
            char atStart;
            char beforeStart = ' ';
            while (start > 0 && ((atStart = buffer.charAt(start)) != '/' || (beforeStart = buffer.charAt(start - 1)) != '/')) {
                if (StringUtil.isLineBreak((char)atStart) || StringUtil.isLineBreak((char)beforeStart)) {
                    return false;
                }
                --start;
            }
            if (--start < 0) {
                return false;
            }
        }
        startRef.set((Object)start);
        return true;
    }

    public static boolean shouldLexTag(boolean isFlow, FlexLexer lexer) throws IOException {
        IElementType next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        if (next == JSTokenTypes.PLUS || next == JSTokenTypes.MINUS) {
            return false;
        }
        if (!JSKeywordSets.IDENTIFIER_NAMES.contains(next)) {
            return true;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        if (next == JSTokenTypes.EXTENDS_KEYWORD) {
            next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
            return next == JSTokenTypes.EQ;
        }
        if (next == JSTokenTypes.COLON || next == JSTokenTypes.EQ || next == JSTokenTypes.COMMA) {
            return false;
        }
        if (next == JSTokenTypes.GT) {
            next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
            if (next != JSTokenTypes.LPAR) {
                return true;
            }
            return !JSLexerUtil.isParameterListAfterGenericParams(isFlow, lexer);
        }
        return true;
    }

    private static boolean isParameterListAfterGenericParams(boolean isFlow, FlexLexer lexer) throws IOException {
        IElementType next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        int balance = 1;
        if (next == JSTokenTypes.LBRACE || next == JSTokenTypes.LBRACKET) {
            return isFlow;
        }
        if (next == JSTokenTypes.IDENTIFIER && (next = JSLexerUtil.skipCommentsAndWhitespaces(lexer)) == JSTokenTypes.QUEST) {
            next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        }
        if (next == JSTokenTypes.COLON || next == JSTokenTypes.COMMA) {
            return true;
        }
        if (isFlow && next == JSTokenTypes.LPAR) {
            return true;
        }
        if (next != JSTokenTypes.RPAR && !isFlow) {
            return false;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        if (!isFlow) {
            if (next != JSTokenTypes.LT) {
                return true;
            }
            next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
            return next != JSTokenTypes.DIV;
        }
        if (next != JSTokenTypes.LT) {
            while (balance > 0 && next != null) {
                if (next == JSTokenTypes.LPAR) {
                    ++balance;
                }
                if (next == JSTokenTypes.RPAR) {
                    --balance;
                }
                boolean isLt = next == JSTokenTypes.LT;
                next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
                if (!isLt || next != JSTokenTypes.REGEXP_LITERAL) continue;
                return false;
            }
        }
        if (next != JSTokenTypes.LT) {
            return true;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        return JSLexerUtil.checkFlowToken(lexer, next);
    }

    private static boolean checkFlowToken(FlexLexer lexer, IElementType next) throws IOException {
        if (next != JSTokenTypes.IDENTIFIER) {
            return next != JSTokenTypes.REGEXP_LITERAL;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        return next != JSTokenTypes.COMMA && next != JSTokenTypes.EXTENDS_KEYWORD && next != JSTokenTypes.GT;
    }

    private static IElementType skipCommentsAndWhitespaces(FlexLexer lexer) throws IOException {
        IElementType next = lexer.advance();
        while (JSTokenTypes.COMMENTS_AND_WHITESPACES.contains(next)) {
            next = lexer.advance();
        }
        return next;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "startRef";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "buffer";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/JSLexerUtil";
        objectArray[2] = "skipCommentsBackwards";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

