/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.settings;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.php.drupal.DrupalUtil;
import com.jetbrains.php.drupal.DrupalVersion;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="DrupalConfiguration", storages={@Storage(value="$WORKSPACE_FILE$")})
public class DrupalDataService
implements PersistentStateComponent<State> {
    private static final String DRUPAL_PATH_PROPERTY = "drupal.support.drupalPath";
    private static final String DRUPAL_VERSION_PROPERTY = "drupal.support.drupalVersion";
    private static final int DRUPAL_VERSION_DEFAULT_VALUE = 0;
    private final EventDispatcher<DrupalDataListener> myEventDispatcher = EventDispatcher.create(DrupalDataListener.class);
    private boolean isEnabled;
    private String myDrupalPath;
    private DrupalVersion myVersion;
    private boolean myUpdateIncludePath = true;
    private boolean myDoNotAskAgain;

    public static DrupalDataService getInstance(Project project) {
        return (DrupalDataService)ServiceManager.getService((Project)project, DrupalDataService.class);
    }

    public void setState(State state) {
        State oldState = this.getState();
        this.loadState(state);
        this.notifyListeners(state, oldState);
    }

    public String getDrupalPath() {
        return this.myDrupalPath;
    }

    @Nullable
    public static String getLastDrupalPath() {
        return PropertiesComponent.getInstance().getValue(DRUPAL_PATH_PROPERTY);
    }

    @Nullable
    public static DrupalVersion getLastDrupalVersion() {
        int version = PropertiesComponent.getInstance().getInt(DRUPAL_VERSION_PROPERTY, 0);
        return DrupalVersion.getFromNumber(version);
    }

    public boolean isConfigValid() {
        return this.isVersionValid() && DrupalUtil.validateDrupalFolder(this.getDrupalPath(), this.getVersion()) == null;
    }

    public boolean isVersionValid() {
        return this.myVersion != null;
    }

    public DrupalVersion getVersion() {
        return this.myVersion;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isUpdateIncludePath() {
        return this.myUpdateIncludePath;
    }

    public boolean doNotAskAgain() {
        return this.myDoNotAskAgain;
    }

    public void setDoNotAskAgain(boolean doNotAsk) {
        this.myDoNotAskAgain = doNotAsk;
    }

    public void addListener(DrupalDataListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    private void notifyListeners(State state, State oldState) {
        if (state.equals(oldState)) {
            return;
        }
        ((DrupalDataListener)this.myEventDispatcher.getMulticaster()).stateChanged(state, oldState);
    }

    @NotNull
    public State getState() {
        State state = new State(this.isEnabled, this.myDrupalPath, this.myVersion == null ? 0 : this.myVersion.getNumber(), this.myUpdateIncludePath, this.myDoNotAskAgain);
        if (state == null) {
            DrupalDataService.$$$reportNull$$$0(0);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            DrupalDataService.$$$reportNull$$$0(1);
        }
        this.isEnabled = state.isEnabled();
        this.myDrupalPath = state.getDrupalPath();
        this.myVersion = DrupalVersion.getFromNumber(state.getVersion());
        this.myUpdateIncludePath = state.isUpdateIncludePath();
        this.myDoNotAskAgain = state.isDoNotAskAgain();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/drupal/settings/DrupalDataService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/drupal/settings/DrupalDataService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface DrupalDataListener
    extends EventListener {
        public void stateChanged(State var1, State var2);
    }

    @Tag
    public static class State {
        private boolean isEnabled;
        private String myDrupalPath;
        private int myVersion;
        private boolean myUpdateIncludePath = true;
        private boolean myDoNotAskAgain;

        public State() {
        }

        public State(boolean enabled, String drupalPath, int version, boolean updateIncludePath, boolean doNotAskAgain) {
            this.isEnabled = enabled;
            this.myDrupalPath = drupalPath;
            this.myVersion = version;
            this.myUpdateIncludePath = updateIncludePath;
            this.myDoNotAskAgain = doNotAskAgain;
        }

        @Attribute(value="enabled")
        public boolean isEnabled() {
            return this.isEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.isEnabled = enabled;
        }

        @Tag(value="drupalPath")
        public String getDrupalPath() {
            return this.myDrupalPath;
        }

        public void setDrupalPath(String drupalPath) {
            this.myDrupalPath = drupalPath;
        }

        public void setDrupalPathVersionAndUpdateLastUsed(String drupalPath, @Nullable DrupalVersion version) {
            this.setDrupalPath(drupalPath);
            this.setVersion(version == null ? 0 : version.getNumber());
            if (!StringUtil.isEmptyOrSpaces((String)drupalPath)) {
                PropertiesComponent.getInstance().setValue(DrupalDataService.DRUPAL_PATH_PROPERTY, drupalPath);
            }
            PropertiesComponent.getInstance().setValue(DrupalDataService.DRUPAL_VERSION_PROPERTY, version == null ? 0 : version.getNumber(), 0);
        }

        @Attribute(value="version")
        public int getVersion() {
            return this.myVersion;
        }

        public void setVersion(int version) {
            this.myVersion = version;
        }

        @Attribute(value="updateIncludePath")
        public boolean isUpdateIncludePath() {
            return this.myUpdateIncludePath;
        }

        public void setUpdateIncludePath(boolean updateIncludePath) {
            this.myUpdateIncludePath = updateIncludePath;
        }

        @Attribute(value="doNotAskAgain")
        public boolean isDoNotAskAgain() {
            return this.myDoNotAskAgain;
        }

        public void setDoNotAskAgain(boolean doNotAskAgain) {
            this.myDoNotAskAgain = doNotAskAgain;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            if (this.isEnabled != state.isEnabled) {
                return false;
            }
            if (this.myDoNotAskAgain != state.myDoNotAskAgain) {
                return false;
            }
            if (this.myUpdateIncludePath != state.myUpdateIncludePath) {
                return false;
            }
            if (this.myVersion != state.myVersion) {
                return false;
            }
            return !(this.myDrupalPath != null ? !this.myDrupalPath.equals(state.myDrupalPath) : state.myDrupalPath != null);
        }

        public int hashCode() {
            int result = this.isEnabled ? 1 : 0;
            result = 31 * result + (this.myDrupalPath != null ? this.myDrupalPath.hashCode() : 0);
            result = 31 * result + this.myVersion;
            result = 31 * result + (this.myUpdateIncludePath ? 1 : 0);
            result = 31 * result + (this.myDoNotAskAgain ? 1 : 0);
            return result;
        }
    }
}

