/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.trello;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.intellij.tasks.impl.gson.TaskGsonUtil;
import com.intellij.tasks.trello.model.TrelloBoard;
import com.intellij.tasks.trello.model.TrelloCard;
import com.intellij.tasks.trello.model.TrelloCommentAction;
import com.intellij.tasks.trello.model.TrelloLabel;
import com.intellij.tasks.trello.model.TrelloList;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class TrelloUtil {
    public static final Pattern TRELLO_ID_PATTERN = Pattern.compile("[a-z0-9]{24}");
    public static final Gson GSON = TrelloUtil.buildGson();
    public static final String TRELLO_API_BASE_URL = "https://api.trello.com/1";
    public static final TypeToken<List<TrelloCard>> LIST_OF_CARDS_TYPE = new TypeToken<List<TrelloCard>>(){};
    public static final TypeToken<List<TrelloBoard>> LIST_OF_BOARDS_TYPE = new TypeToken<List<TrelloBoard>>(){};
    public static final TypeToken<List<TrelloList>> LIST_OF_LISTS_TYPE = new TypeToken<List<TrelloList>>(){};
    public static final TypeToken<List<TrelloCommentAction>> LIST_OF_COMMENTS_TYPE = new TypeToken<List<TrelloCommentAction>>(){};

    private static Gson buildGson() {
        GsonBuilder gson = TaskGsonUtil.createDefaultBuilder();
        gson.registerTypeAdapter(TrelloLabel.LabelColor.class, (Object)new LabelColorDeserializer());
        return gson.create();
    }

    private static class LabelColorDeserializer
    implements JsonDeserializer<TrelloLabel.LabelColor> {
        private LabelColorDeserializer() {
        }

        public TrelloLabel.LabelColor deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String colorName = json.getAsString().toUpperCase(Locale.US);
            if (colorName.isEmpty()) {
                return TrelloLabel.LabelColor.NO_COLOR;
            }
            try {
                return TrelloLabel.LabelColor.valueOf(colorName);
            }
            catch (IllegalArgumentException e) {
                return TrelloLabel.LabelColor.NO_COLOR;
            }
        }
    }
}

