/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.slicer;

import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpEval;
import com.jetbrains.php.lang.psi.elements.PhpExit;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpPrintExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpThrow;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.slicer.PhpSliceDereferenceUsage;
import com.jetbrains.php.slicer.PhpSliceLeafUsage;
import com.jetbrains.php.slicer.PhpSliceUsage;
import com.jetbrains.php.slicer.PhpSliceUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSliceForwardUtil {
    public static boolean processUsagesFlownFromThe(@NotNull PsiElement element, @NotNull Processor<SliceUsage> processor, @NotNull PhpSliceUsage parent) {
        PsiElement target;
        if (element == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(2);
        }
        if ((target = PhpSliceForwardUtil.getAssignmentTarget(element)) != null) {
            SliceUsage usage = PhpSliceUtil.createSliceUsage(target, parent);
            return processor.process((Object)usage);
        }
        if (element instanceof Variable) {
            return PhpSliceForwardUtil.processAssignedFrom(element, element, parent, processor);
        }
        if (element instanceof Parameter) {
            return PhpSliceForwardUtil.processAssignedFrom(element, element, parent, processor);
        }
        if (element instanceof Function) {
            return PhpSliceForwardUtil.processAssignedFrom(element, element, parent, processor);
        }
        if (element instanceof Field) {
            return PhpSliceForwardUtil.processAssignedFrom(element, element, parent, processor);
        }
        if (element instanceof PhpTraitUseRule) {
            return PhpSliceForwardUtil.processTraitUseRule((PhpTraitUseRule)element, parent, processor);
        }
        if (element instanceof PhpThrow) {
            return PhpSliceForwardUtil.processThrow(element, processor, parent);
        }
        return true;
    }

    protected static boolean processThrow(@NotNull PsiElement element, @NotNull Processor<? super SliceUsage> processor, @NotNull PhpSliceUsage parent) {
        Try tryElement;
        if (element == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(5);
        }
        if ((tryElement = (Try)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)((Condition)element1 -> element1 instanceof Try))) == null) {
            return true;
        }
        for (Catch catchClause : tryElement.getCatchClauses()) {
            SliceUsage usage;
            Variable exception = catchClause.getException();
            if (exception == null || processor.process((Object)(usage = PhpSliceUtil.createSliceUsage((PsiElement)exception, parent)))) continue;
            return false;
        }
        return true;
    }

    private static boolean processAssignedFrom(PsiElement from, PsiElement context, PhpSliceUsage parent, @NotNull Processor<? super SliceUsage> processor) {
        if (processor == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(6);
        }
        if (from instanceof Variable) {
            return PhpSliceForwardUtil.searchReferencesAndProcessAssignmentTarget(from, context, (Ref<PsiElement>)new Ref(), parent, processor);
        }
        if (from instanceof Field) {
            return PhpSliceForwardUtil.searchReferencesAndProcessAssignmentTarget(from, null, null, parent, processor);
        }
        if (from instanceof Parameter) {
            Parameter parameter = (Parameter)from;
            Function function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)parameter, false, (Condition<? super PsiElement>)Function.INSTANCEOF);
            if (function == null) {
                return false;
            }
            THashSet parametersToAnalyze = new THashSet();
            if (function instanceof Method) {
                Method method = (Method)function;
                int index = ArrayUtilRt.find((Object[])method.getParameters(), (Object)parameter);
                THashSet superMethods = new THashSet(PhpSliceForwardUtil.findDeepestSuperMethods(method, parent.getScope()));
                superMethods.add(method);
                THashSet implementors = new THashSet((Collection)superMethods);
                PhpIndex phpIndex = PhpIndex.getInstance((Project)method.getProject());
                for (Method superMethod : superMethods) {
                    ProgressManager.checkCanceled();
                    PhpClassHierarchyUtils.HierarchyClassMemberProcessor implementorsProcessor = (classMember, subClass, baseClass) -> {
                        ProgressManager.checkCanceled();
                        if (classMember instanceof Method) {
                            implementors.add((Object)((Method)classMember));
                        }
                        return true;
                    };
                    boolean processed = PhpClassHierarchyUtils.processOverridingMembers((PhpClassMember)superMethod, (PhpIndex)phpIndex, (PhpClassHierarchyUtils.HierarchyClassMemberProcessor)implementorsProcessor);
                    if (processed) continue;
                    return false;
                }
                for (Method implementor : implementors) {
                    ProgressManager.checkCanceled();
                    if (!parent.params.scope.contains((PsiElement)implementor)) continue;
                    Parameter[] parameters = implementor.getParameters();
                    if (index == -1 || index >= parameters.length) continue;
                    parametersToAnalyze.add(parameters[index]);
                }
            } else {
                parametersToAnalyze.add(parameter);
            }
            for (Parameter psiParameter : parametersToAnalyze) {
                ProgressManager.checkCanceled();
                if (PhpSliceForwardUtil.searchReferencesAndProcessAssignmentTarget((PsiElement)psiParameter, null, (Ref<PsiElement>)new Ref(), parent, processor)) continue;
                return false;
            }
            return true;
        }
        if (from instanceof Function) {
            THashSet functionsToProcess = new THashSet();
            functionsToProcess.add((Function)from);
            if (from instanceof Method) {
                Method method = (Method)from;
                functionsToProcess.addAll(PhpSliceForwardUtil.findDeepestSuperMethods(method, parent.getScope()));
                if (method.getNameCS().equals("__toString")) {
                    PhpSliceForwardUtil.handleToStringMagicMethod(method, processor, parent);
                }
            }
            THashSet processed = new THashSet();
            Ref lowerBorder = null;
            for (Function containingMethod : functionsToProcess) {
                if (ReferencesSearch.search((PsiElement)containingMethod, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).forEach(arg_0 -> PhpSliceForwardUtil.lambda$processAssignedFrom$2((Set)processed, parent, lowerBorder, processor, arg_0))) continue;
                return false;
            }
        }
        return true;
    }

    private static void handleToStringMagicMethod(Method method, @NotNull Processor<? super SliceUsage> processor, PhpSliceUsage parent) {
        PhpClass containingClass;
        if (processor == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(7);
        }
        if ((containingClass = method.getContainingClass()) != null) {
            ReferencesSearch.search((PsiElement)containingClass, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).forEach(reference -> {
                PsiElement par;
                if (processor == null) {
                    PhpSliceForwardUtil.$$$reportNull$$$0(16);
                }
                if (reference instanceof ClassReference) {
                    PsiElement par2 = ((ClassReference)reference).getParent();
                    if (par2 instanceof NewExpression) {
                        PsiElement grandParent = par2.getParent();
                        if (grandParent instanceof AssignmentExpression) {
                            PhpPsiElement variable2 = ((AssignmentExpression)grandParent).getVariable();
                            if (variable2 != null) {
                                PhpSliceForwardUtil.searchReferencesAndProcessVariableToStringCasts(variable2, processor, parent);
                            }
                        } else {
                            PhpSliceForwardUtil.tryHandleToStringCast(grandParent, processor, parent);
                        }
                    }
                } else if (reference instanceof PhpDocType && (par = ((PhpDocType)reference).getParent()) instanceof PhpDocParamTag) {
                    PhpIndex index = PhpIndex.getInstance((Project)par.getProject());
                    index.getVariablesByName(((PhpDocParamTag)par).getVarName()).stream().filter(arg_0 -> ((AnalysisScope)parent.getScope()).contains(arg_0)).forEach(variable -> {
                        if (processor == null) {
                            PhpSliceForwardUtil.$$$reportNull$$$0(17);
                        }
                        PhpSliceForwardUtil.searchReferencesAndProcessVariableToStringCasts((PhpPsiElement)variable, processor, parent);
                    });
                }
            });
        }
    }

    private static void searchReferencesAndProcessVariableToStringCasts(PhpPsiElement variable, @NotNull Processor<? super SliceUsage> processor, PhpSliceUsage parent) {
        if (processor == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(8);
        }
        ReferencesSearch.search((PsiElement)variable, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).forEach(variableReference -> {
            if (processor == null) {
                PhpSliceForwardUtil.$$$reportNull$$$0(15);
            }
            if (variableReference instanceof Variable) {
                PsiElement variableParent = ((Variable)variableReference).getParent();
                PhpSliceForwardUtil.tryHandleToStringCast(variableParent, processor, parent);
            }
        });
    }

    private static void tryHandleToStringCast(PsiElement elementParent, @NotNull Processor<? super SliceUsage> processor, PhpSliceUsage parent) {
        if (processor == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(9);
        }
        if (elementParent instanceof UnaryExpression && PhpPsiUtil.isOfType(((UnaryExpression)elementParent).getOperation(), PhpTokenTypes.opSTRING_CAST)) {
            SliceUsage usage = PhpSliceUtil.createSliceUsage(elementParent, parent);
            processor.process((Object)usage);
        }
    }

    private static boolean searchReferencesAndProcessAssignmentTarget(@NotNull PsiElement element, @Nullable PsiElement context, @Nullable Ref<PsiElement> lowerBorder, PhpSliceUsage parent, Processor<? super SliceUsage> processor) {
        if (element == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(10);
        }
        return ReferencesSearch.search((PsiElement)element).forEach(reference -> {
            PsiElement element1 = reference.getElement();
            if (context != null && element1.getTextOffset() < context.getTextOffset()) {
                return true;
            }
            return PhpSliceForwardUtil.processAssignmentTarget(element1, parent, lowerBorder, processor);
        });
    }

    private static boolean processAssignmentTarget(PsiElement element, PhpSliceUsage parent, @Nullable Ref<PsiElement> lowerBorder, Processor<? super SliceUsage> processor) {
        if (!parent.params.scope.contains(element)) {
            return true;
        }
        if (lowerBorder != null && !lowerBorder.isNull() && element.getTextOffset() > ((PsiElement)lowerBorder.get()).getTextOffset()) {
            return true;
        }
        PsiElement target = PhpSliceForwardUtil.getAssignmentTarget(element);
        if (target != null) {
            SliceUsage usage = PhpSliceUtil.createSliceUsage(element, parent);
            return processor.process((Object)usage);
        }
        PsiElement psiParent = element.getParent();
        if (psiParent instanceof UnaryExpression && PhpPsiUtil.isOfType(psiParent, PhpElementTypes.POSTFIX_EXPRESSION, PhpElementTypes.INFIX_WRITE_EXPRESSION) && PhpPsiUtil.isOfType(((UnaryExpression)psiParent).getOperation(), PhpTokenTypes.opDECREMENT, PhpTokenTypes.opINCREMENT) && element.equals(((UnaryExpression)psiParent).getValue())) {
            if (lowerBorder != null && (lowerBorder.isNull() || ((PsiElement)lowerBorder.get()).getTextOffset() > psiParent.getTextOffset())) {
                lowerBorder.set((Object)psiParent);
            }
            if (PhpPsiUtil.isOfType(psiParent, PhpElementTypes.POSTFIX_EXPRESSION)) {
                SliceUsage usage = PhpSliceUtil.createSliceUsage(psiParent, parent);
                return processor.process((Object)usage);
            }
        }
        if (PhpSliceForwardUtil.isTerminalKeywordExpression(psiParent)) {
            PhpSliceLeafUsage usage = new PhpSliceLeafUsage(element, parent);
            return processor.process((Object)usage);
        }
        if (psiParent instanceof SelfAssignmentExpression && element.equals(((SelfAssignmentExpression)psiParent).getValue())) {
            PhpSliceLeafUsage usage = new PhpSliceLeafUsage(element, parent);
            return processor.process((Object)usage);
        }
        if (psiParent instanceof BinaryExpression && (element.equals(((BinaryExpression)psiParent).getLeftOperand()) || element.equals(((BinaryExpression)psiParent).getRightOperand()))) {
            PhpSliceLeafUsage usage = new PhpSliceLeafUsage(psiParent, parent);
            return processor.process((Object)usage);
        }
        if (psiParent instanceof ControlStatement && element.equals(((ControlStatement)psiParent).getCondition()) && PhpPsiUtil.appliesAtLeastOne(psiParent, If.INSTANCEOF, ElseIf.INSTANCEOF, ForeachStatement.INSTANCEOF, While.INSTANCEOF, DoWhile.INSTANCEOF)) {
            PhpSliceLeafUsage usage = new PhpSliceLeafUsage(element, parent);
            return processor.process((Object)usage);
        }
        if (psiParent instanceof PhpSwitch && element.equals(((PhpSwitch)psiParent).getArgument())) {
            PhpSliceLeafUsage usage = new PhpSliceLeafUsage(element, parent);
            return processor.process((Object)usage);
        }
        if (psiParent instanceof PhpThrow) {
            SliceUsage usage = PhpSliceUtil.createSliceUsage(psiParent, parent);
            return processor.process((Object)usage);
        }
        if (parent.params.showInstanceDereferences && PhpSliceForwardUtil.isDereferenced(element)) {
            PhpSliceDereferenceUsage usage = new PhpSliceDereferenceUsage(psiParent, parent);
            return processor.process((Object)usage);
        }
        return true;
    }

    private static boolean isDereferenced(PsiElement element) {
        if (!(element instanceof PhpReference)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof MemberReference)) {
            return false;
        }
        return element.equals(((MemberReference)parent).getClassReference());
    }

    @Nullable
    private static PsiElement getAssignmentTarget(PsiElement element) {
        element = PhpSliceForwardUtil.complexify(element);
        Object target = null;
        PsiElement parent = element.getParent();
        if (parent instanceof AssignmentExpression && !(parent instanceof SelfAssignmentExpression)) {
            AssignmentExpression assignment = (AssignmentExpression)parent;
            if (element.equals(assignment.getValue())) {
                PhpPsiElement left = assignment.getVariable();
                target = left instanceof PhpReference && !(left instanceof Variable) ? ((PhpReference)left).resolve() : left;
            }
        } else if (parent instanceof ParameterList) {
            PsiElement grandParent = parent.getParent();
            PsiElement resolvePotentialFunction = null;
            if (grandParent instanceof FunctionReference) {
                FunctionReference methodCall = (FunctionReference)grandParent;
                resolvePotentialFunction = methodCall.resolve();
            } else if (grandParent instanceof NewExpression) {
                ClassReference classReference = ((NewExpression)grandParent).getClassReference();
                if (classReference != null) {
                    PsiElement referenceResolve = classReference.resolve();
                    resolvePotentialFunction = referenceResolve instanceof Method ? (Method)referenceResolve : (referenceResolve instanceof PhpClass ? ((PhpClass)referenceResolve).getConstructor() : null);
                }
            } else if (grandParent instanceof PhpClass) {
                resolvePotentialFunction = ((PhpClass)grandParent).getConstructor();
            }
            if (resolvePotentialFunction instanceof Function) {
                Parameter[] parameters;
                Object[] expressions = ((ParameterList)parent).getParameters();
                int index = ArrayUtilRt.find((Object[])expressions, (Object)element);
                Function method = (Function)resolvePotentialFunction;
                if (index != -1 && index < (parameters = method.getParameters()).length) {
                    target = parameters[index];
                }
            }
        } else if (parent instanceof PhpReturn) {
            PhpReturn statement = (PhpReturn)parent;
            if (element.equals(statement.getArgument())) {
                target = PhpPsiUtil.getParentByCondition((PsiElement)statement, (Condition<? super PsiElement>)Function.INSTANCEOF);
            }
        } else if (parent instanceof PhpPsiElement && PhpPsiUtil.isOfType(parent, PhpElementTypes.PARAMETER_DEFAULT_VALUE)) {
            target = PhpPsiUtil.getParentByCondition(parent, (Condition<? super PsiElement>)Parameter.INSTANCEOF);
        } else if (element instanceof MethodReference && parent instanceof PhpTraitUseRule && element.equals(((PhpTraitUseRule)parent).getOriginalReference())) {
            target = parent;
        } else if (parent instanceof Field && element.equals(((Field)parent).getDefaultValue())) {
            target = parent;
        } else if (parent instanceof TernaryExpression && (element.equals(((TernaryExpression)parent).getFalseVariant()) || element.equals(((TernaryExpression)parent).getTrueVariant()))) {
            target = PhpSliceForwardUtil.getAssignmentTarget(parent);
        }
        return target;
    }

    private static boolean processTraitUseRule(PhpTraitUseRule element, PhpSliceUsage parent, Processor<SliceUsage> processor) {
        return true;
    }

    @NotNull
    public static PsiElement complexify(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(11);
        }
        if ((parent = element.getParent()) instanceof UnaryExpression && PhpPsiUtil.isOfType(parent, PhpElementTypes.CAST_EXPRESSION) && element.equals(((UnaryExpression)parent).getValue())) {
            PsiElement psiElement = PhpSliceForwardUtil.complexify(parent);
            if (psiElement == null) {
                PhpSliceForwardUtil.$$$reportNull$$$0(12);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(13);
        }
        return psiElement;
    }

    public static Collection<Method> findDeepestSuperMethods(@NotNull Method method, AnalysisScope scope) {
        if (method == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(14);
        }
        THashMap superMethods = new THashMap();
        PhpClassHierarchyUtils.HierarchyClassMemberProcessor processor = (arg_0, arg_1, arg_2) -> PhpSliceForwardUtil.lambda$findDeepestSuperMethods$7(scope, (Map)superMethods, arg_0, arg_1, arg_2);
        PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)method, (PhpClassHierarchyUtils.HierarchyClassMemberProcessor)processor);
        return superMethods.values();
    }

    private static boolean isTerminalKeywordExpression(@Nullable PsiElement element) {
        return element instanceof PhpPrintExpression || element instanceof PhpEchoStatement || element instanceof PhpEval || element instanceof PhpEmpty || element instanceof PhpIsset || element instanceof PhpExit || element instanceof PhpPsiElement && element.getParent() instanceof ArrayCreationExpression;
    }

    private static /* synthetic */ boolean lambda$findDeepestSuperMethods$7(AnalysisScope scope, Map superMethods, PhpClassMember classMember, PhpClass subClass, PhpClass baseClass) {
        ProgressManager.checkCanceled();
        if (classMember instanceof Method && scope.contains((PsiElement)classMember)) {
            superMethods.put(subClass, (Method)classMember);
            superMethods.remove(baseClass);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ boolean lambda$processAssignedFrom$2(Set processed, PhpSliceUsage parent, Ref lowerBorder, @NotNull Processor processor, PsiReference reference) {
        if (processor == null) {
            PhpSliceForwardUtil.$$$reportNull$$$0(18);
        }
        ProgressManager.checkCanceled();
        Set set = processed;
        synchronized (set) {
            if (!processed.add(reference)) {
                return true;
            }
        }
        PsiElement element = reference.getElement();
        return PhpSliceForwardUtil.processAssignmentTarget(element, parent, (Ref<PsiElement>)lowerBorder, (Processor<? super SliceUsage>)processor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/slicer/PhpSliceForwardUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/slicer/PhpSliceForwardUtil";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "complexify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processUsagesFlownFromThe";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processThrow";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processAssignedFrom";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleToStringMagicMethod";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "searchReferencesAndProcessVariableToStringCasts";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryHandleToStringCast";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "searchReferencesAndProcessAssignmentTarget";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "complexify";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findDeepestSuperMethods";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$searchReferencesAndProcessVariableToStringCasts$5";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$handleToStringMagicMethod$4";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processAssignedFrom$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

