/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpUnusedClassInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnusedClassInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpClass(PhpClass clazz) {
                String className = clazz.getName();
                if (StringUtil.isEmptyOrSpaces((String)className)) {
                    return;
                }
                ASTNode nameNode = clazz.getNameNode();
                if (nameNode == null) {
                    return;
                }
                PsiElement namePsiElement = clazz.getNameIdentifier();
                if (namePsiElement == null) {
                    return;
                }
                Project project = holder.getProject();
                if (!PhpUnusedClassInspection.hasClassReference(project, clazz)) {
                    holder.registerProblem(namePsiElement, "Class '#ref' is never used", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpUnusedClassInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    protected static boolean hasClassReference(@NotNull Project project, @NotNull PhpClass clazz) {
        String className;
        if (project == null) {
            PhpUnusedClassInspection.$$$reportNull$$$0(2);
        }
        if (clazz == null) {
            PhpUnusedClassInspection.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmptyOrSpaces((String)(className = clazz.getName()))) {
            return true;
        }
        PsiFile containingFile = clazz.getContainingFile();
        if (containingFile == null) {
            return true;
        }
        PsiSearchHelper psiSearchHelper = PsiSearchHelper.getInstance((Project)project);
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        SearchScope globeScope = clazz.getUseScope();
        if (!(globeScope instanceof GlobalSearchScope)) {
            return true;
        }
        PsiSearchHelper.SearchCostResult cheapEnough = psiSearchHelper.isCheapEnoughToSearch(className, (GlobalSearchScope)globeScope, containingFile, progress);
        if (cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
            return true;
        }
        return PhpPsiUtil.hasReferences(project, (PsiElement)clazz);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnusedClassInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnusedClassInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasClassReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

