/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.findUsages;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpTargetElementEvaluator;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.findUsages.PhpConstructorReferenceSearcher;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.refactoring.rename.PhpRenameSearchParameters;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class PhpAliasReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public PhpAliasReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters parameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement refElement;
        if (parameters == null) {
            PhpAliasReferenceSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            PhpAliasReferenceSearcher.$$$reportNull$$$0(1);
        }
        if ((refElement = parameters.getElementToSearch()) instanceof PhpUse) {
            PhpUse use = (PhpUse)refElement;
            PhpAliasReferenceSearcher.searchUseAlias(parameters, use, use.isOfConst());
        } else if (!(parameters instanceof PhpRenameSearchParameters) && (refElement instanceof PhpClass || refElement instanceof Function || refElement instanceof Constant || refElement instanceof PhpNamespace)) {
            PhpNamedElement namedElement = (PhpNamedElement)refElement;
            if (namedElement instanceof Method) {
                PhpClass phpClass = ((Method)namedElement).getContainingClass();
                if (phpClass != null) {
                    String methodName = namedElement.getName();
                    if ("__construct".equals(methodName) || PhpLangUtil.equalsClassNames(methodName, phpClass.getName())) {
                        namedElement = phpClass;
                    }
                } else {
                    return;
                }
            }
            String name = namedElement.getName();
            String fqn = namedElement.getFQN();
            Collection<PhpUse> uses = PhpAliasReferenceSearcher.findUses(parameters, name);
            for (PhpUse use : uses) {
                if (!PhpLangUtil.equalsIgnoreCase(fqn, use.getFQN())) continue;
                PhpAliasReferenceSearcher.searchUseAlias(parameters, use, namedElement instanceof Constant);
            }
        }
    }

    @NotNull
    private static Collection<PhpUse> findUses(@NotNull ReferencesSearch.SearchParameters parameters, @NotNull String name) {
        SearchScope scope;
        if (parameters == null) {
            PhpAliasReferenceSearcher.$$$reportNull$$$0(2);
        }
        if (name == null) {
            PhpAliasReferenceSearcher.$$$reportNull$$$0(3);
        }
        if ((scope = parameters.getEffectiveSearchScope()) instanceof LocalSearchScope) {
            THashSet uses = ContainerUtil.newTroveSet();
            for (PsiElement element : ((LocalSearchScope)scope).getScope()) {
                PhpPsiElement scopeHolder = PhpCodeInsightUtil.findScopeForUseOperator(element);
                if (scopeHolder == null) continue;
                for (PhpUseList useList : PhpCodeInsightUtil.collectImports(scopeHolder)) {
                    Collections.addAll(uses, useList.getDeclarations());
                }
                if (!(scopeHolder instanceof PhpFile)) continue;
                for (PhpNamespace namespace : PhpCodeInsightUtil.collectNamespaces((PsiFile)((PhpFile)scopeHolder))) {
                    for (PhpUseList useList : PhpCodeInsightUtil.collectImports((PhpPsiElement)namespace)) {
                        Collections.addAll(uses, useList.getDeclarations());
                    }
                }
            }
            THashSet tHashSet = uses;
            if (tHashSet == null) {
                PhpAliasReferenceSearcher.$$$reportNull$$$0(4);
            }
            return tHashSet;
        }
        Collection collection = PhpIndex.getInstance((Project)parameters.getProject()).getUseAliasesByReferenceName(name);
        if (collection == null) {
            PhpAliasReferenceSearcher.$$$reportNull$$$0(5);
        }
        return collection;
    }

    private static void searchUseAlias(@NotNull ReferencesSearch.SearchParameters parameters, @NotNull PhpUse use, boolean caseSensitive) {
        PhpPsiElement useScope;
        String aliasedName;
        if (parameters == null) {
            PhpAliasReferenceSearcher.$$$reportNull$$$0(6);
        }
        if (use == null) {
            PhpAliasReferenceSearcher.$$$reportNull$$$0(7);
        }
        if ((aliasedName = use.getAliasName()) != null && (useScope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)use)) != null) {
            SearchScope scope = PhpConstructorReferenceSearcher.getEffectiveSearchScope(parameters).intersectWith((SearchScope)new LocalSearchScope((PsiElement)useScope));
            MyRequestResultProcessor processor = new MyRequestResultProcessor((PsiElement)use);
            parameters.getOptimizer().searchWord(aliasedName, scope, (short)1, caseSensitive, (PsiElement)use, (RequestResultProcessor)processor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/findUsages/PhpAliasReferenceSearcher";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "use";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/findUsages/PhpAliasReferenceSearcher";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findUses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processQuery";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findUses";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "searchUseAlias";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyRequestResultProcessor
    extends RequestResultProcessor {
        private static final PsiReferenceService ourReferenceService = PsiReferenceService.getService();
        private final PsiElement myTarget;

        MyRequestResultProcessor(@NotNull PsiElement target) {
            if (target == null) {
                MyRequestResultProcessor.$$$reportNull$$$0(0);
            }
            super(new Object[]{target});
            this.myTarget = target;
        }

        public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
            if (element == null) {
                MyRequestResultProcessor.$$$reportNull$$$0(1);
            }
            if (consumer == null) {
                MyRequestResultProcessor.$$$reportNull$$$0(2);
            }
            if (!this.myTarget.isValid()) {
                return false;
            }
            for (PsiReference ref : ourReferenceService.getReferences(element, new PsiReferenceService.Hints(this.myTarget, Integer.valueOf(offsetInElement)))) {
                ProgressManager.checkCanceled();
                if (!ReferenceRange.containsOffsetInElement((PsiReference)ref, (int)offsetInElement) || this.myTarget != PhpTargetElementEvaluator.getElementByReference(ref) || consumer.process((Object)ref)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/findUsages/PhpAliasReferenceSearcher$MyRequestResultProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTextOccurrence";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

