/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtilRt;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerProjectSettings;
import com.jetbrains.php.composer.addDependency.AddDependencyForm;
import com.jetbrains.php.composer.addDependency.AddDependencySettingsPanel;
import com.jetbrains.php.composer.addDependency.ComposerPackage;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerCreateProjectForm {
    private JPanel myMainPanel;
    private AddDependencyForm myAddDependencyForm;
    private AddDependencySettingsPanel myAddDependencySettingsPanel;
    private final List<WebProjectGenerator.SettingsStateListener> myStateListeners;

    public ComposerCreateProjectForm() {
        this.$$$setupUI$$$();
        this.myStateListeners = ContainerUtilRt.newArrayList();
        this.fireStateChanged();
        this.myAddDependencySettingsPanel.resetOrGuessDefaults();
    }

    private void createUIComponents() {
        Runnable consumer = () -> this.fireStateChanged();
        this.myAddDependencyForm = new AddDependencyForm(true, true, consumer, true);
        this.myAddDependencySettingsPanel = new AddDependencySettingsPanel(consumer, ProjectManager.getInstance().getDefaultProject());
    }

    public JComponent getContentPane() {
        return this.myMainPanel;
    }

    @Nullable
    public ValidationInfo validate() {
        ValidationInfo info = this.myAddDependencyForm.validate();
        if (info != null) {
            return info;
        }
        return this.myAddDependencySettingsPanel.validate();
    }

    public void addSettingsStateListener(WebProjectGenerator.SettingsStateListener listener) {
        this.myStateListeners.add(listener);
    }

    private void fireStateChanged() {
        boolean validSettings = this.validate() == null;
        for (WebProjectGenerator.SettingsStateListener listener : this.myStateListeners) {
            listener.stateChanged(validSettings);
        }
    }

    @NotNull
    public ComposerProjectSettings getSettings() {
        boolean download = this.myAddDependencySettingsPanel.isDownloadPhar();
        ComposerPackage aPackage = this.myAddDependencyForm.getSelectedPackage();
        assert (aPackage != null);
        String version = this.myAddDependencyForm.getVersion();
        String options = this.myAddDependencySettingsPanel.getCommandLineParameters();
        ComposerDataService.ExecutionData executionData = this.myAddDependencySettingsPanel.getExecutionData();
        ComposerProjectSettings composerProjectSettings = new ComposerProjectSettings(download, aPackage, version, options, executionData);
        if (composerProjectSettings == null) {
            ComposerCreateProjectForm.$$$reportNull$$$0(0);
        }
        return composerProjectSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/composer/ComposerCreateProjectForm", "getSettings"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Package", (int)0, (int)0, null, null));
        AddDependencyForm addDependencyForm = this.myAddDependencyForm;
        JComponent jComponent = addDependencyForm.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        AddDependencySettingsPanel addDependencySettingsPanel = this.myAddDependencySettingsPanel;
        JComponent jComponent2 = addDependencySettingsPanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

