/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.DatabaseIcons;
import java.sql.SQLException;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericDialect
extends AbstractDatabaseDialect {
    public static final GenericDialect INSTANCE = new GenericDialect();
    public static final Set<Dbms> DEFAULT_LIMIT_DBS = ContainerUtil.newLinkedHashSet((Object[])new Dbms[]{Dbms.PRESTO, Dbms.INFORMIX, Dbms.IMPALA, Dbms.NETEZZA, Dbms.PHOENIX, Dbms.HIVE, Dbms.SNOWFLAKE});
    public static final Set<Dbms> TOP_LIMIT_DBS = ContainerUtil.newLinkedHashSet((Object[])new Dbms[]{Dbms.TERADATA, Dbms.OPENEDGE, Dbms.FRONTBASE});

    public GenericDialect() {
        super(new TypeHelper(){

            @Override
            public String getTypeName(int code, int length, int precision, int scale) {
                return null;
            }
        }, Casing.create((Case)Case.MIXED, (Case)Case.MIXED));
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.UNKNOWN;
        if (dbms == null) {
            GenericDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            GenericDialect.$$$reportNull$$$0(1);
        }
        String string = dataType.jdbcType == 0 ? dataType.getSpecification() : JdbcUtil.getJdbcTypeName((DataType)dataType);
        if (string == null) {
            GenericDialect.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public ObjectKind getSearchPathObjectKind() {
        return null;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection2) throws SQLException {
        if (system == null) {
            GenericDialect.$$$reportNull$$$0(3);
        }
        if (connection2 == null) {
            GenericDialect.$$$reportNull$$$0(4);
        }
        try {
            String catalog = connection2.getJdbcConnection().getCatalog();
            String schema = connection2.getJdbcConnection().getSchema();
            if (schema == null && catalog == null) {
                return null;
            }
            ObjectPath dbPath = ObjectPath.create((String)StringUtil.notNullize((String)catalog), (ObjectKind)ObjectKind.DATABASE);
            if (schema == null) {
                return SearchPath.of((ObjectPath)dbPath);
            }
            return SearchPath.of((ObjectPath)dbPath.append(schema, ObjectKind.SCHEMA));
        }
        catch (RuntimeException | SQLException ignored) {
            return null;
        }
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            GenericDialect.$$$reportNull$$$0(5);
        }
        return !identifier.startsWith("_") && super.isValidPlainIdentifier(identifier);
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @NotNull
    public String getDisplayName() {
        if ("<Generic>" == null) {
            GenericDialect.$$$reportNull$$$0(6);
        }
        return "<Generic>";
    }

    public boolean supportsAlterColumnNull() {
        return false;
    }

    public boolean supportsAlterColumnType() {
        return false;
    }

    public boolean supportsAlterColumnDefault() {
        return false;
    }

    @Override
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(7);
        }
        if (view == null) {
            GenericDialect.$$$reportNull$$$0(8);
        }
        if (definition == null) {
            GenericDialect.$$$reportNull$$$0(9);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.create.view", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(10);
        }
        if (view == null) {
            GenericDialect.$$$reportNull$$$0(11);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.view", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(12);
        }
        if (sequence == null) {
            GenericDialect.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsViewDefinition() {
        return false;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            GenericDialect.$$$reportNull$$$0(14);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.view.definition", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsProcedureDefinition() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element2) {
        if (element2 == null) {
            GenericDialect.$$$reportNull$$$0(15);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.procedure.definition", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = DatabaseIcons.Sql;
        if (icon == null) {
            GenericDialect.$$$reportNull$$$0(16);
        }
        return icon;
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            GenericDialect.$$$reportNull$$$0(17);
        }
        if (qualifier == null) {
            GenericDialect.$$$reportNull$$$0(18);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, null, null);
        if (ddlBuilder == null) {
            GenericDialect.$$$reportNull$$$0(19);
        }
        return ddlBuilder;
    }

    public boolean supportsCommonTableExpression() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(20);
        }
        if (statement == null) {
            GenericDialect.$$$reportNull$$$0(21);
        }
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    @NotNull
    protected AbstractDatabaseDialect.LimitPlace getPlaceForLimit(@Nullable DasDataSource system) {
        Dbms dbms;
        Dbms dbms2 = dbms = system != null ? system.getDbms() : null;
        AbstractDatabaseDialect.LimitPlace limitPlace = DEFAULT_LIMIT_DBS.contains(dbms) || dbms == Dbms.FILEMAKER ? AbstractDatabaseDialect.LimitPlace.END : (dbms == Dbms.TIBERO ? AbstractDatabaseDialect.LimitPlace.BOTH : AbstractDatabaseDialect.LimitPlace.BEGIN);
        if (limitPlace == null) {
            GenericDialect.$$$reportNull$$$0(22);
        }
        return limitPlace;
    }

    @Override
    @NotNull
    protected DdlBuilder appendLimit(@NotNull DdlBuilder builder, @Nullable DasDataSource system, int rows) {
        Dbms dbms;
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(23);
        }
        Dbms dbms2 = dbms = system == null ? Dbms.UNKNOWN : system.getDbms();
        DdlBuilder ddlBuilder = !GenericDialect.shouldUseLimit() ? builder : (DEFAULT_LIMIT_DBS.contains(dbms) ? super.appendLimit(builder, system, rows) : (TOP_LIMIT_DBS.contains(dbms) ? GenericDialect.top(builder, "TOP", rows) : (dbms == Dbms.INGRES ? GenericDialect.top(builder, "FIRST", rows) : (dbms == Dbms.TIBERO ? GenericDialect.rowNumLimit(builder, rows) : (dbms == Dbms.FILEMAKER ? GenericDialect.fetchFirst(builder, rows) : builder)))));
        if (ddlBuilder == null) {
            GenericDialect.$$$reportNull$$$0(24);
        }
        return ddlBuilder;
    }

    private static boolean shouldUseLimit() {
        return Registry.is((String)"database.generic_dialect.limit", (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/generic/GenericDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/generic/GenericDialect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceForLimit";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "appendLimit";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "appendLimit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

