/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.DataBus;
import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.console.AbstractEngine;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.TxIsolationAuditor;
import com.intellij.database.run.TxMarkerAuditor;
import com.intellij.database.run.audit.AuditorChain;
import com.intellij.database.run.session.SessionStateWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u00049:;<B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010!\u001a\u00020\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\b\u0010$\u001a\u00020\"H\u0016J\b\u0010%\u001a\u00020\"H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\nH\u0016J\b\u0010)\u001a\u00020\u0016H\u0016J\b\u0010*\u001a\u00020\u0006H\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020.H\u0016J\b\u00102\u001a\u00020.H\u0016J\u0010\u00103\u001a\u00020\"2\u0006\u00104\u001a\u00020.H\u0016J\u0010\u00105\u001a\u00020\"2\u0006\u00106\u001a\u00020'H\u0016J\u0010\u00107\u001a\u00020\"2\u0006\u00108\u001a\u00020,H\u0016R\u001e\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006="}, d2={"Lcom/intellij/database/console/session/AbstractMessageBusSession;", "Lcom/intellij/database/console/session/DatabaseSession;", "Lcom/intellij/openapi/Disposable$Parent;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "kernel", "Lcom/intellij/database/console/session/AbstractMessageBusSession$SessionKernel;", "title", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/console/session/AbstractMessageBusSession$SessionKernel;Ljava/lang/String;)V", "clients", "", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "getClients", "()[Lcom/intellij/database/console/client/DatabaseSessionClient;", "getDataSource", "()Lcom/intellij/database/dataSource/LocalDataSource;", "getKernel", "()Lcom/intellij/database/console/session/AbstractMessageBusSession$SessionKernel;", "messageBus", "Lcom/intellij/database/DataBus$Consuming;", "getProject", "()Lcom/intellij/openapi/project/Project;", "state", "Lcom/intellij/database/console/session/AbstractMessageBusSession$State;", "getState", "()Lcom/intellij/database/console/session/AbstractMessageBusSession$State;", "visibleClients", "Lcom/intellij/database/console/client/VisibleDatabaseSessionClient;", "getVisibleClients", "()[Lcom/intellij/database/console/client/VisibleDatabaseSessionClient;", "attach", "", "client", "beforeTreeDispose", "dispose", "getCurrentTx", "Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "getDisplayName", "getMessageBus", "getTarget", "getTxIsolation", "", "isChildOf", "", "owner", "Lcom/intellij/database/datagrid/DataRequest$Owner;", "isIdle", "isValid", "setAutoCommit", "autoCommit", "setCurrentTx", "marker", "setTxIsolation", "isolation", "NaturalKernel", "SessionKernel", "State", "WrapperKernel", "intellij.database.impl"})
public abstract class AbstractMessageBusSession
implements DatabaseSession,
Disposable.Parent {
    private final DataBus.Consuming messageBus;
    @NotNull
    private final State state;
    @NotNull
    private final Project project;
    @NotNull
    private final LocalDataSource dataSource;
    @NotNull
    private final SessionKernel kernel;
    private final String title;

    @Override
    @NotNull
    public DatabaseSessionClient<?>[] getClients() {
        Collection $receiver$iv;
        Collection collection = $receiver$iv = (Collection)this.state.getAttached();
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        DatabaseSessionClient[] databaseSessionClientArray = thisCollection$iv.toArray(new DatabaseSessionClient[0]);
        if (databaseSessionClientArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return databaseSessionClientArray;
    }

    @Override
    @NotNull
    public VisibleDatabaseSessionClient[] getVisibleClients() {
        Collection $receiver$iv;
        Collection collection = $receiver$iv = (Collection)CollectionsKt.filterIsInstance((Iterable)this.state.getAttached(), VisibleDatabaseSessionClient.class);
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        VisibleDatabaseSessionClient[] visibleDatabaseSessionClientArray = thisCollection$iv.toArray(new VisibleDatabaseSessionClient[0]);
        if (visibleDatabaseSessionClientArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return visibleDatabaseSessionClientArray;
    }

    @NotNull
    protected final State getState() {
        return this.state;
    }

    @Override
    @NotNull
    public DataRequest.TxMarker getCurrentTx() {
        return this.kernel.getTxMarker();
    }

    @Override
    public void setCurrentTx(@NotNull DataRequest.TxMarker marker) {
        Intrinsics.checkParameterIsNotNull((Object)marker, (String)"marker");
        this.kernel.setTxMarker(marker);
    }

    @Override
    public int getTxIsolation() {
        return this.kernel.getIsolation();
    }

    @Override
    public void setTxIsolation(int isolation) {
        this.kernel.setIsolation(isolation);
    }

    @Override
    public boolean isIdle() {
        return this.kernel.getIdle();
    }

    @Override
    @NotNull
    public LocalDataSource getTarget() {
        return this.dataSource;
    }

    @Override
    public boolean isValid() {
        return !this.state.getDisposed() && JdbcConsole.isDataSourceValid(DbPsiFacade.getInstance((Project)this.project), this.getTarget());
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.title;
    }

    @Override
    @NotNull
    public DataBus.Consuming getMessageBus() {
        return this.messageBus;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        DataRequest.TxMarker txMarker;
        if (autoCommit) {
            DataRequest.TxMarker txMarker2 = DataRequest.AUTO_COMMIT;
            txMarker = txMarker2;
            Intrinsics.checkExpressionValueIsNotNull((Object)txMarker2, (String)"DataRequest.AUTO_COMMIT");
        } else {
            DataRequest.TxMarker txMarker3 = DataRequest.START_NEW;
            txMarker = txMarker3;
            Intrinsics.checkExpressionValueIsNotNull((Object)txMarker3, (String)"DataRequest.START_NEW");
        }
        this.setCurrentTx(txMarker);
    }

    public void dispose() {
    }

    public void beforeTreeDispose() {
        this.state.setDisposed(true);
    }

    @Override
    public void attach(@NotNull DatabaseSessionClient<?> client) {
        Intrinsics.checkParameterIsNotNull(client, (String)"client");
        this.state.attach(client);
    }

    @Override
    public boolean isChildOf(@NotNull DataRequest.Owner owner) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        return Intrinsics.areEqual((Object)owner, (Object)this) || owner instanceof DatabaseSession && this.kernel.isParentSession((DatabaseSession)owner);
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final LocalDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    protected final SessionKernel getKernel() {
        return this.kernel;
    }

    public AbstractMessageBusSession(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull SessionKernel kernel, @NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)kernel, (String)"kernel");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        this.project = project;
        this.dataSource = dataSource;
        this.kernel = kernel;
        this.title = title;
        DataBus.Consuming consuming = this.kernel.getConsuming().filterFor(this);
        Intrinsics.checkExpressionValueIsNotNull((Object)consuming, (String)"kernel.consuming.filterFor(this)");
        this.messageBus = consuming;
        this.state = new State(this);
        this.kernel.init(this.project, this);
        Disposer.register((Disposable)((Disposable)this.project), (Disposable)this);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0007J\u0014\u0010\u0013\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002R\u001b\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/console/session/AbstractMessageBusSession$State;", "", "session", "Lcom/intellij/database/console/session/AbstractMessageBusSession;", "(Lcom/intellij/database/console/session/AbstractMessageBusSession;)V", "attached", "", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "getAttached", "()Ljava/util/List;", "disposed", "", "getDisposed", "()Z", "setDisposed", "(Z)V", "attach", "", "client", "disposeIfPossible", "intellij.database.impl"})
    protected static final class State {
        @NotNull
        private final List<DatabaseSessionClient<?>> attached;
        private volatile boolean disposed;
        private final AbstractMessageBusSession session;

        @NotNull
        public final List<DatabaseSessionClient<?>> getAttached() {
            return this.attached;
        }

        public final boolean getDisposed() {
            return this.disposed;
        }

        public final void setDisposed(boolean bl) {
            this.disposed = bl;
        }

        public final void attach(@NotNull DatabaseSessionClient<?> client) {
            Intrinsics.checkParameterIsNotNull(client, (String)"client");
            Collection collection = this.attached;
            collection.add(client);
            Disposer.register((Disposable)client, (Disposable)new Disposable(this, client){
                final /* synthetic */ State this$0;
                final /* synthetic */ DatabaseSessionClient $client;

                public final void dispose() {
                    State.access$disposeIfPossible(this.this$0, this.$client);
                }
                {
                    this.this$0 = state;
                    this.$client = databaseSessionClient;
                }
            });
        }

        private final void disposeIfPossible(DatabaseSessionClient<?> client) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, client){
                final /* synthetic */ State this$0;
                final /* synthetic */ DatabaseSessionClient $client;

                public final void run() {
                    Collection collection = this.this$0.getAttached();
                    DatabaseSessionClient databaseSessionClient = this.$client;
                    collection.remove(databaseSessionClient);
                    if (this.this$0.getAttached().isEmpty()) {
                        Disposer.dispose((Disposable)State.access$getSession$p(this.this$0));
                    }
                }
                {
                    this.this$0 = state;
                    this.$client = databaseSessionClient;
                }
            });
        }

        public State(@NotNull AbstractMessageBusSession session2) {
            Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
            this.session = session2;
            this.attached = new ArrayList();
        }

        public static final /* synthetic */ void access$disposeIfPossible(State $this, @NotNull DatabaseSessionClient client) {
            $this.disposeIfPossible(client);
        }

        @NotNull
        public static final /* synthetic */ AbstractMessageBusSession access$getSession$p(State $this) {
            return $this.session;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH&J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001dH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00020\u000bX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\u0011X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/console/session/AbstractMessageBusSession$SessionKernel;", "", "consuming", "Lcom/intellij/database/DataBus$Consuming;", "getConsuming", "()Lcom/intellij/database/DataBus$Consuming;", "idle", "", "getIdle", "()Z", "isolation", "", "getIsolation", "()I", "setIsolation", "(I)V", "txMarker", "Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "getTxMarker", "()Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "setTxMarker", "(Lcom/intellij/database/datagrid/DataRequest$TxMarker;)V", "init", "", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/database/console/session/AbstractMessageBusSession;", "isParentSession", "Lcom/intellij/database/console/session/DatabaseSession;", "intellij.database.impl"})
    public static interface SessionKernel {
        @NotNull
        public DataBus.Consuming getConsuming();

        @NotNull
        public DataRequest.TxMarker getTxMarker();

        public void setTxMarker(@NotNull DataRequest.TxMarker var1);

        public int getIsolation();

        public void setIsolation(int var1);

        public boolean getIdle();

        public void init(@NotNull Project var1, @NotNull AbstractMessageBusSession var2);

        public boolean isParentSession(@NotNull DatabaseSession var1);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010&\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010)\u001a\u00020*2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010+\u001a\u00020.H\u0016R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/database/console/session/AbstractMessageBusSession$NaturalKernel;", "Lcom/intellij/database/console/session/AbstractMessageBusSession$SessionKernel;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/database/dataSource/LocalDataSource;)V", "broker", "Lcom/intellij/database/SimpleRequestBroker;", "kotlin.jvm.PlatformType", "consuming", "Lcom/intellij/database/DataBus$Consuming;", "getConsuming", "()Lcom/intellij/database/DataBus$Consuming;", "engine", "Lcom/intellij/database/console/AbstractEngine;", "getEngine", "()Lcom/intellij/database/console/AbstractEngine;", "idle", "", "getIdle", "()Z", "isolation", "", "getIsolation", "()I", "setIsolation", "(I)V", "txMarker", "Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "getTxMarker", "()Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "setTxMarker", "(Lcom/intellij/database/datagrid/DataRequest$TxMarker;)V", "watcher", "Lcom/intellij/database/run/session/SessionStateWatcher;", "createEngine", "bus", "Lcom/intellij/database/DataBus$Producing;", "init", "", "session", "Lcom/intellij/database/console/session/AbstractMessageBusSession;", "isParentSession", "Lcom/intellij/database/console/session/DatabaseSession;", "intellij.database.impl"})
    public static class NaturalKernel
    implements SessionKernel {
        private final SimpleRequestBroker broker;
        private SessionStateWatcher watcher;
        private volatile int isolation;
        @NotNull
        private volatile DataRequest.TxMarker txMarker;
        @NotNull
        private final AbstractEngine engine;

        @Override
        public int getIsolation() {
            return this.isolation;
        }

        @Override
        public void setIsolation(int n) {
            this.isolation = n;
        }

        @Override
        @NotNull
        public DataRequest.TxMarker getTxMarker() {
            return this.txMarker;
        }

        @Override
        public void setTxMarker(@NotNull DataRequest.TxMarker txMarker) {
            Intrinsics.checkParameterIsNotNull((Object)txMarker, (String)"<set-?>");
            this.txMarker = txMarker;
        }

        @Override
        @NotNull
        public DataBus.Consuming getConsuming() {
            SimpleRequestBroker simpleRequestBroker = this.broker;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleRequestBroker, (String)"broker");
            return simpleRequestBroker;
        }

        @Override
        public boolean getIdle() {
            SessionStateWatcher sessionStateWatcher = this.watcher;
            if (sessionStateWatcher == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"watcher");
            }
            return sessionStateWatcher.isIdle();
        }

        @NotNull
        public final AbstractEngine getEngine() {
            return this.engine;
        }

        @Override
        public void init(@NotNull Project project, @NotNull AbstractMessageBusSession session2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
            session2.messageBus.addAuditor(new AuditorChain(new TxIsolationAuditor(session2), new TxMarkerAuditor(session2)));
            Disposer.register((Disposable)session2, (Disposable)this.engine);
            this.watcher = new SessionStateWatcher(session2);
        }

        @NotNull
        protected AbstractEngine createEngine(@NotNull Project project, @NotNull DataBus.Producing bus, @NotNull LocalDataSource dataSource) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)bus, (String)"bus");
            Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
            return new JdbcEngine(project, bus, dataSource, null);
        }

        @Override
        public boolean isParentSession(@NotNull DatabaseSession session2) {
            Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
            return false;
        }

        public NaturalKernel(@NotNull Project project, @NotNull String title, @NotNull LocalDataSource dataSource) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
            Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
            this.broker = SimpleRequestBroker.newInstance(project, title);
            this.isolation = dataSource.getTxIsolation();
            DataRequest.TxMarker txMarker = DataRequest.getInitialTxMarker(dataSource.isAutoCommit());
            Intrinsics.checkExpressionValueIsNotNull((Object)txMarker, (String)"DataRequest.getInitialTx\u2026(dataSource.isAutoCommit)");
            this.txMarker = txMarker;
            SimpleRequestBroker simpleRequestBroker = this.broker;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleRequestBroker, (String)"broker");
            this.engine = this.createEngine(project, simpleRequestBroker, dataSource);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u00148V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\""}, d2={"Lcom/intellij/database/console/session/AbstractMessageBusSession$WrapperKernel;", "Lcom/intellij/database/console/session/AbstractMessageBusSession$SessionKernel;", "parent", "Lcom/intellij/database/console/session/DatabaseSession;", "(Lcom/intellij/database/console/session/DatabaseSession;)V", "consuming", "Lcom/intellij/database/DataBus$Consuming;", "getConsuming", "()Lcom/intellij/database/DataBus$Consuming;", "idle", "", "getIdle", "()Z", "value", "", "isolation", "getIsolation", "()I", "setIsolation", "(I)V", "Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "txMarker", "getTxMarker", "()Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "setTxMarker", "(Lcom/intellij/database/datagrid/DataRequest$TxMarker;)V", "init", "", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/database/console/session/AbstractMessageBusSession;", "isParentSession", "FakeClient", "intellij.database.impl"})
    public static final class WrapperKernel
    implements SessionKernel {
        private final DatabaseSession parent;

        @Override
        @NotNull
        public DataBus.Consuming getConsuming() {
            DataBus.Consuming consuming = this.parent.getMessageBus();
            Intrinsics.checkExpressionValueIsNotNull((Object)consuming, (String)"parent.messageBus");
            return consuming;
        }

        @Override
        @NotNull
        public DataRequest.TxMarker getTxMarker() {
            DataRequest.TxMarker txMarker = this.parent.getCurrentTx();
            Intrinsics.checkExpressionValueIsNotNull((Object)txMarker, (String)"parent.currentTx");
            return txMarker;
        }

        @Override
        public void setTxMarker(@NotNull DataRequest.TxMarker value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.parent.setCurrentTx(value);
        }

        @Override
        public int getIsolation() {
            return this.parent.getTxIsolation();
        }

        @Override
        public void setIsolation(int value) {
            this.parent.setTxIsolation(value);
        }

        @Override
        public boolean getIdle() {
            return this.parent.isIdle();
        }

        @Override
        public void init(@NotNull Project project, @NotNull AbstractMessageBusSession session2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
            FakeClient fake = new FakeClient(session2);
            Disposer.register((Disposable)session2, (Disposable)fake);
            this.parent.attach(fake);
        }

        @Override
        public boolean isParentSession(@NotNull DatabaseSession session2) {
            Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
            return Intrinsics.areEqual((Object)session2, (Object)this.parent) || this.parent.isChildOf(session2);
        }

        public WrapperKernel(@NotNull DatabaseSession parent2) {
            Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
            this.parent = parent2;
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0006H\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/console/session/AbstractMessageBusSession$WrapperKernel$FakeClient;", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "Lcom/intellij/database/console/session/DatabaseSession;", "session", "(Lcom/intellij/database/console/session/DatabaseSession;)V", "disposed", "", "getSession", "()Lcom/intellij/database/console/session/DatabaseSession;", "title", "", "getTitle", "()Ljava/lang/String;", "dispose", "", "getCurrentTx", "Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "getDepartment", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "getDisplayName", "getMessageBus", "Lcom/intellij/database/DataBus$Consuming;", "isActive", "setAutoCommit", "autoCommit", "intellij.database.impl"})
        private static final class FakeClient
        implements DatabaseSessionClient<DatabaseSession> {
            private volatile boolean disposed;
            @NotNull
            private final DatabaseSession session;

            @Override
            public boolean isActive() {
                return !this.disposed;
            }

            @Override
            @NotNull
            public String getTitle() {
                String string = this.getSession().getDisplayName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"session.displayName");
                return string;
            }

            @Override
            @NotNull
            public DataBus.Consuming getMessageBus() {
                DataBus.Consuming consuming = this.getSession().getMessageBus();
                Intrinsics.checkExpressionValueIsNotNull((Object)consuming, (String)"session.messageBus");
                return consuming;
            }

            public void dispose() {
                this.disposed = true;
            }

            @Override
            @NotNull
            public String getDisplayName() {
                String string = this.getSession().getDisplayName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"session.displayName");
                return string;
            }

            @Override
            @NotNull
            public DataRequest.TxMarker getCurrentTx() {
                DataRequest.TxMarker txMarker = this.getSession().getCurrentTx();
                Intrinsics.checkExpressionValueIsNotNull((Object)txMarker, (String)"session.currentTx");
                return txMarker;
            }

            @Override
            public void setAutoCommit(boolean autoCommit) {
                this.getSession().setAutoCommit(autoCommit);
            }

            @Override
            @NotNull
            public DatabaseDepartment getDepartment() {
                return DGDepartment.UNKNOWN;
            }

            @Override
            @NotNull
            public DatabaseSession getSession() {
                return this.session;
            }

            public FakeClient(@NotNull DatabaseSession session2) {
                Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
                this.session = session2;
            }
        }
    }
}

