package org.clank.java.stdimpl.aliases;

import java.util.Arrays;
import java.util.Iterator;
import org.clank.java.*;
import org.clank.support.Converted;
import org.clank.support.Destructors.ClassWithDestructor;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.*;
import org.clank.support.aliases.*;
import static org.clank.support.NativePointer.*;
import static org.clank.support.NativeType.*;
import static org.clank.support.Native.*;
import static org.clank.java.std.string.npos;

/**
 * StdVector for ${TYPE}
 */
//<editor-fold defaultstate="collapsed" desc="template">
@Converted(kind = Converted.Kind.DUMMY, source = "${SPUTNIK}/modules/org.clank.java/src/org/clank/support/aliases/templates/StdVector.tpl")
//</editor-fold>
public abstract class ${FILE_NAME}${CLASS_SUFFIX} implements assignable<${MAIN_CLASS}>, 
          NativeCloneable<${MAIN_CLASS}>, Native.NativeComparable<${MAIN_CLASS}>, 
          Native.ComparableLower, NativeType.SizeofCapable, Iterable<${BOXED_TYPE}>,
          Destructors.ClassWithDestructor {

  protected final ${TYPE} defaultValue;
  
  protected ${TYPE}[] array;
  private static final ${ARRAY_TYPE}[] EMPTY = ${NEW_ZERO_ARRAY};
  
  protected int end;

  protected ${FILE_NAME}(${TYPE} defaultValue) {
    this.array = (${TYPE}[])(EMPTY);
    this.end = 0;
    this.defaultValue = defaultValue;
  }
  
  protected ${FILE_NAME}(int initialSize, ${TYPE} defaultValue) {
    this(defaultValue);
    this.assign(initialSize, defaultValue);
  }

  protected ${FILE_NAME}(${TYPE} array[], int length, ${TYPE} defaultValue) {
    this.array = array;
    this.end = (int) length;
    this.defaultValue = defaultValue;
  }

  protected ${FILE_NAME}(${GENERIC_ITERATOR} iter, int length, ${TYPE} defaultValue) {
    this(iter, iter.$add(length), defaultValue);
  }

  protected ${FILE_NAME}(${GENERIC_ITERATOR} begin, ${GENERIC_ITERATOR} end, ${TYPE} defaultValue) {
    this(defaultValue);
    append(begin, end);
  }

  protected ${FILE_NAME}(${MAIN_CLASS} other) {
    this(other.defaultValue);
    append(other.begin(), other.end());
  }

  protected ${FILE_NAME}(JavaDifferentiators.JD$Move _dparam, ${MAIN_CLASS} other) {
    this((${TYPE}) ${DEFAULT_VALUE});
    $assignMove(other);
  }

  @Override
  public ${MAIN_CLASS} $assign(${MAIN_CLASS} other) {
    this.array = other.array;
    this.end = other.end;
    return (${MAIN_CLASS}) this;
  }    

  public ${MAIN_CLASS} $assignMove(${MAIN_CLASS} other) {
    ${TYPE}[] tmpArray = this.array;
    int tmpEnd = this.end;
    this.array = other.array;
    this.end = other.end;
    other.array = tmpArray;
    other.end = tmpEnd;
    return (${MAIN_CLASS}) this;
  }   

  public void clear() {
    this.destroy_range(0, this.size());
    this.setEnd(0);
  }

  public void resize(int newSize) {
    resize(newSize, defaultValue);
  }
  
  public void resize(int newSize, ${TYPE} defaultValue) {
    if (newSize < end) {
      destroy_range(newSize, end);
    } else if (newSize > end) {
      if (this.capacity() < newSize)
        this.grow(newSize);
      for (int i = end; i < newSize; i++) {
        array[i] = $tryClone(defaultValue);
      }
    }
    this.setEnd(newSize);
  }  

  public void reserve(int N) {
    if (this.capacity() < N)
      this.grow(N);
  }

  public void assign(int NumElts, ${TYPE} Elt) {
    clear();
    if (this.capacity() < NumElts)
      this.grow(NumElts);    
    this.setEnd(NumElts);
    
    for (int i = 0; i < this.size(); i++) {
      $set(i, Elt);
    }
  }  

  /**
   *  @brief  Assigns a range to a %vector.
   *  @param  __first  An input iterator.
   *  @param  __last   An input iterator.
   *
   *  This function fills a %vector with copies of the elements in the
   *  range [__first,__last).
   *
   *  Note that the assignment completely changes the %vector and
   *  that the resulting %vector's size is the same as the number
   *  of elements assigned.  Old data may be lost.
   */
  public void assign(${GENERIC_ITERATOR} __first, ${GENERIC_ITERATOR} __last) {
    clear();
    append(__first, __last);
  }  
  
  //<editor-fold defaultstate="collapsed" desc="Manual">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/SmallVector.h", line = 440)
  //</editor-fold>  
  public void swap(${FILE_NAME}${CLASS_SUFFIX} RHS) {
    ${TYPE}[] arrTmp = this.array;
    this.array = (${TYPE}[])RHS.array;
    RHS.array = arrTmp;
    int endTmp = this.end;
    this.end = RHS.end;
    RHS.end = endTmp;
  }
  
  public final /*size_t*/int find(${ARRAY_TYPE} elem) {
    return find(elem, 0);
  }

  public final /*size_t*/int find(${ARRAY_TYPE} elem, /*size_t*/int from/*=0*/) {
    boolean isDataPointerLike = isDataPointerLike();
    for (int i = from; i < this.end; i++) {
      if (Native.$eq(array[i], elem, isDataPointerLike)) {
        return i;
      }
    }
    return npos;
  }
  
  public final boolean contains(${ARRAY_TYPE} elem) {
    return find(elem) != npos;
  }

  public final boolean erase(${ARRAY_TYPE} elem) {
    /*uint*/int index = find(elem);
    if (index == npos) {
      return false;
    }
    // destroy element
    destroy_range(index, index+1);
    // shift leftward if not the last
    --end;
    if (index < end) {
      std.copy(this.array, index+1, end-index, this.array, index);
    }
    // clean up after shift
    $set(end, defaultValue);
    return true;
  }
  
  //<editor-fold defaultstate="collapsed" desc="Manual">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/SmallVector.h", line=478)
  //</editor-fold>
  public iterator erase(iterator I) {
    assert(I.$greatereq(this.begin())) : "Iterator to erase is out of bounds.";
    assert(I.$less(this.end())) : "Erasing at past-the-end iterator.";

    iterator N = I;
    // Shift all elts down one.
    std.copy(I.$add(1), this.end(), I);
    // Drop the last elt.
    this.pop_back();
    return(N);
  } 
  
  //<editor-fold defaultstate="collapsed" desc="Manual">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/SmallVector.h", line=490)
  //</editor-fold>
  public iterator erase(iterator S, iterator E) {
    assert(S.$greatereq(this.begin())) : "Range to erase is out of bounds.";
    assert(S.$lesseq(E)) : "Trying to erase invalid range.";
    assert(E.$lesseq(this.end())) : "Trying to erase past the end.";

    iterator N = S;
    // Shift all elts down.
    iterator I = std.copy(E, this.end(), S);
    // Drop the last elts.
    this.destroy_range(I, this.end());
    this.setEnd(I);
    return(N);
  }

  //<editor-fold defaultstate="collapsed" desc="Manual">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/SmallVector.h", line=537)
  //</editor-fold>
  public iterator insert(iterator I, ${TYPE} Elt) {
    if (I.$eq(this.end())) {  // Important special case for empty vector.
      this.push_back(Elt);
      return this.end().$sub(1);
    }

    assert(I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
    assert(I.$lesseq(this.end())) : "Inserting past the end of the vector.";
    
    if (this.size() >= this.capacity()) {
      int EltNo = I.$sub(this.begin());
      this.grow();
      I = this.begin().$add(EltNo);
    }
    
    assert(this.size() < this.capacity());
    
    this.setEnd(this.size() + 1);
    // Push everything else over.
    std.copy_backward(I, this.end().$sub(1), this.end());   
    
//  // If we just moved the element we're inserting, be sure to update
//  // the reference.
//  const T *EltPtr = &Elt;
//  if (I <= EltPtr && EltPtr < this->EndX)
//    ++EltPtr;    
    
    I.star$ref().$set(Elt);
    return I;    
  }  

  //<editor-fold defaultstate="collapsed" desc="Manual">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/SmallVector.h", line=568)
  //</editor-fold>  
  public iterator insert(iterator I, int NumToInsert, ${TYPE} Elt) {
    assert NumToInsert >= 0;
    // Convert iterator to elt# to avoid invalidating iterator when we reserve()
    int InsertElt = I.$sub(this.begin());

    if (I.$eq(this.end())) {  // Important special case for empty vector.
      append(NumToInsert, Elt);
      return this.begin().$add(InsertElt);
    }

    assert(I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
    assert(I.$lesseq(this.end())) : "Inserting past the end of the vector.";

    // Ensure there is enough space.
    reserve(this.size() + NumToInsert);

    // Uninvalidate the iterator.
    I = this.begin().$add(InsertElt);

    // If there are more elements between the insertion point and the end of the
    // range than there are being inserted, we can use a simple approach to
    // insertion.  Since we already reserved space, we know that this won't
    // reallocate the vector.
    if (this.end().$sub(I) >= NumToInsert) {
      iterator OldEnd = this.end();
      append(this.end().$sub(NumToInsert), this.end());

      // Copy the existing elements that get replaced.
      std.copy_backward(I, OldEnd.$sub(NumToInsert), OldEnd);

      std.fill_n(I, NumToInsert, Elt);
      return I;
    }

    // Otherwise, we're inserting more elements than exist already, and we're
    // not inserting at the end.

    // Move over the elements that we're about to overwrite.
    iterator OldEnd = this.end();
    this.setEnd(this.size() + NumToInsert);
    int NumOverwritten = OldEnd.$sub(I);
    std.copy(I, OldEnd, this.end().$sub(NumOverwritten));

    // Replace the overwritten part.
    std.fill_n(I, NumOverwritten, Elt);

    // Insert the non-overwritten middle part.
    std.fill_n(OldEnd, NumToInsert-NumOverwritten, Elt);
    return I;  
  }

  //<editor-fold defaultstate="collapsed" desc="Manual">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/SmallVector.h", line=618)
  //</editor-fold>
  public iterator insert(iterator I, ${GENERIC_ITERATOR} From, ${GENERIC_ITERATOR} To) {
    // Convert iterator to elt# to avoid invalidating iterator when we reserve()
    int InsertElt = I.$sub(this.begin());

    if (I.$eq(this.end())) {  // Important special case for empty vector.
      append(From, To);
      return this.begin().$add(InsertElt);
    }

    assert(I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
    assert(I.$lesseq(this.end())) : "Inserting past the end of the vector.";

    int NumToInsert = std.distance(From, To);

    // Ensure there is enough space.
    reserve(this.size() + NumToInsert);

    // Uninvalidate the iterator.
    I = this.begin().$add(InsertElt);

    // If there are more elements between the insertion point and the end of the
    // range than there are being inserted, we can use a simple approach to
    // insertion.  Since we already reserved space, we know that this won't
    // reallocate the vector.
    if (this.end().$sub(I) >= NumToInsert) {
      iterator OldEnd = this.end();
      append(this.end().$sub(NumToInsert), this.end());

      // Copy the existing elements that get replaced.
      std.copy_backward(I, OldEnd.$sub(NumToInsert), OldEnd);

      std.copy(From, To, I);
      return I;
    }

    // Otherwise, we're inserting more elements than exist already, and we're
    // not inserting at the end.

    // Move over the elements that we're about to overwrite.
    iterator OldEnd = this.end();
    this.setEnd(this.size() + NumToInsert);
    int NumOverwritten = OldEnd.$sub(I);
    std.copy(I, OldEnd, this.end().$sub(NumOverwritten));

    // Replace the overwritten part.
    From = $tryClone(From);
    for (iterator J = I.clone(); NumOverwritten > 0; --NumOverwritten) {
      J.star$ref().$set(From.$star());
      J.$preInc(); From.$preInc();
    }

    // Insert the non-overwritten middle part.
    std.copy(From, To, OldEnd);
    return I;
  }

  /// append - Add the specified range to the end of the SmallVector.
  ///  
  public void append(${GENERIC_ITERATOR} in_start, ${GENERIC_ITERATOR} in_end) {
    int NumInputs = std.distance(in_start, in_end);
    // Grow allocated space if needed.
    if (NumInputs > (this.capacity() - this.size()))
      this.grow(this.size()+NumInputs);
    
    ${GENERIC_ITERATOR} iter = (${GENERIC_ITERATOR}) in_start.clone();
    while (!iter.$eq(in_end)) {
      $set(end, iter.$star());
      ++end;
      iter.$preInc();
    }
  }
  
  public void append(int NumInputs, ${TYPE} Elt) {
    assert NumInputs >= 0;
    // Grow allocated space if needed.
    if (NumInputs > (this.capacity() - this.size()))
      this.grow(this.size()+NumInputs);

    // Copy the new elements over.
    for (int i = 0; i < NumInputs; i++) {
      $set(end, Elt);
      ++end;
    }
  }  

  @Override
  public boolean $eq(${MAIN_CLASS} RHS) {
    if (this.size() != RHS.size()) return false;
    return std.equal(this.begin(), this.end(), RHS.begin());
  }

  @Override
  public boolean $noteq(${MAIN_CLASS} RHS) {
    return !$eq(RHS);
  }

  @Override
  public boolean $less(Object obj) {
    return std.lexicographical_compare(
        this.begin(), 
        this.end(), 
        ((${FILE_NAME}) obj).begin(), 
        ((${FILE_NAME}) obj).end()
    );
  }

  @Override
  public boolean $lesseq(Object obj) {
    return $less(obj) || $eq((${MAIN_CLASS})obj);
  }

  public ${REFERENCE_TYPE} ref$at(int idx) {
    return NativePointer.${REFERENCE_FACTORY_MTD}(array, idx);
  }
  
  public ${TYPE} $at(int idx) {
    return array[idx];
  }

  public ${TYPE} $set(int idx, ${TYPE} value) {
    ${SET_IMPL}
  }
  
  public boolean empty() {
    return this.size() == 0;
  }
  
  public void $destroy() {
    destroy_range(0, this.size());
    this.setEnd(0);
  }
  
  public void push_back(${TYPE} val) {
    if (this.size() >= this.capacity()) {
      this.grow(2 * this.capacity() + 1);
    }
    $set(this.size(), val);
    this.setEnd(this.size() + 1);
  }    

  // Version without args
  public void emplace_back() {
    this.push_back(defaultValue);
  }

  public void emplace_back(${TYPE} value) {
    this.push_back(value);
  }

  public void pop_back() {
    destroy_range(this.size() - 1, this.size());
    this.setEnd(this.size() - 1);
  }

  public ${TYPE} pop_back_val() {
    ${TYPE} val = this.back();
    this.setEnd(end - 1);
    return val;
  }  

  public final ${ITERATOR_TYPE} begin() {
    return new ${ITERATOR_TYPE}(this, 0, false);
  }

  public final ${ITERATOR_TYPE} end() {
    return new ${ITERATOR_TYPE}(this, end, false);
  }
  
  public ${REV_ITERATOR_TYPE} rbegin() {
    return new ${REV_ITERATOR_TYPE}(NativePointer.${POINTER_FACTORY_MTD}(array, end));
  }

  public ${REV_ITERATOR_TYPE} rend() {
    return new ${REV_ITERATOR_TYPE}(NativePointer.${POINTER_FACTORY_MTD}(array));
  }
  
  public ${POINTER_TYPE} data() {
    return NativePointer.${POINTER_FACTORY_MTD}(array);
  }
  
  public ${TYPE} front() {
    return array[0];
  }    
  
  public ${TYPE} back() {
    return array[end - 1];
  }    
  
  public ${REFERENCE_TYPE} ref$front() {
    return new ${REFERENCE_TYPE}() {
      
      private final ${TYPE} stored = array[0];
      
      private final int index = 0;

      @Override
      public ${TYPE} $deref() {
        return stored;
      }

      @Override
      public ${TYPE} $set(${TYPE} value) {
        ${REF_SET_IMPL}
      }
      
      @Override
      public ${POINTER_TYPE} deref$ptr() {
        return data().$add(index);
      }
    };
  }

  public ${REFERENCE_TYPE} ref$back() {
    return  new ${REFERENCE_TYPE}() {
      
      private final ${TYPE} stored = array[end - 1];
      
      private final int index = end - 1;

      @Override
      public ${TYPE} $deref() {
        return stored;
      }

      @Override
      public ${TYPE} $set(${TYPE} value) {
        ${REF_SET_IMPL}
      }
      
      @Override
      public ${POINTER_TYPE} deref$ptr() {
        return data().$add(index);
      }   
    };
  }
  
  public /*size_t*/int size() /*const*/ {
    return end;
  }

  public /*size_t*/int max_size() /*const*/ {
    return Integer.MAX_VALUE; // TODO 
  }

  /// capacity - Return the total number of elements in the currently allocated
  /// buffer.
  public /*size_t*/int capacity() /*const*/ {
    return array.length;
  }

  @Override public /*size_t*/int $sizeof() {
    int oneElemSize = NativeType.sizeof(defaultValue);; 
    for (${TYPE} elem : array) {
      if (elem != defaultValue) {
        oneElemSize = NativeType.sizeof(elem);
        break;
      }
    }
    return capacity() * oneElemSize;
  }

  public ${POINTER_TYPE} ptr$at(int idx) {
    return ${POINTER_FACTORY_MTD}(array, idx);
  }

  @Override
  public ${MAIN_CLASS} clone() {
    return new ${MAIN_CLASS}((${MAIN_CLASS}) this);
  }

  /// Set the array size to \p N, which the current array must have enough
  /// capacity for.
  ///
  /// This does not construct or destroy any elements in the vector.
  ///
  /// Clients can use this in conjunction with capacity() to write past the end
  /// of the buffer when they know that more elements are available, and only
  /// update the size later. This avoids the cost of value initializing elements
  /// which will only be overwritten.
  public void set_size(int N) {
    assert N >= 0;
    assert(N <= this.capacity());
    this.setEnd(N);
  }  
  
  private void destroy_range(int from, int to) {
    ${DESTROY_RANGE_IMPL}
  }

  private void destroy_range(iterator _from, iterator _to) {
    destroy_range(_from.$sub(this.begin()), _to.$sub(this.begin()));
  } 
  
  private void grow(int newSize) {
    array = ${COPY_OF_ARRAY}(array, newSize);
  }

  private void grow() {
    this.grow(capacity() > 0 ? capacity() * 2 : 1);
  }  
  
  private void setEnd(int to) {
    end = to;
  }  

  private void setEnd(iterator to) {
    setEnd(to.$sub(this.begin()));
  } 

  @Override
  public Iterator<${BOXED_TYPE}> iterator() {
    return new ${JAVA_ITERATOR}(begin(), end());
  }

  // Only Java! 
  // Means that in native code vector contained pointers but in Java they were converted as Java references
  public boolean isDataPointerLike() {
    ${IS_DATA_POINTER_LIKE_IMPL}
  }
  
  /*
   * *************************************************************************
   *  Iterators
   * *************************************************************************
   */
    
  public final static class ${ITERATOR_TYPE} implements ${ITERATOR_INTERFACE}, Native.assignable<${ITERATOR_TYPE}>, Native.ComparableLowerGreater {
    
    private final boolean _const;
    private final ${FILE_NAME}${CLASS_SUFFIX} delegate;
    private int index;

    public iterator(${FILE_NAME}${CLASS_SUFFIX} delegate, int index, boolean makeConst) {
      this.delegate = delegate;
      this.index = index;
      this._const = makeConst;
    }
    
    public iterator(${ITERATOR_TYPE} other) {
      this.delegate = other.delegate;
      this.index = other.index;
      this._const = other._const;
    }
    
    public iterator(JavaDifferentiators.JD$Move _dparam, ${ITERATOR_TYPE} other) {
      this.delegate = other.delegate;
      this.index = other.index;
      this._const = other._const;
    }
    
    @Override
    public ${ITERATOR_TYPE} $assign(${ITERATOR_TYPE} other) {
      assert this.delegate == other.delegate;
      this.index = other.index;
      return this;
    }

    public ${TYPE} $arrow() {
      return $at(0);
    }

    @Override
    public ${TYPE} $star() {
      return $at(0);
    }
    
    @Override
    public ${REFERENCE_TYPE} star$ref() {
      return ref$at(0);
    }       

    @Override
    public int $sub(${ITERATOR_TYPE} iter) {
      assert this.delegate == iter.delegate;
      return this.index - iter.index;
    }

    @Override
    public ${ITERATOR_TYPE} $preInc() {
      assert !_const;
      ++this.index;
      return this;
    }

    @Override
    public ${ITERATOR_TYPE} $preDec() {
      assert !_const;
      --this.index;
      return this;
    }

    @Override
    public ${ITERATOR_TYPE} $postInc() {
      assert !_const;
      ${ITERATOR_TYPE} cloned = new ${ITERATOR_TYPE}(delegate, index, false);
      index++;
      return cloned;
    }

    @Override
    public ${ITERATOR_TYPE} $postDec() {
      assert !_const;
      ${ITERATOR_TYPE} cloned = new ${ITERATOR_TYPE}(delegate, index, false);
      index--;
      return cloned;
    }

    @Override
    public ${ITERATOR_TYPE} $inc(int amount) {
      assert !_const;
      index+=amount;
      return this;
    }

    @Override
    public ${ITERATOR_TYPE} $dec(int amount) {
      assert !_const;
      index-=amount;
      return this;
    }

    @Override
    public ${ITERATOR_TYPE} $add(int amount) {
      return new ${ITERATOR_TYPE}(this.delegate, (this.index + amount), false);
    }

    @Override
    public ${ITERATOR_TYPE} $sub(int amount) {
      return new ${ITERATOR_TYPE}(this.delegate, (this.index - amount), false);
    }

    @Override
    public boolean $noteq(Object other) {
      assert this.delegate == ((iterator) other).delegate;
      return this.index != ((iterator) other).index;
    }

    @Override
    public boolean $eq(Object other) {
      assert this.delegate == ((iterator) other).delegate;
      return this.index == ((iterator) other).index;
    }

    @Override
    public ${ITERATOR_TYPE} clone() {
      return new ${ITERATOR_TYPE}(delegate, index, false);
    }

    @Override
    public ${ITERATOR_TYPE} const_clone() {
      return new ${ITERATOR_TYPE}(delegate, index, true);
    }

    @Override
    public boolean $less(Object obj) {
      assert this.delegate == ((iterator) obj).delegate;
      return this.index < ((iterator) obj).index;
    }

    @Override
    public boolean $lesseq(Object obj) {
      assert this.delegate == ((iterator) obj).delegate;
      return this.index <= ((iterator) obj).index;
    }

    @Override
    public boolean $greater(Object obj) {
      assert this.delegate == ((iterator) obj).delegate;
      return this.index > ((iterator) obj).index;
    }

    @Override
    public boolean $greatereq(Object obj) {
      assert this.delegate == ((iterator) obj).delegate;
      return this.index >= ((iterator) obj).index;
    }

    public ${TYPE} $at(int index) {
      return delegate.$at(this.index + index);
    }
    
    public ${REFERENCE_TYPE} ref$at(final int index) {
      return delegate.ref$at(this.index + index);
    }

    public ${POINTER_TYPE} toPointer() {
      return ${POINTER_FACTORY_MTD}(delegate.array, this.index);
    }

    public int $index() {
      return this.index;
    }
        
    @Override
    public String toString() {
      return "[" + this.index + "] from\n" + delegate.toString();
    }
  } 

  @Override
  public String toString() {
    if (this.end == 0) {
      return "<EMPTY>";
    }
    StringBuilder out = new StringBuilder("\n").append(getClass().getSimpleName()).append("{\nend = " + this.end + '\n');
    String fmt = "%" + (int)Math.ceil(Math.log10(this.end+1)) + "d";
    for (int i = 0; i < this.end; i++) {
      ${TYPE} element = array[i];
      out.append("[").append(String.format(fmt, i)).append("]");
      ${SB_APPEND_ELEMENT_I};
    }
    out.append("}").append(getClass().getSimpleName()).append("}\n");
    return out.toString();
  }
}
