/*
 * Decompiled with CFR 0.152.
 */
package org.clang.staticanalyzer.core;

import org.clang.staticanalyzer.core.AnalysisConstraints;
import org.clang.staticanalyzer.core.AnalysisDiagClients;
import org.clang.staticanalyzer.core.AnalysisInliningMode;
import org.clang.staticanalyzer.core.AnalysisPurgeMode;
import org.clang.staticanalyzer.core.AnalysisStores;
import org.clang.staticanalyzer.core.AnalyzerOptions$mayInlineCXXMemberFunction$$;
import org.clang.staticanalyzer.core.CXXInlineableMemberKind;
import org.clang.staticanalyzer.core.IPAKind;
import org.clang.staticanalyzer.core.ento.CheckerBase;
import org.clang.staticanalyzer.core.impl.AnalyzerOptionsStatics;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.RefCountedBase;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.StringSwitchBool;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapConstIterator;
import org.llvm.adt.aliases.StringMapIterator;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_svector_ostream;

public class AnalyzerOptions
extends RefCountedBase<AnalyzerOptions>
implements Destructors.ClassWithDestructor {
    public std.vector<std_pair.pairTypeBool<std.string>> CheckersControlList = new std.vector((Object)new std_pair.pairTypeBool((Object)std.string.EMPTY, false));
    public StringMap<std.string> Config = new StringMap((Object)std.string.EMPTY);
    public AnalysisStores AnalysisStoreOpt = AnalysisStores.RegionStoreModel;
    public AnalysisConstraints AnalysisConstraintsOpt = AnalysisConstraints.RangeConstraintsModel;
    public AnalysisDiagClients AnalysisDiagOpt = AnalysisDiagClients.PD_HTML;
    public AnalysisPurgeMode AnalysisPurgeOpt = AnalysisPurgeMode.PurgeStmt;
    public std.string AnalyzeSpecificFunction = new std.string();
    public int maxBlockVisitOnPath;
    public boolean DisableAllChecks = false;
    public boolean ShowCheckerHelp = false;
    public boolean AnalyzeAll = false;
    public boolean AnalyzerDisplayProgress = false;
    public boolean AnalyzeNestedBlocks = false;
    public boolean eagerlyAssumeBinOpBifurcation = false;
    public boolean TrimGraph = false;
    public boolean visualizeExplodedGraphWithGraphViz = false;
    public boolean visualizeExplodedGraphWithUbiGraph = false;
    public boolean UnoptimizedCFG = false;
    public boolean PrintStats = false;
    public boolean NoRetryExhausted = false;
    public int InlineMaxStackDepth = 5;
    public AnalysisInliningMode InliningMode = AnalysisInliningMode.NoRedundancy;
    private UserModeKind UserMode = UserModeKind.UMK_NotSet;
    private IPAKind IPAMode = IPAKind.IPAK_NotSet;
    private CXXInlineableMemberKind CXXMemberInliningMode = CXXInlineableMemberKind.valueOf(0);
    private ADTAliases.OptionalBool IncludeTemporaryDtorsInCFG = new ADTAliases.OptionalBool();
    private ADTAliases.OptionalBool InlineCXXStandardLibrary = new ADTAliases.OptionalBool();
    private ADTAliases.OptionalBool InlineTemplateFunctions = new ADTAliases.OptionalBool();
    private ADTAliases.OptionalBool InlineCXXAllocator = new ADTAliases.OptionalBool();
    private ADTAliases.OptionalBool InlineCXXContainerMethods = new ADTAliases.OptionalBool();
    private ADTAliases.OptionalBool InlineCXXSharedPtrDtor = new ADTAliases.OptionalBool();
    private ADTAliases.OptionalBool ObjCInliningMode = new ADTAliases.OptionalBool();
    private ADTAliases.OptionalUInt AlwaysInlineSize = new ADTAliases.OptionalUInt();
    private ADTAliases.OptionalBool SuppressNullReturnPaths = new ADTAliases.OptionalBool();
    private ADTAliases.OptionalUInt MaxInlinableSize = new ADTAliases.OptionalUInt();
    private ADTAliases.OptionalBool AvoidSuppressingNullArgumentPaths = new ADTAliases.OptionalBool();
    private ADTAliases.OptionalBool SuppressInlinedDefensiveChecks = new ADTAliases.OptionalBool();
    private ADTAliases.OptionalBool SuppressFromCXXStandardLibrary = new ADTAliases.OptionalBool();
    private ADTAliases.OptionalBool ReportIssuesInMainSourceFile = new ADTAliases.OptionalBool();
    private ADTAliases.OptionalBool StableReportFilename = new ADTAliases.OptionalBool();
    private ADTAliases.OptionalUInt GraphTrimInterval = new ADTAliases.OptionalUInt();
    private ADTAliases.OptionalUInt MaxTimesInlineLarge = new ADTAliases.OptionalUInt();
    private ADTAliases.OptionalUInt MinCFGSizeTreatFunctionsAsLarge = new ADTAliases.OptionalUInt();
    private ADTAliases.OptionalUInt MaxNodesPerTopLevelFunction = new ADTAliases.OptionalUInt();
    private ADTAliases.OptionalBool InlineLambdas = new ADTAliases.OptionalBool();
    private ADTAliases.OptionalBool WidenLoops = new ADTAliases.OptionalBool();

    private StringRef getCheckerOption(StringRef CheckerName, StringRef OptionName, StringRef Default) {
        return this.getCheckerOption(CheckerName, OptionName, Default, false);
    }

    private StringRef getCheckerOption(StringRef CheckerName, StringRef OptionName, StringRef Default, boolean SearchInParents) {
        StringMapIterator E = this.Config.end();
        do {
            StringMapIterator I;
            if ((I = this.Config.find(new StringRef(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine(CheckerName), (Twine)new Twine(NativePointer.$COLON)), (Twine)new Twine(OptionName)).str()))).$noteq((StringMapConstIterator)E)) {
                return new StringRef((std.string)I.$arrow().getValue());
            }
            int Pos = CheckerName.rfind((byte)46);
            if (Pos == StringRef.npos) {
                return new StringRef(JavaDifferentiators.JD$Move.INSTANCE, Default);
            }
            CheckerName.$assignMove(CheckerName.substr(0, Pos));
        } while (!CheckerName.empty() && SearchInParents);
        return new StringRef(JavaDifferentiators.JD$Move.INSTANCE, Default);
    }

    public boolean getBooleanOption(StringRef Name, boolean DefaultVal) {
        return this.getBooleanOption(Name, DefaultVal, null, false);
    }

    public boolean getBooleanOption(StringRef Name, boolean DefaultVal, CheckerBase C) {
        return this.getBooleanOption(Name, DefaultVal, C, false);
    }

    public boolean getBooleanOption(StringRef Name, boolean DefaultVal, CheckerBase C, boolean SearchInParents) {
        StringRef Default = AnalyzerOptionsStatics.__toString(DefaultVal);
        StringRef V = C != null ? this.getCheckerOption(C.getTagDescription(), new StringRef(Name), new StringRef(Default), SearchInParents) : new StringRef((std.string)((StringMapIterator)this.Config.insert((std_pair.pair)std.make_pair((Object)Name, (Object)Default.str())).first).$arrow().second);
        return new StringSwitchBool(V).Case("true", true).Case("false", false).Default(DefaultVal);
    }

    public boolean getBooleanOption(ADTAliases.OptionalBool V, StringRef Name, boolean DefaultVal) {
        return this.getBooleanOption(V, Name, DefaultVal, null, false);
    }

    public boolean getBooleanOption(ADTAliases.OptionalBool V, StringRef Name, boolean DefaultVal, CheckerBase C) {
        return this.getBooleanOption(V, Name, DefaultVal, C, false);
    }

    public boolean getBooleanOption(ADTAliases.OptionalBool V, StringRef Name, boolean DefaultVal, CheckerBase C, boolean SearchInParents) {
        if (!V.hasValue()) {
            V.$assign(this.getBooleanOption(new StringRef(Name), DefaultVal, C, SearchInParents));
        }
        return V.getValue();
    }

    public int getOptionAsInteger(StringRef Name, int DefaultVal) {
        return this.getOptionAsInteger(Name, DefaultVal, null, false);
    }

    public int getOptionAsInteger(StringRef Name, int DefaultVal, CheckerBase C) {
        return this.getOptionAsInteger(Name, DefaultVal, C, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOptionAsInteger(StringRef Name, int DefaultVal, CheckerBase C, boolean SearchInParents) {
        raw_svector_ostream OS = null;
        try {
            SmallString StrBuf = new SmallString(10);
            OS = new raw_svector_ostream(StrBuf);
            OS.$out_int(DefaultVal);
            StringRef V = C != null ? this.getCheckerOption(C.getTagDescription(), new StringRef(Name), OS.str(), SearchInParents) : new StringRef((std.string)((StringMapIterator)this.Config.insert((std_pair.pair)std.make_pair((Object)Name, (Object)OS.str().str())).first).$arrow().second);
            int.ref Res = NativePointer.create_int$ref((int)DefaultVal);
            boolean b = V.getAsInteger$Signed(10, Res);
            assert (!b) : "analyzer-config option should be numeric";
            int n = Res.$deref();
            return n;
        }
        finally {
            if (OS != null) {
                OS.$destroy();
            }
        }
    }

    public StringRef getOptionAsString(StringRef Name, StringRef DefaultVal) {
        return this.getOptionAsString(Name, DefaultVal, null, false);
    }

    public StringRef getOptionAsString(StringRef Name, StringRef DefaultVal, CheckerBase C) {
        return this.getOptionAsString(Name, DefaultVal, C, false);
    }

    public StringRef getOptionAsString(StringRef Name, StringRef DefaultVal, CheckerBase C, boolean SearchInParents) {
        return C != null ? this.getCheckerOption(C.getTagDescription(), new StringRef(Name), new StringRef(DefaultVal), SearchInParents) : new StringRef((std.string)((StringMapIterator)this.Config.insert((std_pair.pair)new std_pair.pair((std_pair.pair)std.make_pair((Object)Name, (Object)DefaultVal.str()))).first).$arrow().second);
    }

    public UserModeKind getUserMode() {
        if (this.UserMode == UserModeKind.UMK_NotSet) {
            StringRef ModeStr = new StringRef((std.string)((StringMapIterator)this.Config.insert((std_pair.pair)new std_pair.pair((std_pair.pair)std.make_pair((Object)new StringRef((String)"mode"), (Object)new std.string((CharSequence)"deep")))).first).$arrow().second);
            this.UserMode = (UserModeKind)((Object)new StringSwitch(ModeStr).Case("shallow", (Object)UserModeKind.UMK_Shallow).Case("deep", (Object)UserModeKind.UMK_Deep).Default((Object)UserModeKind.UMK_NotSet));
            assert (this.UserMode != UserModeKind.UMK_NotSet) : "User mode is invalid.";
        }
        return this.UserMode;
    }

    public IPAKind getIPAMode() {
        if (this.IPAMode == IPAKind.IPAK_NotSet) {
            char.ptr DefaultIPA = null;
            UserModeKind HighLevelMode = this.getUserMode();
            if (HighLevelMode == UserModeKind.UMK_Shallow) {
                DefaultIPA = Native.$tryClone((char.ptr)NativePointer.$((String)"inlining"));
            } else if (HighLevelMode == UserModeKind.UMK_Deep) {
                DefaultIPA = Native.$tryClone((char.ptr)NativePointer.$((String)"dynamic-bifurcate"));
            }
            assert (DefaultIPA != null);
            StringRef ModeStr = new StringRef((std.string)((StringMapIterator)this.Config.insert((std_pair.pair)new std_pair.pair((std_pair.pair)std.make_pair_T_Ptr((Object)new StringRef((String)"ipa"), (Object)new std.string((char.ptr)DefaultIPA)))).first).$arrow().second);
            IPAKind IPAConfig = (IPAKind)((Object)new StringSwitch(ModeStr).Case("none", (Object)IPAKind.IPAK_None).Case("basic-inlining", (Object)IPAKind.IPAK_BasicInlining).Case("inlining", (Object)IPAKind.IPAK_Inlining).Case("dynamic", (Object)IPAKind.IPAK_DynamicDispatch).Case("dynamic-bifurcate", (Object)IPAKind.IPAK_DynamicDispatchBifurcate).Default((Object)IPAKind.IPAK_NotSet));
            assert (IPAConfig != IPAKind.IPAK_NotSet) : "IPA Mode is invalid.";
            this.IPAMode = IPAConfig;
        }
        return this.IPAMode;
    }

    public boolean mayInlineCXXMemberFunction(CXXInlineableMemberKind K) {
        if (this.getIPAMode().getValue() < IPAKind.IPAK_Inlining.getValue()) {
            return false;
        }
        if (this.CXXMemberInliningMode.getValue() == 0) {
            char.ptr ModeKey = AnalyzerOptions$mayInlineCXXMemberFunction$$.ModeKey;
            StringRef ModeStr = new StringRef((std.string)((StringMapIterator)this.Config.insert((std_pair.pair)std.make_pair_Ptr_T((Object)new StringRef((char.ptr)ModeKey), (Object)new std.string((CharSequence)"destructors"))).first).$arrow().second);
            CXXInlineableMemberKind MutableMode = this.CXXMemberInliningMode;
            MutableMode = (CXXInlineableMemberKind)((Object)new StringSwitch(ModeStr).Case("constructors", (Object)CXXInlineableMemberKind.CIMK_Constructors).Case("destructors", (Object)CXXInlineableMemberKind.CIMK_Destructors).Case("none", (Object)CXXInlineableMemberKind.CIMK_None).Case("methods", (Object)CXXInlineableMemberKind.CIMK_MemberFunctions).Default((Object)CXXInlineableMemberKind.Uninitialized));
            if (MutableMode.getValue() == 0) {
                MutableMode = CXXInlineableMemberKind.CIMK_None;
            }
        }
        return this.CXXMemberInliningMode.getValue() >= K.getValue();
    }

    public boolean mayInlineObjCMethod() {
        return this.getBooleanOption(this.ObjCInliningMode, new StringRef("objc-inlining"), true);
    }

    public boolean includeTemporaryDtorsInCFG() {
        return this.getBooleanOption(this.IncludeTemporaryDtorsInCFG, new StringRef("cfg-temporary-dtors"), false);
    }

    public boolean mayInlineCXXStandardLibrary() {
        return this.getBooleanOption(this.InlineCXXStandardLibrary, new StringRef("c++-stdlib-inlining"), true);
    }

    public boolean mayInlineTemplateFunctions() {
        return this.getBooleanOption(this.InlineTemplateFunctions, new StringRef("c++-template-inlining"), true);
    }

    public boolean mayInlineCXXAllocator() {
        return this.getBooleanOption(this.InlineCXXAllocator, new StringRef("c++-allocator-inlining"), false);
    }

    public boolean mayInlineCXXContainerMethods() {
        return this.getBooleanOption(this.InlineCXXContainerMethods, new StringRef("c++-container-inlining"), false);
    }

    public boolean mayInlineCXXSharedPtrDtor() {
        return this.getBooleanOption(this.InlineCXXSharedPtrDtor, new StringRef("c++-shared_ptr-inlining"), false);
    }

    public boolean shouldSuppressNullReturnPaths() {
        return this.getBooleanOption(this.SuppressNullReturnPaths, new StringRef("suppress-null-return-paths"), true);
    }

    public boolean shouldAvoidSuppressingNullArgumentPaths() {
        return this.getBooleanOption(this.AvoidSuppressingNullArgumentPaths, new StringRef("avoid-suppressing-null-argument-paths"), false);
    }

    public boolean shouldSuppressInlinedDefensiveChecks() {
        return this.getBooleanOption(this.SuppressInlinedDefensiveChecks, new StringRef("suppress-inlined-defensive-checks"), true);
    }

    public boolean shouldSuppressFromCXXStandardLibrary() {
        return this.getBooleanOption(this.SuppressFromCXXStandardLibrary, new StringRef("suppress-c++-stdlib"), false);
    }

    public boolean shouldReportIssuesInMainSourceFile() {
        return this.getBooleanOption(this.ReportIssuesInMainSourceFile, new StringRef("report-in-main-source-file"), false);
    }

    public boolean shouldWriteStableReportFilename() {
        return this.getBooleanOption(this.StableReportFilename, new StringRef("stable-report-filename"), false);
    }

    public boolean shouldPrunePaths() {
        return this.getBooleanOption(new StringRef("prune-paths"), true);
    }

    public boolean shouldConditionalizeStaticInitializers() {
        return this.getBooleanOption(new StringRef("cfg-conditional-static-initializers"), true);
    }

    public int getAlwaysInlineSize() {
        if (!this.AlwaysInlineSize.hasValue()) {
            this.AlwaysInlineSize.$assign(this.getOptionAsInteger(new StringRef("ipa-always-inline-size"), 3));
        }
        return this.AlwaysInlineSize.getValue();
    }

    public int getMaxInlinableSize() {
        if (!this.MaxInlinableSize.hasValue()) {
            int DefaultValue = 0;
            UserModeKind HighLevelMode = this.getUserMode();
            switch (HighLevelMode) {
                default: {
                    throw new llvm_unreachable("Invalid mode.");
                }
                case UMK_Shallow: {
                    DefaultValue = 4;
                    break;
                }
                case UMK_Deep: {
                    DefaultValue = 50;
                }
            }
            this.MaxInlinableSize.$assign(this.getOptionAsInteger(new StringRef("max-inlinable-size"), DefaultValue));
        }
        return this.MaxInlinableSize.getValue();
    }

    public boolean shouldSynthesizeBodies() {
        return this.getBooleanOption(new StringRef("faux-bodies"), true);
    }

    public int getGraphTrimInterval() {
        if (!this.GraphTrimInterval.hasValue()) {
            this.GraphTrimInterval.$assign(this.getOptionAsInteger(new StringRef("graph-trim-interval"), 1000));
        }
        return this.GraphTrimInterval.getValue();
    }

    public int getMaxTimesInlineLarge() {
        if (!this.MaxTimesInlineLarge.hasValue()) {
            this.MaxTimesInlineLarge.$assign(this.getOptionAsInteger(new StringRef("max-times-inline-large"), 32));
        }
        return this.MaxTimesInlineLarge.getValue();
    }

    public int getMinCFGSizeTreatFunctionsAsLarge() {
        if (!this.MinCFGSizeTreatFunctionsAsLarge.hasValue()) {
            this.MinCFGSizeTreatFunctionsAsLarge.$assign(this.getOptionAsInteger(new StringRef("min-cfg-size-treat-functions-as-large"), 14));
        }
        return this.MinCFGSizeTreatFunctionsAsLarge.getValue();
    }

    public int getMaxNodesPerTopLevelFunction() {
        if (!this.MaxNodesPerTopLevelFunction.hasValue()) {
            int DefaultValue = 0;
            UserModeKind HighLevelMode = this.getUserMode();
            switch (HighLevelMode) {
                default: {
                    throw new llvm_unreachable("Invalid mode.");
                }
                case UMK_Shallow: {
                    DefaultValue = 75000;
                    break;
                }
                case UMK_Deep: {
                    DefaultValue = 150000;
                }
            }
            this.MaxNodesPerTopLevelFunction.$assign(this.getOptionAsInteger(new StringRef("max-nodes"), DefaultValue));
        }
        return this.MaxNodesPerTopLevelFunction.getValue();
    }

    public boolean shouldInlineLambdas() {
        if (!this.InlineLambdas.hasValue()) {
            this.InlineLambdas.$assign(this.getBooleanOption(new StringRef("inline-lambdas"), true));
        }
        return this.InlineLambdas.getValue();
    }

    public boolean shouldWidenLoops() {
        if (!this.WidenLoops.hasValue()) {
            this.WidenLoops.$assign(this.getBooleanOption(new StringRef("widen-loops"), false));
        }
        return this.WidenLoops.getValue();
    }

    public void $destroy() {
        this.WidenLoops.$destroy();
        this.InlineLambdas.$destroy();
        this.MaxNodesPerTopLevelFunction.$destroy();
        this.MinCFGSizeTreatFunctionsAsLarge.$destroy();
        this.MaxTimesInlineLarge.$destroy();
        this.GraphTrimInterval.$destroy();
        this.StableReportFilename.$destroy();
        this.ReportIssuesInMainSourceFile.$destroy();
        this.SuppressFromCXXStandardLibrary.$destroy();
        this.SuppressInlinedDefensiveChecks.$destroy();
        this.AvoidSuppressingNullArgumentPaths.$destroy();
        this.MaxInlinableSize.$destroy();
        this.SuppressNullReturnPaths.$destroy();
        this.AlwaysInlineSize.$destroy();
        this.ObjCInliningMode.$destroy();
        this.InlineCXXSharedPtrDtor.$destroy();
        this.InlineCXXContainerMethods.$destroy();
        this.InlineCXXAllocator.$destroy();
        this.InlineTemplateFunctions.$destroy();
        this.InlineCXXStandardLibrary.$destroy();
        this.IncludeTemporaryDtorsInCFG.$destroy();
        this.AnalyzeSpecificFunction.$destroy();
        this.Config.$destroy();
        this.CheckersControlList.$destroy();
        super.$destroy();
    }

    public String toString() {
        return "CheckersControlList=" + this.CheckersControlList + ", Config=" + this.Config + ", AnalysisStoreOpt=" + (Object)((Object)this.AnalysisStoreOpt) + ", AnalysisConstraintsOpt=" + (Object)((Object)this.AnalysisConstraintsOpt) + ", AnalysisDiagOpt=" + (Object)((Object)this.AnalysisDiagOpt) + ", AnalysisPurgeOpt=" + (Object)((Object)this.AnalysisPurgeOpt) + ", AnalyzeSpecificFunction=" + this.AnalyzeSpecificFunction + ", maxBlockVisitOnPath=" + this.maxBlockVisitOnPath + ", DisableAllChecks=" + this.DisableAllChecks + ", ShowCheckerHelp=" + this.ShowCheckerHelp + ", AnalyzeAll=" + this.AnalyzeAll + ", AnalyzerDisplayProgress=" + this.AnalyzerDisplayProgress + ", AnalyzeNestedBlocks=" + this.AnalyzeNestedBlocks + ", eagerlyAssumeBinOpBifurcation=" + this.eagerlyAssumeBinOpBifurcation + ", TrimGraph=" + this.TrimGraph + ", visualizeExplodedGraphWithGraphViz=" + this.visualizeExplodedGraphWithGraphViz + ", visualizeExplodedGraphWithUbiGraph=" + this.visualizeExplodedGraphWithUbiGraph + ", UnoptimizedCFG=" + this.UnoptimizedCFG + ", PrintStats=" + this.PrintStats + ", NoRetryExhausted=" + this.NoRetryExhausted + ", InlineMaxStackDepth=" + this.InlineMaxStackDepth + ", InliningMode=" + (Object)((Object)this.InliningMode) + ", UserMode=" + (Object)((Object)this.UserMode) + ", IPAMode=" + (Object)((Object)this.IPAMode) + ", CXXMemberInliningMode=" + (Object)((Object)this.CXXMemberInliningMode) + ", IncludeTemporaryDtorsInCFG=" + this.IncludeTemporaryDtorsInCFG + ", InlineCXXStandardLibrary=" + this.InlineCXXStandardLibrary + ", InlineTemplateFunctions=" + this.InlineTemplateFunctions + ", InlineCXXAllocator=" + this.InlineCXXAllocator + ", InlineCXXContainerMethods=" + this.InlineCXXContainerMethods + ", InlineCXXSharedPtrDtor=" + this.InlineCXXSharedPtrDtor + ", ObjCInliningMode=" + this.ObjCInliningMode + ", AlwaysInlineSize=" + this.AlwaysInlineSize + ", SuppressNullReturnPaths=" + this.SuppressNullReturnPaths + ", MaxInlinableSize=" + this.MaxInlinableSize + ", AvoidSuppressingNullArgumentPaths=" + this.AvoidSuppressingNullArgumentPaths + ", SuppressInlinedDefensiveChecks=" + this.SuppressInlinedDefensiveChecks + ", SuppressFromCXXStandardLibrary=" + this.SuppressFromCXXStandardLibrary + ", ReportIssuesInMainSourceFile=" + this.ReportIssuesInMainSourceFile + ", StableReportFilename=" + this.StableReportFilename + ", GraphTrimInterval=" + this.GraphTrimInterval + ", MaxTimesInlineLarge=" + this.MaxTimesInlineLarge + ", MinCFGSizeTreatFunctionsAsLarge=" + this.MinCFGSizeTreatFunctionsAsLarge + ", MaxNodesPerTopLevelFunction=" + this.MaxNodesPerTopLevelFunction + ", InlineLambdas=" + this.InlineLambdas + ", WidenLoops=" + this.WidenLoops + super.toString();
    }

    private static final class UserModeKind
    extends Enum<UserModeKind>
    implements Native.ComparableLower {
        public static final /* enum */ UserModeKind UMK_NotSet = new UserModeKind(0);
        public static final /* enum */ UserModeKind UMK_Shallow = new UserModeKind(1);
        public static final /* enum */ UserModeKind UMK_Deep = new UserModeKind(2);
        private final int value;
        private static final /* synthetic */ UserModeKind[] $VALUES;

        public static UserModeKind[] values() {
            return (UserModeKind[])$VALUES.clone();
        }

        public static UserModeKind valueOf(String name) {
            return Enum.valueOf(UserModeKind.class, name);
        }

        public static UserModeKind valueOf(int val) {
            UserModeKind out;
            UserModeKind userModeKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private UserModeKind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((UserModeKind)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((UserModeKind)((Object)obj)).value);
        }

        static {
            $VALUES = new UserModeKind[]{UMK_NotSet, UMK_Shallow, UMK_Deep};
        }

        private static final class Values {
            private static final UserModeKind[] VALUES;
            private static final UserModeKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (UserModeKind kind : UserModeKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new UserModeKind[min < 0 ? 1 - min : 0];
                VALUES = new UserModeKind[max >= 0 ? 1 + max : 0];
                for (UserModeKind kind : UserModeKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((UserModeKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((UserModeKind)kind).value] = kind;
                }
            }
        }
    }
}

