/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.tools.impl;

import java.util.Iterator;
import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.driver.Action;
import org.clang.driver.Command;
import org.clang.driver.Compilation;
import org.clang.driver.Driver;
import org.clang.driver.JobAction;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.InputInfo;
import org.clang.driver.impl.ToolsStatics;
import org.clang.driver.java.JavaDriverSupport;
import org.clang.driver.options;
import org.clang.driver.toolchains.impl.MachO;
import org.clang.driver.types;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.MutableArrayRefUInt;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;
import org.llvm.support.sys.WindowsEncodingMethod;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;

public final class DarwinStatics {
    public static Triple.ArchType getArchTypeForMachOArchName(StringRef Str) {
        return (Triple.ArchType)new StringSwitch(Str).Cases("ppc", "ppc601", "ppc603", "ppc604", "ppc604e", (Object)Triple.ArchType.ppc).Cases("ppc750", "ppc7400", "ppc7450", "ppc970", (Object)Triple.ArchType.ppc).Case("ppc64", (Object)Triple.ArchType.ppc64).Cases("i386", "i486", "i486SX", "i586", "i686", (Object)Triple.ArchType.x86).Cases("pentium", "pentpro", "pentIIm3", "pentIIm5", "pentium4", (Object)Triple.ArchType.x86).Cases("x86_64", "x86_64h", (Object)Triple.ArchType.x86_64).Cases("arm", "armv4t", "armv5", "armv6", "armv6m", (Object)Triple.ArchType.arm).Cases("armv7", "armv7em", "armv7k", "armv7m", (Object)Triple.ArchType.arm).Cases("armv7s", "xscale", (Object)Triple.ArchType.arm).Case("arm64", (Object)Triple.ArchType.aarch64).Case("r600", (Object)Triple.ArchType.r600).Case("amdgcn", (Object)Triple.ArchType.amdgcn).Case("nvptx", (Object)Triple.ArchType.nvptx).Case("nvptx64", (Object)Triple.ArchType.nvptx64).Case("amdil", (Object)Triple.ArchType.amdil).Case("spir", (Object)Triple.ArchType.spir).Default((Object)Triple.ArchType.UnknownArch);
    }

    public static void setTripleTypeForMachOArchName(Triple T, StringRef Str) {
        Triple.ArchType Arch = DarwinStatics.getArchTypeForMachOArchName(new StringRef(Str));
        T.setArch(Arch);
        if (llvm.$eq_StringRef((StringRef)Str, (String)"x86_64h")) {
            T.setArchName(new StringRef(Str));
        } else if (llvm.$eq_StringRef((StringRef)Str, (String)"armv6m") || llvm.$eq_StringRef((StringRef)Str, (String)"armv7m") || llvm.$eq_StringRef((StringRef)Str, (String)"armv7em")) {
            T.setOS(Triple.OSType.UnknownOS);
            T.setObjectFormat(Triple.ObjectFormatType.MachO);
        }
    }

    public static class VerifyDebug
    extends MachOTool
    implements Destructors.ClassWithDestructor {
        public VerifyDebug(ToolChain TC) {
            super(NativePointer.$((String)"darwin::VerifyDebug"), NativePointer.$((String)"dwarfdump"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                ArgStringList CmdArgs = new ArgStringList();
                CmdArgs.push_back((Object)NativePointer.$((String)"--verify"));
                CmdArgs.push_back((Object)NativePointer.$((String)"--debug-info"));
                CmdArgs.push_back((Object)NativePointer.$((String)"--eh-frame"));
                CmdArgs.push_back((Object)NativePointer.$((String)"--quiet"));
                assert (Inputs.size() == 1) : "Unable to handle multiple inputs.";
                InputInfo Input = (InputInfo)Inputs.$at(0);
                assert (Input.isFilename()) : "Unexpected verify input";
                CmdArgs.push_back((Object)Input.getFilename());
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(this.getToolChain().GetProgramPath(NativePointer.$((String)"dwarfdump")))));
                C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, (Tool)this, Exec, CmdArgs, Inputs))));
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Dsymutil
    extends MachOTool
    implements Destructors.ClassWithDestructor {
        public Dsymutil(ToolChain TC) {
            super(NativePointer.$((String)"darwin::Dsymutil"), NativePointer.$((String)"dsymutil"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        @Override
        public boolean isDsymutilJob() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                ArgStringList CmdArgs = new ArgStringList();
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                assert (Inputs.size() == 1) : "Unable to handle multiple inputs.";
                InputInfo Input = (InputInfo)Inputs.$at(0);
                assert (Input.isFilename()) : "Unexpected dsymutil input.";
                CmdArgs.push_back((Object)Input.getFilename());
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(this.getToolChain().GetProgramPath(NativePointer.$((String)"dsymutil")))));
                C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, (Tool)this, Exec, CmdArgs, Inputs))));
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Lipo
    extends MachOTool
    implements Destructors.ClassWithDestructor {
        public Lipo(ToolChain TC) {
            super(NativePointer.$((String)"darwin::Lipo"), NativePointer.$((String)"lipo"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                ArgStringList CmdArgs = new ArgStringList();
                CmdArgs.push_back((Object)NativePointer.$((String)"-create"));
                assert (Output.isFilename()) : "Unexpected lipo output.";
                CmdArgs.push_back((Object)NativePointer.$((String)"-output"));
                CmdArgs.push_back((Object)Output.getFilename());
                for (InputInfo II : Inputs) {
                    assert (II.isFilename()) : "Unexpected lipo input.";
                    CmdArgs.push_back((Object)II.getFilename());
                }
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(this.getToolChain().GetProgramPath(NativePointer.$((String)"lipo")))));
                C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, (Tool)this, Exec, CmdArgs, Inputs))));
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Linker
    extends MachOTool
    implements Destructors.ClassWithDestructor {
        private boolean NeedsTempPath(SmallVector<InputInfo> Inputs) {
            for (InputInfo Input : Inputs) {
                if (Input.getType() == types.ID.TY_Object) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void AddLinkArgs(Compilation C, ArgList Args, ArgStringList CmdArgs, SmallVector<InputInfo> Inputs) {
            JavaCleaner $c$;
            Driver D = this.getToolChain().getDriver();
            MachO MachOTC = this.getMachOToolChain();
            int[] Version = new int[]{0, 0, 0, 0, 0};
            Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mlinker_version_EQ.getValue()));
            if (A != null && !Driver.GetReleaseVersion(A.getValue(), new MutableArrayRefUInt(Version))) {
                $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(338))), (StringRef)new StringRef(A.getAsString(Args))));
                }
                finally {
                    $c$.$destroy();
                }
            }
            if (Unsigned.$greatereq_uint((int)Version[0], (int)100) && !Args.hasArg(new OptSpecifier(options.ID.OPT_Z_Xlinker__no_demangle.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-demangle"));
            }
            if (Args.hasArg(new OptSpecifier(options.ID.OPT_rdynamic.getValue())) && Unsigned.$greatereq_uint((int)Version[0], (int)137)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-export_dynamic"));
            }
            if (Args.hasFlag(new OptSpecifier(options.ID.OPT_fapplication_extension.getValue()), new OptSpecifier(options.ID.OPT_fno_application_extension.getValue()), false)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-application_extension"));
            }
            if (D.isUsingLTO()) {
                if (Unsigned.$greatereq_uint((int)Version[0], (int)116) && this.NeedsTempPath(Inputs)) {
                    char.ptr TmpPath = Native.$tryClone((char.ptr)C.getArgs().MakeArgString(new Twine(D.GetTemporaryPath(new StringRef("cc"), types.getTypeTempSuffix(types.ID.TY_Object)))));
                    C.addTempFile(TmpPath);
                    CmdArgs.push_back((Object)NativePointer.$((String)"-object_path_lto"));
                    CmdArgs.push_back((Object)TmpPath);
                }
                if (Unsigned.$greatereq_uint((int)Version[0], (int)133)) {
                    StringRef P = path.parent_path((StringRef)new StringRef(D.getInstalledDir()));
                    SmallString LibLTOPath = new SmallString(new StringRef(P), 128);
                    path.append((SmallString)LibLTOPath, (Twine)new Twine("lib"));
                    path.append((SmallString)LibLTOPath, (Twine)new Twine("libLTO.dylib"));
                    if (fs.exists((Twine)new Twine(LibLTOPath))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lto_library"));
                        CmdArgs.push_back((Object)C.getArgs().MakeArgString(new Twine(LibLTOPath)));
                    } else {
                        JavaCleaner $c$2 = Native.$createJavaCleaner();
                        try {
                            $c$2.clean($c$2.track((Object)D.Diag(389)));
                        }
                        finally {
                            $c$2.$destroy();
                        }
                    }
                }
            }
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_static.getValue()));
            if (!Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-dynamic"));
            }
            if (Args.hasArg(new OptSpecifier(options.ID.OPT_fgnu_runtime.getValue()))) {
                // empty if block
            }
            if (!Args.hasArg(new OptSpecifier(options.ID.OPT_dynamiclib.getValue()))) {
                this.AddMachOArch(Args, CmdArgs);
                Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_force__cpusubtype__ALL.getValue()));
                Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_bundle.getValue()));
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_bundle__loader.getValue()));
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_client__name.getValue()));
                A = Args.getLastArg(new OptSpecifier(options.ID.OPT_compatibility__version.getValue()));
                if (A != null || (A = Args.getLastArg(new OptSpecifier(options.ID.OPT_current__version.getValue()))) != null || (A = Args.getLastArg(new OptSpecifier(options.ID.OPT_install__name.getValue()))) != null) {
                    $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(307))), (StringRef)new StringRef(A.getAsString(Args))), (String)"-dynamiclib"));
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
                Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_force__flat__namespace.getValue()));
                Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_keep__private__externs.getValue()));
                Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_private__bundle.getValue()));
            } else {
                CmdArgs.push_back((Object)NativePointer.$((String)"-dylib"));
                A = Args.getLastArg(new OptSpecifier(options.ID.OPT_bundle.getValue()));
                if (A != null || (A = Args.getLastArg(new OptSpecifier(options.ID.OPT_bundle__loader.getValue()))) != null || (A = Args.getLastArg(new OptSpecifier(options.ID.OPT_client__name.getValue()))) != null || (A = Args.getLastArg(new OptSpecifier(options.ID.OPT_force__flat__namespace.getValue()))) != null || (A = Args.getLastArg(new OptSpecifier(options.ID.OPT_keep__private__externs.getValue()))) != null || (A = Args.getLastArg(new OptSpecifier(options.ID.OPT_private__bundle.getValue()))) != null) {
                    $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(306))), (StringRef)new StringRef(A.getAsString(Args))), (String)"-dynamiclib"));
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
                Args.AddAllArgsTranslated(CmdArgs, new OptSpecifier(options.ID.OPT_compatibility__version.getValue()), NativePointer.$((String)"-dylib_compatibility_version"));
                Args.AddAllArgsTranslated(CmdArgs, new OptSpecifier(options.ID.OPT_current__version.getValue()), NativePointer.$((String)"-dylib_current_version"));
                this.AddMachOArch(Args, CmdArgs);
                Args.AddAllArgsTranslated(CmdArgs, new OptSpecifier(options.ID.OPT_install__name.getValue()), NativePointer.$((String)"-dylib_install_name"));
            }
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_all__load.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_allowable__client.getValue()));
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_bind__at__load.getValue()));
            if (MachOTC.isTargetIOSBased()) {
                Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_arch__errors__fatal.getValue()));
            }
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_dead__strip.getValue()));
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_no__dead__strip__inits__and__terms.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_dylib__file.getValue()));
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_dynamic.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_exported__symbols__list.getValue()));
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_flat__namespace.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_force__load.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_headerpad__max__install__names.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_image__base.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_init.getValue()));
            MachOTC.addMinVersionArgs(Args, CmdArgs);
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_nomultidefs.getValue()));
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_multi__module.getValue()));
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_single__module.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_multiply__defined.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_multiply__defined__unused.getValue()));
            A = Args.getLastArg(new OptSpecifier(options.ID.OPT_fpie.getValue()), new OptSpecifier(options.ID.OPT_fPIE.getValue()), new OptSpecifier(options.ID.OPT_fno_pie.getValue()), new OptSpecifier(options.ID.OPT_fno_PIE.getValue()));
            if (A != null) {
                if (A.getOption().matches(new OptSpecifier(options.ID.OPT_fpie.getValue())) || A.getOption().matches(new OptSpecifier(options.ID.OPT_fPIE.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-pie"));
                } else {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-no_pie"));
                }
            }
            if (C.getDriver().embedBitcodeEnabled() || C.getDriver().embedBitcodeMarkerOnly()) {
                if (MachOTC.SupportsEmbeddedBitcode()) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-bitcode_bundle"));
                } else {
                    JavaCleaner $c$3 = Native.$createJavaCleaner();
                    try {
                        $c$3.clean($c$3.track((Object)D.Diag(308)));
                    }
                    finally {
                        $c$3.$destroy();
                    }
                }
            }
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_prebind.getValue()));
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_noprebind.getValue()));
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_nofixprebinding.getValue()));
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_prebind__all__twolevel__modules.getValue()));
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_read__only__relocs.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_sectcreate.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_sectorder.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_seg1addr.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_segprot.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_segaddr.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_segs__read__only__addr.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_segs__read__write__addr.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_seg__addr__table.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_seg__addr__table__filename.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_sub__library.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_sub__umbrella.getValue()));
            StringRef sysroot = C.getSysRoot();
            if (llvm.$noteq_StringRef((StringRef)sysroot, (String)"")) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-syslibroot"));
                CmdArgs.push_back((Object)C.getArgs().MakeArgString(new Twine(sysroot)));
            } else {
                Arg A2 = Args.getLastArg(new OptSpecifier(options.ID.OPT_isysroot.getValue()));
                if (A2 != null) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-syslibroot"));
                    CmdArgs.push_back((Object)A2.getValue());
                }
            }
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_twolevel__namespace.getValue()));
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_twolevel__namespace__hints.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_umbrella.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_undefined.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_unexported__symbols__list.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_weak__reference__mismatches.getValue()));
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_X_Flag.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_y.getValue()));
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_w.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_pagezero__size.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_segs__read__.getValue()));
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_seglinkedit.getValue()));
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_noseglinkedit.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_sectalign.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_sectobjectsymbols.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_segcreate.getValue()));
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_whyload.getValue()));
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_whatsloaded.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_dylinker__install__name.getValue()));
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_dylinker.getValue()));
            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_Mach.getValue()));
        }

        public Linker(ToolChain TC) {
            super(NativePointer.$((String)"darwin::Linker"), NativePointer.$((String)"linker"), TC, Tool.ResponseFileSupport.RF_FileList, WindowsEncodingMethod.WEM_UTF8, NativePointer.$((String)"-filelist"));
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        @Override
        public boolean isLinkJob() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            std_ptr.unique_ptr Cmd = null;
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                Arg A;
                assert (Output.getType() == types.ID.TY_Image) : "Invalid linker output type.";
                ArgStringList InputFileList = new ArgStringList();
                ArgStringList CmdArgs = new ArgStringList();
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_ccc_arcmt_check.getValue()), new OptSpecifier(options.ID.OPT_ccc_arcmt_migrate.getValue()))) {
                    for (Arg Arg2 : Args) {
                        Arg2.claim();
                    }
                    char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(this.getToolChain().GetProgramPath(NativePointer.$((String)"touch")))));
                    CmdArgs.push_back((Object)Output.getFilename());
                    C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, (Tool)this, Exec, CmdArgs, (ArrayRef<InputInfo>)ArrayRef.None()))));
                    $c$.clean();
                    return;
                }
                this.AddLinkArgs(C, Args, CmdArgs, Inputs);
                Args.AddAllArgs(CmdArgs, new ArrayRef((Object[])JavaDriverSupport.$IDsToOptSpecifiers(new options.ID[]{options.ID.OPT_d_Flag, options.ID.OPT_s, options.ID.OPT_t, options.ID.OPT_Z_Flag, options.ID.OPT_u_Group, options.ID.OPT_e, options.ID.OPT_r})));
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_ObjC.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_ObjCXX.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-ObjC"));
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nostartfiles.getValue()))) {
                    this.getMachOToolChain().addStartObjectFileArgs(Args, CmdArgs);
                }
                if (this.getToolChain().getSanitizerArgs().needsSafeStackRt()) {
                    this.getMachOToolChain().AddLinkRuntimeLib(Args, CmdArgs, new StringRef("libclang_rt.safestack_osx.a"), true);
                }
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_L.getValue()));
                ToolsStatics.AddLinkerInputs(this.getToolChain(), Inputs, Args, CmdArgs);
                for (InputInfo II : Inputs) {
                    if (!II.isFilename()) {
                        if (!Unsigned.$greater_uint((int)InputFileList.size(), (int)0)) continue;
                        break;
                    }
                    InputFileList.push_back((Object)II.getFilename());
                }
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nodefaultlibs.getValue()))) {
                    ToolsStatics.addOpenMPRuntime(CmdArgs, this.getToolChain(), Args);
                }
                if (ToolsStatics.isObjCRuntimeLinked(Args) && !Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nodefaultlibs.getValue()))) {
                    this.getMachOToolChain().AddLinkARCArgs(Args, CmdArgs);
                    CmdArgs.push_back((Object)NativePointer.$((String)"-framework"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"Foundation"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lobjc"));
                }
                if (LinkingOutput != null) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-arch_multiple"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-final_output"));
                    CmdArgs.push_back((Object)LinkingOutput);
                }
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_fnested_functions.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-allow_stack_execute"));
                }
                this.getMachOToolChain().addProfileRTLibs(Args, CmdArgs);
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nodefaultlibs.getValue()))) {
                    if (this.getToolChain().getDriver().CCCIsCXX()) {
                        this.getToolChain().AddCXXStdlibLibArgs(Args, CmdArgs);
                    }
                    this.getMachOToolChain().AddLinkRuntimeLibArgs(Args, CmdArgs);
                }
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nostartfiles.getValue()))) {
                    // empty if block
                }
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_T_Group.getValue()));
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_F.getValue()));
                for (Arg A2 : Args.filtered(new OptSpecifier(options.ID.OPT_iframework.getValue()))) {
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_string_T((std.string)new std.string((CharSequence)"-F"), (char.ptr)A2.getValue()))));
                }
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nodefaultlibs.getValue())) && (A = Args.getLastArg(new OptSpecifier(options.ID.OPT_fveclib.getValue()))) != null && llvm.$eq_StringRef((char.ptr)A.getValue(), (String)"Accelerate")) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-framework"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"Accelerate"));
                }
                Iterator Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(this.getToolChain().GetLinkerPath())));
                Cmd = llvm.make_unique((Object)new Command((Action)JA, (Tool)this, (char.ptr)Exec, CmdArgs, Inputs));
                ((Command)Cmd.$arrow()).setInputFileList(new ArgStringList(JavaDifferentiators.JD.Move.INSTANCE, (ArgStringList)std.move((Object)InputFileList)));
                C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(new std_ptr.unique_ptr(JavaDifferentiators.JD.Move.INSTANCE, std.move((std_ptr.unique_ptr)Cmd))));
                $c$.clean();
            }
            finally {
                if (Cmd != null) {
                    Cmd.$destroy();
                }
                $c$.$destroy();
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Assembler
    extends MachOTool
    implements Destructors.ClassWithDestructor {
        public Assembler(ToolChain TC) {
            super(NativePointer.$((String)"darwin::Assembler"), NativePointer.$((String)"assembler"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                Triple T;
                ArgStringList CmdArgs = new ArgStringList();
                assert (Inputs.size() == 1) : "Unexpected number of inputs.";
                InputInfo Input = (InputInfo)Inputs.$at(0);
                Action SourceAction = JA;
                while (SourceAction.getKind() != Action.ActionClass.InputClass) {
                    assert (!SourceAction.getInputs().empty()) : "unexpected root action!";
                    SourceAction = (Action)SourceAction.getInputs().$at(0);
                }
                if (!(!Args.hasArg(new OptSpecifier(options.ID.OPT_fno_integrated_as.getValue())) || (T = this.getToolChain().getTriple()).isMacOSX() && T.isMacOSXVersionLT(10, 7))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-Q"));
                }
                if (SourceAction.getType() == types.ID.TY_Asm || SourceAction.getType() == types.ID.TY_PP_Asm) {
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_gstabs.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--gstabs"));
                    } else if (Args.hasArg(new OptSpecifier(options.ID.OPT_g_Group.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-g"));
                    }
                }
                this.AddMachOArch(Args, CmdArgs);
                if (this.getToolChain().getArch() == Triple.ArchType.x86 || this.getToolChain().getArch() == Triple.ArchType.x86_64 || Args.hasArg(new OptSpecifier(options.ID.OPT_force__cpusubtype__ALL.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-force_cpusubtype_ALL"));
                }
                if (this.getToolChain().getArch() != Triple.ArchType.x86_64 && ((Args.hasArg(new OptSpecifier(options.ID.OPT_mkernel.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_fapple_kext.getValue()))) && this.getMachOToolChain().isKernelStatic() || Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue())))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-static"));
                }
                Args.AddAllArgValues(CmdArgs, new OptSpecifier(options.ID.OPT_Wa_COMMA.getValue()), new OptSpecifier(options.ID.OPT_Xassembler.getValue()));
                assert (Output.isFilename()) : "Unexpected lipo output.";
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                assert (Input.isFilename()) : "Invalid input.";
                CmdArgs.push_back((Object)Input.getFilename());
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(this.getToolChain().GetProgramPath(NativePointer.$((String)"as")))));
                C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, (Tool)this, Exec, CmdArgs, Inputs))));
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static abstract class MachOTool
    extends Tool
    implements Destructors.ClassWithDestructor {
        protected void anchor() {
        }

        protected void AddMachOArch(ArgList Args, ArgStringList CmdArgs) {
            StringRef ArchName = this.getMachOToolChain().getMachOArchName(Args);
            CmdArgs.push_back((Object)NativePointer.$((String)"-arch"));
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(ArchName)));
            if (llvm.$eq_StringRef((StringRef)ArchName, (String)"arm")) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-force_cpusubtype_ALL"));
            }
        }

        protected MachO getMachOToolChain() {
            return (MachO)Casts.reinterpret_cast(MachO.class, (Object)this.getToolChain());
        }

        public MachOTool(char.ptr Name, char.ptr ShortName, ToolChain TC) {
            this(Name, ShortName, TC, Tool.ResponseFileSupport.RF_None, WindowsEncodingMethod.WEM_UTF8, NativePointer.$AT);
        }

        public MachOTool(char.ptr Name, char.ptr ShortName, ToolChain TC, Tool.ResponseFileSupport ResponseSupport) {
            this(Name, ShortName, TC, ResponseSupport, WindowsEncodingMethod.WEM_UTF8, NativePointer.$AT);
        }

        public MachOTool(char.ptr Name, char.ptr ShortName, ToolChain TC, Tool.ResponseFileSupport ResponseSupport, WindowsEncodingMethod ResponseEncoding) {
            this(Name, ShortName, TC, ResponseSupport, ResponseEncoding, NativePointer.$AT);
        }

        public MachOTool(char.ptr Name, char.ptr ShortName, ToolChain TC, Tool.ResponseFileSupport ResponseSupport, WindowsEncodingMethod ResponseEncoding, char.ptr ResponseFlag) {
            super(Name, ShortName, TC, ResponseSupport, ResponseEncoding, ResponseFlag);
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }
}

