/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.options;

import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.options.EditorOptions;
import org.netbeans.modules.cnd.editor.options.PreviewPreferences;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;

public class BooleanNodeProp
extends PropertySupport<Boolean> {
    private final CodeStyle.Language language;
    private final String optionID;
    private PreviewPreferences preferences;
    private boolean state;

    public BooleanNodeProp(CodeStyle.Language language, PreviewPreferences preferences, String optionID) {
        super(optionID, Boolean.class, BooleanNodeProp.getString("LBL_" + optionID), BooleanNodeProp.getString("HINT_" + optionID), true, true);
        this.language = language;
        this.optionID = optionID;
        this.preferences = preferences;
        this.init();
    }

    public BooleanNodeProp(CodeStyle.Language language, PreviewPreferences preferences, String optionID, boolean state) {
        super(optionID, Boolean.class, BooleanNodeProp.getString("LBL_" + optionID), BooleanNodeProp.getString("HINT_" + optionID), true, false);
        this.language = language;
        this.optionID = optionID;
        this.preferences = preferences;
        this.state = state;
    }

    private static String getString(String key) {
        return NbBundle.getMessage(BooleanNodeProp.class, (String)key);
    }

    private void init() {
        this.state = this.getPreferences().getBoolean(this.optionID, this.getDefault());
    }

    private boolean getDefault() {
        return (Boolean)EditorOptions.getDefault(this.getPreferences().getLanguage(), this.getPreferences().getStyleId(), this.optionID);
    }

    private PreviewPreferences getPreferences() {
        return this.preferences;
    }

    public String getHtmlDisplayName() {
        if (!this.isDefaultValue()) {
            return "<b>" + this.getDisplayName();
        }
        return null;
    }

    public Boolean getValue() {
        return this.state;
    }

    public void setValue(Boolean v) {
        this.state = v;
        this.getPreferences().putBoolean(this.optionID, this.state);
    }

    public void restoreDefaultValue() {
        this.setValue(this.getDefault());
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public boolean isDefaultValue() {
        return this.getDefault() == this.getValue().booleanValue();
    }
}

