/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran.reformat;

import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranDiffLinkedList;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranReformatter;

public class FortranExtendedTokenSequence {
    private final TokenSequence<FortranTokenId> ts;
    private final FortranDiffLinkedList diffs;
    private final int tabSize;
    private final boolean expandTabToSpaces;

    FortranExtendedTokenSequence(TokenSequence<FortranTokenId> ts, FortranDiffLinkedList diffs, int tabSize, boolean expandTabToSpaces) {
        this.ts = ts;
        this.diffs = diffs;
        this.tabSize = tabSize;
        this.expandTabToSpaces = expandTabToSpaces;
    }

    FortranReformatter.Diff replacePrevious(Token<FortranTokenId> previous, int newLines, int spaces, boolean isIndent) {
        String old = previous.text().toString();
        if (!FortranReformatter.Diff.equals(old, newLines, spaces, isIndent, this.expandTabToSpaces, this.tabSize)) {
            return this.diffs.addFirst(this.ts.offset() - previous.length(), this.ts.offset(), newLines, spaces, isIndent);
        }
        return null;
    }

    FortranReformatter.Diff addBeforeCurrent(int newLines, int spaces, boolean isIndent) {
        if (newLines + spaces > 0) {
            return this.diffs.addFirst(this.ts.offset(), this.ts.offset(), newLines, spaces, isIndent);
        }
        return null;
    }

    FortranReformatter.Diff replaceCurrent(Token<FortranTokenId> current, int newLines, int spaces, boolean isIndent) {
        String old = current.text().toString();
        if (!FortranReformatter.Diff.equals(old, newLines, spaces, isIndent, this.expandTabToSpaces, this.tabSize)) {
            return this.diffs.addFirst(this.ts.offset(), this.ts.offset() + current.length(), newLines, spaces, isIndent);
        }
        return null;
    }

    FortranReformatter.Diff addAfterCurrent(Token<FortranTokenId> current, int newLines, int spaces, boolean isIndent) {
        if (newLines + spaces > 0) {
            return this.diffs.addFirst(this.ts.offset() + current.length(), this.ts.offset() + current.length(), newLines, spaces, isIndent);
        }
        return null;
    }

    FortranReformatter.Diff replaceNext(Token<FortranTokenId> current, Token<FortranTokenId> next, int newLines, int spaces, boolean isIndent) {
        String old = next.text().toString();
        if (!FortranReformatter.Diff.equals(old, newLines, spaces, isIndent, this.expandTabToSpaces, this.tabSize)) {
            return this.diffs.addFirst(this.ts.offset() + current.length(), this.ts.offset() + current.length() + next.length(), newLines, spaces, isIndent);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getFirstLineTokenPosition() {
        int index = this.ts.index();
        try {
            int column = 0;
            block9: while (this.ts.moveNext()) {
                switch ((FortranTokenId)this.ts.token().id()) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: {
                        int n = 0;
                        return n;
                    }
                    case WHITESPACE: {
                        String text = this.ts.token().text().toString();
                        for (int i = 0; i < text.length(); ++i) {
                            char c = text.charAt(i);
                            if (c == '\t') {
                                column = (column / this.tabSize + 1) * this.tabSize;
                                continue;
                            }
                            ++column;
                        }
                        continue block9;
                    }
                }
                int n = column;
                return n;
            }
            int n = column;
            return n;
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getTokenPosition() {
        int index = this.ts.index();
        try {
            int column = 0;
            boolean first = true;
            block13: while (this.ts.movePrevious()) {
                FortranDiffLinkedList.DiffResult diff = this.diffs.getDiffs(this, 0);
                if (diff != null) {
                    if (diff.before != null) {
                        column += diff.before.spaceLength();
                        if (diff.before.hasNewLine()) {
                            int n = column;
                            return n;
                        }
                    }
                    if (diff.replace != null) {
                        column += diff.replace.spaceLength();
                        if (!diff.replace.hasNewLine()) continue;
                        int n = column;
                        return n;
                    }
                    if (first && diff.after != null) {
                        column += diff.after.spaceLength();
                        if (diff.after.hasNewLine()) {
                            int n = column;
                            return n;
                        }
                    }
                }
                first = false;
                switch ((FortranTokenId)this.ts.token().id()) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: {
                        int n = column;
                        return n;
                    }
                    case LINE_COMMENT_FIXED: 
                    case LINE_COMMENT_FREE: {
                        String text = this.ts.token().text().toString();
                        int i = text.lastIndexOf(10);
                        if (i < 0) {
                            column += text.length();
                            break;
                        }
                        int n = column += text.length() - i + 1;
                        return n;
                    }
                    case WHITESPACE: {
                        int i;
                        String text = this.ts.token().text().toString();
                        for (i = 0; i < text.length(); ++i) {
                            char c = text.charAt(i);
                            if (c == '\t') {
                                column = (column / this.tabSize + 1) * this.tabSize;
                                continue;
                            }
                            ++column;
                        }
                        continue block13;
                    }
                    default: {
                        column += this.ts.token().length();
                    }
                }
            }
            int n = column;
            return n;
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    Token<FortranTokenId> lookNextImportant() {
        int index = this.ts.index();
        try {
            block7: while (this.ts.moveNext()) {
                switch ((FortranTokenId)this.ts.token().id()) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: 
                    case WHITESPACE: 
                    case LINE_COMMENT_FIXED: 
                    case LINE_COMMENT_FREE: {
                        continue block7;
                    }
                }
                Token token = this.ts.token();
                return token;
            }
            Token<FortranTokenId> token = null;
            return token;
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<FortranTokenId> lookNextImportant(int i) {
        int index = this.ts.index();
        try {
            block7: while (this.ts.moveNext()) {
                switch ((FortranTokenId)this.ts.token().id()) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: 
                    case WHITESPACE: 
                    case LINE_COMMENT_FIXED: 
                    case LINE_COMMENT_FREE: {
                        continue block7;
                    }
                }
                if (--i > 0) continue;
                Token token = this.ts.token();
                return token;
            }
            Token<FortranTokenId> token = null;
            return token;
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    Token<FortranTokenId> lookNextLineImportant() {
        int index = this.ts.index();
        try {
            block9: while (this.ts.moveNext()) {
                switch ((FortranTokenId)this.ts.token().id()) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: 
                    case LINE_COMMENT_FIXED: 
                    case LINE_COMMENT_FREE: {
                        Token<FortranTokenId> token = null;
                        return token;
                    }
                    case WHITESPACE: {
                        continue block9;
                    }
                }
                Token token = this.ts.token();
                return token;
            }
            Token<FortranTokenId> token = null;
            return token;
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<FortranTokenId> lookNextLineImportant(int i) {
        int index = this.ts.index();
        try {
            block9: while (this.ts.moveNext()) {
                switch ((FortranTokenId)this.ts.token().id()) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: 
                    case LINE_COMMENT_FIXED: 
                    case LINE_COMMENT_FREE: {
                        Token<FortranTokenId> token = null;
                        return token;
                    }
                    case WHITESPACE: {
                        continue block9;
                    }
                }
                if (--i != 0) continue;
                Token token = this.ts.token();
                return token;
            }
            Token<FortranTokenId> token = null;
            return token;
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<FortranTokenId> lookNextLineImportantAfter(FortranTokenId tokenId) {
        int index = this.ts.index();
        boolean find = this.ts.token().id() == tokenId;
        try {
            block9: while (this.ts.moveNext()) {
                switch ((FortranTokenId)this.ts.token().id()) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: 
                    case LINE_COMMENT_FIXED: 
                    case LINE_COMMENT_FREE: {
                        Token<FortranTokenId> token = null;
                        return token;
                    }
                    case WHITESPACE: {
                        continue block9;
                    }
                }
                if (this.ts.token().id() == tokenId) {
                    find = true;
                    continue;
                }
                if (!find) continue;
                Token token = this.ts.token();
                return token;
            }
            Token<FortranTokenId> token = null;
            return token;
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasLineToken(FortranTokenId tokenId) {
        int index = this.ts.index();
        boolean hasContinuation = false;
        try {
            block12: while (this.ts.moveNext()) {
                switch ((FortranTokenId)this.ts.token().id()) {
                    case NEW_LINE: {
                        if (hasContinuation) continue block12;
                        boolean bl = false;
                        return bl;
                    }
                    case PREPROCESSOR_DIRECTIVE: 
                    case LINE_COMMENT_FIXED: 
                    case LINE_COMMENT_FREE: {
                        boolean bl = false;
                        return bl;
                    }
                    case AMPERSAND: {
                        hasContinuation = true;
                        continue block12;
                    }
                    case WHITESPACE: {
                        continue block12;
                    }
                }
                hasContinuation = false;
                if (this.ts.token().id() != tokenId) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FortranTokenId hasLineToken(FortranTokenId ... tokenId) {
        int index = this.ts.index();
        boolean hasContinuation = false;
        try {
            FortranTokenId[] fortranTokenIdArray;
            block12: while (this.ts.moveNext()) {
                switch ((FortranTokenId)this.ts.token().id()) {
                    case NEW_LINE: {
                        if (hasContinuation) continue block12;
                        fortranTokenIdArray = null;
                        return fortranTokenIdArray;
                    }
                    case PREPROCESSOR_DIRECTIVE: 
                    case LINE_COMMENT_FIXED: 
                    case LINE_COMMENT_FREE: {
                        fortranTokenIdArray = null;
                        return fortranTokenIdArray;
                    }
                    case AMPERSAND: {
                        hasContinuation = true;
                        continue block12;
                    }
                    case WHITESPACE: {
                        continue block12;
                    }
                }
                hasContinuation = false;
                for (FortranTokenId t : tokenId) {
                    if (this.ts.token().id() != t) continue;
                    FortranTokenId fortranTokenId = t;
                    return fortranTokenId;
                }
            }
            fortranTokenIdArray = null;
            return fortranTokenIdArray;
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<FortranTokenId> lookPreviousStatement() {
        int index = this.ts.index();
        int balance = 0;
        if (this.ts.token().id() == FortranTokenId.RPAREN) {
            balance = 1;
        }
        try {
            block10: while (this.ts.movePrevious()) {
                switch ((FortranTokenId)this.ts.token().id()) {
                    case LPAREN: {
                        if (balance == 0) {
                            Token<FortranTokenId> token = null;
                            return token;
                        }
                        --balance;
                        continue block10;
                    }
                    case RPAREN: {
                        ++balance;
                        continue block10;
                    }
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: 
                    case WHITESPACE: 
                    case LINE_COMMENT_FIXED: 
                    case LINE_COMMENT_FREE: {
                        continue block10;
                    }
                }
                if (balance != 0) continue;
                Token token = this.ts.token();
                return token;
            }
            Token<FortranTokenId> token = null;
            return token;
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    Token<FortranTokenId> lookNext() {
        if (this.ts.moveNext()) {
            Token next = this.ts.token();
            this.ts.movePrevious();
            return next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<FortranTokenId> lookNext(int i) {
        int index = this.ts.index();
        try {
            while (i-- > 0) {
                if (this.ts.moveNext()) continue;
                Token<FortranTokenId> token = null;
                return token;
            }
            Token token = this.ts.token();
            return token;
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    boolean isLastLineToken() {
        int index = this.ts.index();
        try {
            while (true) {
                if (!this.ts.moveNext()) {
                    boolean bl = true;
                    return bl;
                }
                FortranDiffLinkedList.DiffResult diff = this.diffs.getDiffs(this, 0);
                if (diff != null && diff.replace != null) {
                    if (!diff.replace.hasNewLine()) continue;
                    boolean bl = true;
                    return bl;
                }
                FortranTokenId id = (FortranTokenId)this.ts.token().id();
                switch (id) {
                    case NEW_LINE: 
                    case LINE_COMMENT_FIXED: 
                    case LINE_COMMENT_FREE: {
                        boolean bl = true;
                        return bl;
                    }
                    case WHITESPACE: {
                        break;
                    }
                    default: {
                        boolean bl = false;
                        return bl;
                    }
                }
            }
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    Token<FortranTokenId> lookPreviousLineImportant() {
        int index = this.ts.index();
        try {
            block9: while (this.ts.movePrevious()) {
                switch ((FortranTokenId)this.ts.token().id()) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: 
                    case LINE_COMMENT_FIXED: 
                    case LINE_COMMENT_FREE: {
                        Token<FortranTokenId> token = null;
                        return token;
                    }
                    case WHITESPACE: {
                        continue block9;
                    }
                }
                Token token = this.ts.token();
                return token;
            }
            Token<FortranTokenId> token = null;
            return token;
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    Token<FortranTokenId> lookPreviousImportant() {
        int index = this.ts.index();
        try {
            block7: while (this.ts.movePrevious()) {
                switch ((FortranTokenId)this.ts.token().id()) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: 
                    case WHITESPACE: 
                    case LINE_COMMENT_FIXED: 
                    case LINE_COMMENT_FREE: {
                        continue block7;
                    }
                }
                Token token = this.ts.token();
                return token;
            }
            Token<FortranTokenId> token = null;
            return token;
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<FortranTokenId> lookPreviousImportant(int i) {
        int index = this.ts.index();
        try {
            block7: while (this.ts.movePrevious()) {
                switch ((FortranTokenId)this.ts.token().id()) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: 
                    case WHITESPACE: 
                    case LINE_COMMENT_FIXED: 
                    case LINE_COMMENT_FREE: {
                        continue block7;
                    }
                }
                if (--i > 0) continue;
                Token token = this.ts.token();
                return token;
            }
            Token<FortranTokenId> token = null;
            return token;
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    Token<FortranTokenId> lookPrevious() {
        if (this.ts.movePrevious()) {
            Token previous = this.ts.token();
            this.ts.moveNext();
            return previous;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<FortranTokenId> lookPrevious(int i) {
        int index = this.ts.index();
        try {
            while (i-- > 0) {
                if (this.ts.movePrevious()) continue;
                Token<FortranTokenId> token = null;
                return token;
            }
            Token token = this.ts.token();
            return token;
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    boolean isFirstLineToken() {
        int index = this.ts.index();
        try {
            while (true) {
                if (!this.ts.movePrevious()) {
                    boolean bl = true;
                    return bl;
                }
                FortranDiffLinkedList.DiffResult diff = this.diffs.getDiffs(this, 0);
                if (diff != null) {
                    if (diff.after != null && diff.after.hasNewLine()) {
                        boolean bl = true;
                        return bl;
                    }
                    if (diff.replace != null) {
                        if (!diff.replace.hasNewLine()) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
                if (this.ts.token().id() == FortranTokenId.NEW_LINE || this.ts.token().id() == FortranTokenId.PREPROCESSOR_DIRECTIVE) {
                    boolean bl = true;
                    return bl;
                }
                if (this.ts.token().id() == FortranTokenId.WHITESPACE) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    Token<FortranTokenId> findOpenParenToken(int parenDepth) {
        int index = this.ts.index();
        try {
            while (true) {
                if (!this.ts.movePrevious()) {
                    Token<FortranTokenId> token = null;
                    return token;
                }
                if (this.ts.token().id() == FortranTokenId.LPAREN) {
                    if (--parenDepth != 0) continue;
                    Token<FortranTokenId> token = this.lookPreviousImportant();
                    return token;
                }
                if (this.ts.token().id() != FortranTokenId.RPAREN) continue;
                ++parenDepth;
            }
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    int openParenIndent(int parenDepth) {
        return this.openBraceIndent(parenDepth, FortranTokenId.LPAREN, FortranTokenId.RPAREN);
    }

    private int openBraceIndent(int braceDepth, FortranTokenId open, FortranTokenId close) {
        int index = this.ts.index();
        try {
            while (true) {
                if (!this.ts.movePrevious()) {
                    int n = -1;
                    return n;
                }
                if (this.ts.token().id() == open) {
                    if (--braceDepth != 0) continue;
                    this.ts.moveNext();
                    int n = this.getTokenPosition();
                    return n;
                }
                if (this.ts.token().id() != close) continue;
                ++braceDepth;
            }
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getNewLinesBeforeDeclaration(int start) {
        int[] res = new int[]{-1, -1, 0};
        int index = this.ts.index();
        try {
            block14: {
                boolean hasDoc = false;
                this.ts.moveIndex(start);
                while (true) {
                    if (!this.ts.movePrevious()) {
                        res[0] = 0;
                        int[] nArray = res;
                        return nArray;
                    }
                    if (this.ts.token().id() == FortranTokenId.NEW_LINE || this.ts.token().id() == FortranTokenId.WHITESPACE) {
                        if (res[1] == -1) {
                            res[1] = this.ts.index();
                        }
                        res[0] = this.ts.index();
                        continue;
                    }
                    if (this.ts.token().id() != FortranTokenId.LINE_COMMENT_FIXED && this.ts.token().id() != FortranTokenId.LINE_COMMENT_FREE) break block14;
                    if (!this.isFirstLineToken()) break;
                    if (hasDoc) {
                        res[2] = 1;
                        int[] nArray = res;
                        return nArray;
                    }
                    res[0] = -1;
                    res[1] = -1;
                    hasDoc = true;
                }
                res[2] = 1;
                int[] nArray = res;
                return nArray;
            }
            if (this.ts.token().id() == FortranTokenId.PREPROCESSOR_DIRECTIVE) {
                if (res[0] == -1) {
                    res[0] = this.ts.index() + 1;
                    res[1] = this.ts.index();
                }
                int[] nArray = res;
                return nArray;
            }
            res[2] = 1;
            int[] nArray = res;
            return nArray;
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    public Language<FortranTokenId> language() {
        return this.ts.language();
    }

    public LanguagePath languagePath() {
        return this.ts.languagePath();
    }

    public Token<FortranTokenId> token() {
        return this.ts.token();
    }

    public Token<FortranTokenId> offsetToken() {
        return this.ts.offsetToken();
    }

    public int offset() {
        return this.ts.offset();
    }

    public int index() {
        return this.ts.index();
    }

    public <ET extends TokenId> TokenSequence<ET> embedded(Language<ET> embeddedLanguage) {
        return this.ts.embedded(embeddedLanguage);
    }

    public boolean moveNext() {
        return this.ts.moveNext();
    }

    public boolean movePrevious() {
        return this.ts.movePrevious();
    }

    public int moveIndex(int index) {
        return this.ts.moveIndex(index);
    }

    public void moveStart() {
        this.ts.moveStart();
    }

    public void moveEnd() {
        this.ts.moveEnd();
    }

    public int move(int offset) {
        return this.ts.move(offset);
    }

    public boolean isEmpty() {
        return this.ts.isEmpty();
    }

    public int tokenCount() {
        return this.ts.tokenCount();
    }

    public String toString() {
        return this.apply(this.diffs, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String apply(FortranDiffLinkedList diffs, FortranExtendedTokenSequence ts) {
        int index = ts.index();
        StringBuilder buf = new StringBuilder();
        try {
            ts.moveStart();
            while (ts.moveNext()) {
                buf.append(ts.token().text());
            }
            int startOffset = 0;
            int endOffset = buf.length();
            for (FortranReformatter.Diff diff : diffs.getStorage()) {
                int start = diff.getStartOffset();
                int end = diff.getEndOffset();
                String text = diff.getText(this.expandTabToSpaces, this.tabSize);
                if (startOffset > end || endOffset < start) {
                    System.err.println("What?" + startOffset + ":" + start + "-" + end);
                    continue;
                }
                if (endOffset < end) {
                    if (text != null && text.length() > 0) {
                        text = end - endOffset >= text.length() ? null : text.substring(0, text.length() - end + endOffset);
                    }
                    end = endOffset;
                }
                if (end - start > 0) {
                    buf.delete(start, end);
                }
                if (text == null || text.length() <= 0) continue;
                buf.insert(start, text);
            }
            String string = buf.toString().replaceAll("\n", "\\\\n\n");
            return string;
        }
        finally {
            ts.moveIndex(index);
            ts.moveNext();
        }
    }
}

