/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.support;

import javax.swing.Icon;
import org.netbeans.api.actions.Openable;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.ElementGripFactory;
import org.openide.filesystems.FileObject;

public final class ElementGrip
implements Openable {
    private static final boolean LAZY = false;
    private CsmUID<CsmOffsetable> thisObject;
    private String toString;
    private FileObject fileObject;
    private Icon icon;
    private ElementGrip parent;
    private boolean parentInited;

    public ElementGrip(CsmOffsetable object) {
        this.thisObject = CsmRefactoringUtils.getHandler(object);
        this.toString = CsmRefactoringUtils.getHtml((CsmObject)object);
        this.fileObject = CsmRefactoringUtils.getFileObject((CsmObject)object);
        this.icon = CsmImageLoader.getIcon((CsmObject)object);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String toString() {
        if (this.toString == null) {
            // empty if block
        }
        return this.toString;
    }

    void initParent() {
        if (!this.parentInited) {
            this.parent = ElementGripFactory.getDefault().getParent(this);
            this.parentInited = true;
        }
    }

    public ElementGrip getParent() {
        this.initParent();
        return this.parent;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public CsmOffsetable getResolved() {
        return (CsmOffsetable)this.thisObject.getObject();
    }

    public void open() {
        CsmOffsetable resolved = this.getResolved();
        if (resolved != null) {
            CsmUtilities.openSource((CsmObject)resolved);
        }
    }
}

