/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.Utils;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.RenameCommand;
import org.netbeans.modules.git.remote.cli.progress.FileListener;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.Cancellable;

public class CopyCommand
extends GitCommand {
    private final VCSFileProxy source;
    private final VCSFileProxy target;
    private final ProgressMonitor monitor;
    private final FileListener listener;

    public CopyCommand(JGitRepository repository, GitClassFactory gitFactory, VCSFileProxy source, VCSFileProxy target, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.source = source;
        this.target = target;
        this.monitor = monitor;
        this.listener = listener;
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        boolean retval = super.prepareCommand();
        if (retval) {
            String relPathToTarget;
            VCSFileProxy workTree = this.getRepository().getLocation();
            String relPathToSource = Utils.getRelativePath(workTree, this.source);
            if (relPathToSource.startsWith((relPathToTarget = Utils.getRelativePath(workTree, this.target)) + "/")) {
                this.monitor.preparationsFailed(MessageFormat.format(Utils.getBundle(CopyCommand.class).getString("MSG_Error_SourceFolderUnderTarget"), relPathToSource, relPathToTarget));
                throw new GitException(MessageFormat.format(Utils.getBundle(CopyCommand.class).getString("MSG_Error_SourceFolderUnderTarget"), relPathToSource, relPathToTarget));
            }
            if (relPathToTarget.startsWith(relPathToSource + "/")) {
                this.monitor.preparationsFailed(MessageFormat.format(Utils.getBundle(CopyCommand.class).getString("MSG_Error_TargetFolderUnderSource"), relPathToTarget, relPathToSource));
                throw new GitException(MessageFormat.format(Utils.getBundle(CopyCommand.class).getString("MSG_Error_TargetFolderUnderSource"), relPathToTarget, relPathToSource));
            }
        }
        return retval;
    }

    @Override
    protected void prepare() throws GitException {
        this.setCommandsNumber(2);
        super.prepare();
        this.addArgument(0, "ls-files");
        this.addArgument(0, "--");
        this.addArgument(0, Utils.getRelativePath(this.getRepository().getLocation(), this.source));
        this.addArgument(1, "add");
        this.addArgument(1, "-v");
        this.addArgument(1, "--");
    }

    @Override
    protected void run() throws GitException {
        block6: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                this.copy();
                final ArrayList list = new ArrayList();
                final String from = Utils.getRelativePath(this.getRepository().getLocation(), this.source);
                final String to = Utils.getRelativePath(this.getRepository().getLocation(), this.target);
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        for (String line : output.split("\n")) {
                            if (line.length() <= 0) continue;
                            String file = line.trim();
                            if (file.startsWith(from)) {
                                file = to + file.substring(from.length());
                            }
                            list.add(file);
                        }
                    }
                }.runCLI();
                if (list.size() > 0) {
                    for (String file : list) {
                        this.addArgument(1, file);
                    }
                    new GitCommand.Runner(canceled, 1){

                        @Override
                        public void outputParser(String output) throws GitException {
                            CopyCommand.this.parseAddVerboseOutput(output);
                        }

                        @Override
                        protected void errorParser(String error) throws GitException {
                            CopyCommand.this.parseAddError(error);
                        }
                    }.runCLI();
                }
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block6;
                throw new GitException(t);
            }
        }
    }

    private void copy() throws GitException {
        VCSFileProxy parentFile = this.target.getParentFile();
        if (!parentFile.exists() && !VCSFileProxySupport.mkdirs((VCSFileProxy)parentFile)) {
            throw new GitException(MessageFormat.format(Utils.getBundle(RenameCommand.class).getString("MSG_Exception_CannotCreateFolder"), parentFile.getPath()));
        }
        try {
            if (!this.target.exists() && !VCSFileProxySupport.copyFile((VCSFileProxy)this.source, (VCSFileProxy)this.target)) {
                throw new GitException(MessageFormat.format(Utils.getBundle(RenameCommand.class).getString("MSG_Exception_CannotRenameTo"), this.source.getPath(), this.target.getPath()));
            }
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    private void parseAddVerboseOutput(String output) {
        for (String line : output.split("\n")) {
            String s;
            if (!line.startsWith("add") || !(s = line.substring(3).trim()).startsWith("'") || !s.endsWith("'")) continue;
            String file = s.substring(1, s.length() - 1);
            this.listener.notifyFile(VCSFileProxy.createFileProxy((VCSFileProxy)this.getRepository().getLocation(), (String)file), file);
        }
    }

    private void parseAddError(String error) {
        this.processMessages(error);
    }
}

