/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileView;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.remote.ui.RemoteFileChooserUtil;
import org.netbeans.modules.cnd.remote.actions.OpenRemoteProjectAction;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class RemoteOpenHelper {
    private final ExecutionEnvironment env;
    private static final Logger LOGGER = Logger.getLogger("cnd.remote.logger");
    private static boolean isRunning = false;
    private static final Object lock = new Object();
    private static final RequestProcessor RP = new RequestProcessor("Opening remote project", 1);
    private static final Map<ExecutionEnvironment, String> lastUsedDirs = new HashMap<ExecutionEnvironment, String>();

    private RemoteOpenHelper(ExecutionEnvironment env) {
        this.env = env;
    }

    public static void openFile(ExecutionEnvironment env) {
        new RemoteOpenHelper(env).openFile();
    }

    public static void openProject(ExecutionEnvironment env) {
        new RemoteOpenHelper(env).openProject();
    }

    private void openFile() {
        this.openImpl(this.getOpenRemoteFileWorker(this.env));
    }

    private void openProject() {
        this.openImpl(this.getOpenRemoteProjectWorker(this.env));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openImpl(final Runnable worker) {
        Runnable connectWrapper = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ConnectionManager.getInstance().connectTo(RemoteOpenHelper.this.env);
                    worker.run();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, "Error connecting " + RemoteOpenHelper.this.env, ex);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(OpenRemoteProjectAction.class, (String)"ErrorConnectingHost", (Object)RemoteOpenHelper.this.env.getDisplayName(), (Object)ex.getMessage()), 0));
                }
                catch (ConnectionManager.CancellationException cancellationException) {
                    Object object = lock;
                    synchronized (object) {
                        isRunning = false;
                    }
                }
                finally {
                    Object object = lock;
                    synchronized (object) {
                        isRunning = false;
                    }
                }
            }
        };
        Object object = lock;
        synchronized (object) {
            if (!isRunning) {
                isRunning = true;
                RP.post(connectWrapper);
            }
        }
    }

    private static Callable<String> getCurrentDirectory(final ExecutionEnvironment env) {
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                String homeDir;
                FileObject primaryFile;
                DataObject d;
                TopComponent activated;
                if (Boolean.getBoolean("netbeans.openfile.197063") && (activated = TopComponent.getRegistry().getActivated()) != null && WindowManager.getDefault().isOpenedEditorTopComponent(activated) && (d = (DataObject)activated.getLookup().lookup(DataObject.class)) != null && (primaryFile = d.getPrimaryFile()) != null && primaryFile.isValid()) {
                    try {
                        FileObject parent;
                        if (primaryFile.getFileSystem().equals(FileSystemProvider.getFileSystem((ExecutionEnvironment)env)) && (parent = primaryFile.getParent()) != null && parent.isValid()) {
                            return parent.getPath();
                        }
                    }
                    catch (FileStateInvalidException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if ((homeDir = (String)lastUsedDirs.get(env)) == null) {
                    homeDir = RemoteOpenHelper.getRemoteHomeDir(env);
                }
                return homeDir;
            }
        };
    }

    private Runnable getOpenRemoteFileWorker(final ExecutionEnvironment env) {
        Runnable worker = new Runnable(){

            @Override
            public void run() {
                final Callable homeDir = RemoteOpenHelper.getCurrentDirectory(env);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        final JFileChooser fileChooser = RemoteFileChooserUtil.createFileChooser((ExecutionEnvironment)env, (String)NbBundle.getMessage(OpenRemoteProjectAction.class, (String)"OpenFileTitle"), (String)NbBundle.getMessage(OpenRemoteProjectAction.class, (String)"OpenFileButtonText"), (int)0, null, (Callable)homeDir, (boolean)true);
                        int ret = fileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
                        if (ret == 1) {
                            return;
                        }
                        Runnable worker = new Runnable(){

                            @Override
                            public void run() {
                                FileObject fo = FileSystemProvider.fileToFileObject((File)fileChooser.getSelectedFile());
                                if (fo == null) {
                                    return;
                                }
                                FileObject parent = fo.getParent();
                                if (parent != null) {
                                    lastUsedDirs.put(env, parent.getPath());
                                }
                                if (!fo.isValid() || !fo.isData()) {
                                    return;
                                }
                                try {
                                    DataObject dob = DataObject.find((FileObject)fo);
                                    EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
                                    if (ec != null) {
                                        ec.open();
                                    }
                                }
                                catch (DataObjectNotFoundException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                        };
                        RP.post(worker);
                    }
                });
            }
        };
        return worker;
    }

    private Runnable getOpenRemoteProjectWorker(final ExecutionEnvironment env) {
        Runnable worker = new Runnable(){

            @Override
            public void run() {
                final String home = (String)lastUsedDirs.get(env);
                final Callable<String> homeDirCallable = home != null ? new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return home;
                    }
                } : RemoteOpenHelper.getRemoteProjectDirCallable(env);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        final JFileChooser fileChooser = RemoteFileChooserUtil.createFileChooser((ExecutionEnvironment)env, (String)NbBundle.getMessage(OpenRemoteProjectAction.class, (String)"OpenProjectTitle"), (String)NbBundle.getMessage(OpenRemoteProjectAction.class, (String)"OpenProjectButtonText"), (int)1, null, (Callable)homeDirCallable, (boolean)true);
                        fileChooser.setFileView(new ProjectSelectionFileView(fileChooser));
                        fileChooser.setMultiSelectionEnabled(true);
                        int ret = fileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
                        if (ret == 1) {
                            return;
                        }
                        Runnable worker = new Runnable(){

                            @Override
                            public void run() {
                                File[] files = fileChooser.getSelectedFiles();
                                if (files == null || files.length == 0) {
                                    return;
                                }
                                FileObject parent = null;
                                ArrayList<Project> projects = new ArrayList<Project>(files.length);
                                for (File file : files) {
                                    FileObject remoteProjectFO = FileSystemProvider.fileToFileObject((File)file);
                                    if (remoteProjectFO == null) continue;
                                    if (parent == null && (parent = remoteProjectFO.getParent()) != null) {
                                        lastUsedDirs.put(env, parent.getPath());
                                    }
                                    if (!remoteProjectFO.isValid() || !remoteProjectFO.isFolder()) continue;
                                    try {
                                        Project project = ProjectManager.getDefault().findProject(remoteProjectFO);
                                        if (project == null) continue;
                                        projects.add(project);
                                    }
                                    catch (IOException ex) {
                                        StatusDisplayer.getDefault().setStatusText(ex.getLocalizedMessage());
                                        ex.printStackTrace(System.err);
                                    }
                                    catch (IllegalArgumentException ex) {
                                        Exceptions.printStackTrace((Throwable)ex);
                                    }
                                }
                                OpenProjects.getDefault().open(projects.toArray(new Project[projects.size()]), false, true);
                            }
                        };
                        RP.post(worker);
                    }
                });
            }
        };
        return worker;
    }

    private static Callable<String> getRemoteProjectDirCallable(final ExecutionEnvironment env) {
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    return HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getUserDir() + '/' + ProjectChooser.getProjectsFolder().getName() + '/';
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
                catch (ConnectionManager.CancellationException cancellationException) {
                    // empty catch block
                }
                return null;
            }
        };
    }

    private static String getRemoteProjectDir(ExecutionEnvironment env) {
        try {
            return HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getUserDir() + '/' + ProjectChooser.getProjectsFolder().getName() + '/';
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        catch (ConnectionManager.CancellationException cancellationException) {
            // empty catch block
        }
        return null;
    }

    private static String getRemoteHomeDir(ExecutionEnvironment env) {
        try {
            return HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getUserDir() + '/';
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        catch (ConnectionManager.CancellationException cancellationException) {
            // empty catch block
        }
        return null;
    }

    private static final class ProjectSelectionFileView
    extends FileView
    implements Runnable {
        private final JFileChooser chooser;
        private final Map<File, Icon> knownProjectIcons = new HashMap<File, Icon>();
        private final RequestProcessor.Task task = new RequestProcessor("ProjectIconFileView").create((Runnable)this);
        private File lookingForIcon;

        public ProjectSelectionFileView(JFileChooser chooser) {
            this.chooser = chooser;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Icon getIcon(File f) {
            if (f.isDirectory() && !f.toString().matches("/[^/]+") && f.getParentFile() != null) {
                ProjectSelectionFileView projectSelectionFileView = this;
                synchronized (projectSelectionFileView) {
                    Icon icon = this.knownProjectIcons.get(f);
                    if (icon != null) {
                        return icon;
                    }
                    if (this.lookingForIcon == null) {
                        this.lookingForIcon = f;
                        this.task.schedule(20);
                    }
                }
            }
            return this.chooser.getFileSystemView().getSystemIcon(f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String path = this.lookingForIcon.getAbsolutePath();
            String project = path + "/nbproject";
            File projectDir = this.chooser.getFileSystemView().createFileObject(project);
            Icon icon = this.chooser.getFileSystemView().getSystemIcon(this.lookingForIcon);
            if (projectDir.exists() && projectDir.isDirectory() && projectDir.canRead()) {
                String projectXml = path + "/nbproject/project.xml";
                File projectFile = this.chooser.getFileSystemView().createFileObject(projectXml);
                if (projectFile.exists()) {
                    String conf = path + "/nbproject/configurations.xml";
                    File configuration = this.chooser.getFileSystemView().createFileObject(conf);
                    if (configuration.exists()) {
                        icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/resources/makeProject.gif", (boolean)true);
                    }
                }
            }
            ProjectSelectionFileView projectSelectionFileView = this;
            synchronized (projectSelectionFileView) {
                this.knownProjectIcons.put(this.lookingForIcon, icon);
                this.lookingForIcon = null;
            }
            this.chooser.repaint();
        }
    }
}

