/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.util.LinkedList;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.util.Mutex;

class AuxiliaryPropertiesImpl
implements AuxiliaryProperties {
    private final AntProjectHelper helper;
    private static final String propertyPrefix = "auxiliary.";

    AuxiliaryPropertiesImpl(AntProjectHelper helper) {
        this.helper = helper;
    }

    public String get(String key, boolean shared) {
        String location = shared ? "nbproject/project.properties" : "nbproject/private/private.properties";
        EditableProperties props = this.helper.getProperties(location);
        return props.get(propertyPrefix + key);
    }

    public void put(final String key, final String value, final boolean shared) {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                String location = shared ? "nbproject/project.properties" : "nbproject/private/private.properties";
                EditableProperties props = AuxiliaryPropertiesImpl.this.helper.getProperties(location);
                if (value != null) {
                    props.put(AuxiliaryPropertiesImpl.propertyPrefix + key, value);
                } else {
                    props.remove(AuxiliaryPropertiesImpl.propertyPrefix + key);
                }
                AuxiliaryPropertiesImpl.this.helper.putProperties(location, props);
                return null;
            }
        });
    }

    public Iterable<String> listKeys(boolean shared) {
        LinkedList<String> result = new LinkedList<String>();
        String location = shared ? "nbproject/project.properties" : "nbproject/private/private.properties";
        EditableProperties props = this.helper.getProperties(location);
        for (String k : props.keySet()) {
            if (!k.startsWith(propertyPrefix)) continue;
            result.add(k.substring(propertyPrefix.length()));
        }
        return result;
    }
}

