/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.configurations;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerInfoElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.netbeans.modules.cnd.makeproject.ui.configurations.PackagingAdditionalInfoPanel;
import org.netbeans.modules.cnd.makeproject.ui.configurations.PackagingFiles4Panel;
import org.netbeans.modules.cnd.makeproject.ui.configurations.PackagingFilesOuterPanel;
import org.netbeans.modules.cnd.makeproject.ui.configurations.PackagingFilesPanel;
import org.netbeans.modules.cnd.makeproject.ui.configurations.PackagingInfoOuterPanel;
import org.netbeans.modules.cnd.makeproject.ui.configurations.PackagingInfoPanel;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PackagingPanel
extends JPanel
implements HelpCtx.Provider,
PropertyChangeListener {
    private PackagingConfiguration packagingConfiguration;
    private final PropertyEditorSupport editor;
    private final MakeConfiguration conf;
    private PackagingInfoOuterPanel packagingInfoOuterPanel = null;
    private PackagingInfoPanel packagingInfoPanel = null;
    private PackagingAdditionalInfoPanel packagingAdditionalInfoPanel = null;
    private PackagingFilesOuterPanel packagingFilesOuterPanel = null;
    private PackagingFilesPanel packagingFilesPanel = null;
    private JTabbedPane tabbedPane;

    public PackagingPanel(PackagingConfiguration packagingConfiguration, PropertyEditorSupport editor, PropertyEnv env, MakeConfiguration conf) {
        this.initComponents();
        this.packagingConfiguration = packagingConfiguration;
        this.editor = editor;
        this.conf = conf;
        env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        env.addPropertyChangeListener((PropertyChangeListener)this);
        String type = packagingConfiguration.getType().getValue();
        PackagerDescriptor packager = PackagerManager.getDefault().getPackager(packagingConfiguration.getType().getValue());
        if (packager.hasInfoList()) {
            this.packagingInfoPanel = new PackagingInfoPanel(packagingConfiguration.getHeaderSubList(type), packagingConfiguration);
            this.packagingAdditionalInfoPanel = new PackagingAdditionalInfoPanel(packagingConfiguration.getAdditionalInfo().getValue(), packagingConfiguration);
            this.packagingInfoOuterPanel = new PackagingInfoOuterPanel(this.packagingInfoPanel, this.packagingAdditionalInfoPanel);
            this.packagingFilesPanel = new PackagingFilesPanel(packagingConfiguration.getFiles().getValue(), conf.getBaseFSPath());
        } else {
            this.packagingFilesPanel = new PackagingFiles4Panel(packagingConfiguration.getFiles().getValue(), conf.getBaseFSPath());
        }
        this.packagingFilesOuterPanel = new PackagingFilesOuterPanel(this.packagingFilesPanel, packagingConfiguration);
        this.tabbedPane.addTab(PackagingPanel.getString("InfoPanelText"), this.packagingInfoOuterPanel);
        this.tabbedPane.addTab(PackagingPanel.getString("FilePanelText"), this.packagingFilesOuterPanel);
        if (packager.hasInfoList()) {
            this.tabbedPane.setEnabledAt(0, true);
            this.tabbedPane.setEnabledAt(1, true);
            this.tabbedPane.setSelectedIndex(0);
        } else {
            this.tabbedPane.setEnabledAt(0, false);
            this.tabbedPane.setEnabledAt(1, true);
            this.tabbedPane.setSelectedIndex(1);
        }
        this.setPreferredSize(new Dimension(600, 500));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
            this.editor.setValue(this.getPropertyValue());
        }
    }

    private Object getPropertyValue() throws IllegalStateException {
        PackagerDescriptor packager = PackagerManager.getDefault().getPackager(this.packagingConfiguration.getType().getValue());
        if (packager.hasInfoList()) {
            List oldList = this.packagingConfiguration.getInfo().getValue();
            ArrayList<PackagerInfoElement> newList = new ArrayList<PackagerInfoElement>();
            for (PackagerInfoElement elem2 : oldList) {
                if (elem2.getPackager().equals(this.packagingConfiguration.getType().getValue())) continue;
                newList.add(elem2);
            }
            List editedList = this.packagingInfoPanel.getListData();
            editedList.forEach(elem -> newList.add((PackagerInfoElement)elem));
            this.packagingConfiguration.getInfo().setValue(newList);
            this.packagingConfiguration.getAdditionalInfo().setValue(this.packagingAdditionalInfoPanel.getListData());
        }
        this.packagingConfiguration.getFiles().setValue(new ArrayList(this.packagingFilesPanel.getListData()));
        return this.packagingConfiguration;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("PackagingFiles");
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tabbedPane, gridBagConstraints);
        this.tabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PackagingPanel.class, (String)"PackagingPanel.tabbedPane.AccessibleContext.accessibleName"));
        this.tabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PackagingPanel.class, (String)"PackagingPanel.tabbedPane.AccessibleContext.accessibleDescription"));
    }

    private static String getString(String s) {
        return NbBundle.getBundle(PackagingPanel.class).getString(s);
    }
}

