/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.nodes;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.WLModuleNode;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions.RefreshModulesCookie;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class WLModuleChildFactory
extends ChildFactory<WLModuleNode>
implements RefreshModulesCookie {
    private static final Logger LOGGER = Logger.getLogger(WLModuleChildFactory.class.getName());
    private final Lookup lookup;
    private final ModuleType moduleType;

    public WLModuleChildFactory(Lookup lookup, ModuleType moduleType) {
        this.lookup = lookup;
        this.moduleType = moduleType;
    }

    @Override
    public final void refresh() {
        this.refresh(false);
    }

    protected Node createNodeForKey(WLModuleNode key) {
        return key;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean createKeys(List<WLModuleNode> toPopulate) {
        WLDeploymentManager dm = (WLDeploymentManager)this.lookup.lookup(WLDeploymentManager.class);
        try {
            TargetModuleID[] modules = dm.getAvailableModules(this.moduleType, dm.getTargets());
            TargetModuleID[] stopped = dm.getNonRunningModules(this.moduleType, dm.getTargets());
            HashSet<String> stoppedByName = new HashSet<String>();
            if (stopped != null) {
                void var8_12;
                TargetModuleID[] targetModuleIDArray = stopped;
                int n = targetModuleIDArray.length;
                boolean bl = false;
                while (var8_12 < n) {
                    TargetModuleID module = targetModuleIDArray[var8_12];
                    stoppedByName.add(module.getModuleID());
                    ++var8_12;
                }
            }
            if (modules != null) {
                Arrays.sort(modules, new Comparator<TargetModuleID>(){

                    @Override
                    public int compare(TargetModuleID o1, TargetModuleID o2) {
                        if (o1.getModuleID() == null) {
                            return o2.getModuleID() == null ? 0 : -1;
                        }
                        if (o2.getModuleID() == null) {
                            return 1;
                        }
                        return o1.getModuleID().compareTo(o2.getModuleID());
                    }
                });
                HashMap<String, LinkedList<TargetModuleID>> byName = new HashMap<String, LinkedList<TargetModuleID>>();
                for (TargetModuleID module : modules) {
                    String name = module.getModuleID();
                    LinkedList<TargetModuleID> ids = (LinkedList<TargetModuleID>)byName.get(name);
                    if (ids == null) {
                        ids = new LinkedList<TargetModuleID>();
                        byName.put(name, ids);
                    }
                    ids.add(module);
                }
                for (Map.Entry entry : byName.entrySet()) {
                    toPopulate.add(new WLModuleNode((String)entry.getKey(), (List)entry.getValue(), this.lookup, this.moduleType, stoppedByName.contains(entry.getKey())));
                }
            }
        }
        catch (IllegalStateException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (TargetException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        return true;
    }
}

