/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ResourceTable {
    public static final String PARENT_RESOURCE_TABLE = "ParentResourceTable";
    private ArrayList<WeakReference<PropertyChangeListener>> listeners = new ArrayList();
    private HashMap<String, ArrayList<WeakReference<PropertyChangeListener>>> propertyListeners = new HashMap();
    private HashMap<String, Object> properties = new HashMap();
    private ArrayList<WeakReference<ResourceTable>> childrenTables = new ArrayList();
    private ResourceTable parentTable = null;

    public ResourceTable(ResourceTable parent) {
        this();
        this.parentTable = parent;
        if (this.parentTable != null) {
            this.parentTable.addChild(this);
        }
    }

    public ResourceTable() {
    }

    public void setParentTable(ResourceTable parent) {
        ResourceTable oldTable = this.parentTable;
        this.parentTable = parent;
        this.firePropertyChange(PARENT_RESOURCE_TABLE, oldTable, parent);
    }

    public ResourceTable getParentTable() {
        return this.parentTable;
    }

    private void addChild(ResourceTable childTable) {
        this.childrenTables.add(new WeakReference<ResourceTable>(childTable));
    }

    private void removeChild(ResourceTable childTable) {
        this.childrenTables.remove(childTable);
    }

    public void removeParent() {
        this.parentTable.removeChild(this);
        this.parentTable = null;
    }

    public void clear() {
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            this.firePropertyChange(entry.getKey(), entry.getValue(), null);
        }
        this.properties.clear();
    }

    public Object getProperty(String name) {
        Object retVal = this.properties.get(name);
        if (retVal == null && this.parentTable != null) {
            retVal = this.parentTable.getProperty(name);
        }
        return retVal;
    }

    public void addProperty(String name, Object value) {
        Object oldValue = this.properties.remove(name);
        if (value != null) {
            this.properties.put(name, value);
        }
        this.firePropertyChange(name, oldValue, value);
    }

    public Set<String> getLocalPropertyNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
            this.addPropertyChangeListener(proxy.getPropertyName(), (PropertyChangeListener)proxy.getListener());
        } else {
            this.listeners.add(new WeakReference<PropertyChangeListener>(listener));
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        ArrayList<WeakReference<PropertyChangeListener>> propListeners = this.propertyListeners.get(propertyName);
        if (propListeners == null) {
            propListeners = new ArrayList();
            this.propertyListeners.put(propertyName, propListeners);
        }
        propListeners.add(new WeakReference<PropertyChangeListener>(listener));
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        for (int index = this.listeners.size() - 1; index >= 0; --index) {
            WeakReference<PropertyChangeListener> ref = this.listeners.get(index);
            PropertyChangeListener refListener = (PropertyChangeListener)ref.get();
            if (refListener != null) {
                if (!refListener.equals(listener)) continue;
                this.listeners.remove(index);
                continue;
            }
            this.listeners.remove(index);
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        ArrayList<WeakReference<PropertyChangeListener>> propListeners = this.propertyListeners.get(propertyName);
        if (propListeners != null) {
            for (int index = propListeners.size() - 1; index >= 0; --index) {
                WeakReference<PropertyChangeListener> ref = propListeners.get(index);
                PropertyChangeListener refListener = (PropertyChangeListener)ref.get();
                if (refListener != null) {
                    if (!refListener.equals(listener)) continue;
                    propListeners.remove(index);
                    continue;
                }
                propListeners.remove(index);
            }
        }
    }

    private void firePropertyChange(String name, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, name, oldValue, newValue);
        this.firePropertyChange(name, event);
    }

    private void firePropertyChange(String name, PropertyChangeEvent event) {
        this.fireEventAndCleanList(this.listeners, event);
        ArrayList<WeakReference<PropertyChangeListener>> propListeners = this.propertyListeners.get(name);
        if (propListeners != null) {
            this.fireEventAndCleanList(propListeners, event);
        }
        for (int index = this.childrenTables.size() - 1; index >= 0; --index) {
            WeakReference<ResourceTable> childRef = this.childrenTables.get(index);
            if (childRef.get() != null) {
                ((ResourceTable)childRef.get()).notifyPropertyChanged(name, event);
                continue;
            }
            this.childrenTables.remove(index);
        }
    }

    private void fireParentChangedChange(ResourceTable oldTable, ResourceTable newTable) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, PARENT_RESOURCE_TABLE, oldTable, newTable);
        this.fireEventAndCleanList(this.listeners, event);
        for (String key : this.propertyListeners.keySet()) {
            Object newResource;
            Object oldResource;
            if (this.properties.containsKey(key) || (oldResource = oldTable.getProperty(key)).equals(newResource = this.getProperty(key))) continue;
            this.firePropertyChange(key, oldResource, newResource);
        }
        for (int index = this.childrenTables.size() - 1; index >= 0; --index) {
            WeakReference<ResourceTable> childRef = this.childrenTables.get(index);
            if (childRef.get() != null) {
                ((ResourceTable)childRef.get()).notifyPropertyChanged(PARENT_RESOURCE_TABLE, event);
                continue;
            }
            this.childrenTables.remove(index);
        }
    }

    private void fireEventAndCleanList(ArrayList<WeakReference<PropertyChangeListener>> refListeners, PropertyChangeEvent event) {
        for (int index = refListeners.size() - 1; index >= 0; --index) {
            WeakReference<PropertyChangeListener> ref = refListeners.get(index);
            PropertyChangeListener refListener = (PropertyChangeListener)ref.get();
            if (refListener != null) {
                refListener.propertyChange(event);
                continue;
            }
            refListeners.remove(index);
        }
    }

    private void notifyPropertyChanged(String name, PropertyChangeEvent event) {
        if (!PARENT_RESOURCE_TABLE.equals(name) && !this.properties.containsKey(name)) {
            this.firePropertyChange(name, event);
        }
    }
}

