/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tools.services.impl;

import java.util.LinkedList;
import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FileData;
import org.clang.basic.FileManager;
import org.clang.basic.FileSystemOptions;
import org.clang.basic.FileSystemStatCache;
import org.clang.basic.vfs.FileSystem;
import org.clang.frontend.PTHCachedTokensProducer;
import org.clang.lex.PTHManager;
import org.clang.lex.java.PTHManagerDriver;
import org.clang.tools.services.impl.PreprocessorSupport;
import org.clang.tools.services.impl.SharedMemoryBufferCache;
import org.clang.tools.services.impl.SharedNoStatMissingCache;
import org.clang.tools.services.impl.SharedStatCache;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.NativeTrace;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.StringMap;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;

final class PreprocessorInitializerHelper {
    private static final PTHCachedTokensProducer $CachedTokensProducer = new PTHCachedTokensProducer();
    private static final boolean SHARED_FILE_MANAGER = false;
    private static final FileSystemOptions FileMgrOpts = new FileSystemOptions();
    private static FileManager $FileMgr = null;
    private static final LinkedList<std_pair.pair<std.string, std_pair.pair<PTHManager, MemoryBuffer>>> $ManagedPTH = new LinkedList();

    private PreprocessorInitializerHelper() {
    }

    static FileManager $getFileManager(SharedMemoryBufferCache sharedMemoryBufferCache, StringMap<FileData> FileStatCache, StringMap<FileData> DirectoryStatCache, IntrusiveRefCntPtr<FileSystem> FS) {
        FileManager FileMgr = $FileMgr;
        if (FileMgr == null) {
            FileMgr = new FileManager(FileMgrOpts, FS);
            FileSystemStatCache sharedStatCache = PreprocessorSupport.KEEP_STAT_MISSES ? new SharedStatCache(FileStatCache, DirectoryStatCache) : new SharedNoStatMissingCache(FileStatCache, DirectoryStatCache);
            FileMgr.addStatCache(llvm.make_unique((Object)sharedStatCache));
        } else {
            $FileMgr = null;
        }
        return FileMgr;
    }

    static void $releaseFileManager(FileManager FileMgr) {
        assert (FileMgr != null);
        FileMgr.$destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static PTHManager $getPTHManager(std.string TokenCacheFilePath, DiagnosticsEngine Diags) {
        if (TokenCacheFilePath.empty()) {
            if (PreprocessorSupport.USE_PTH_DRIVER) {
                if (!PreprocessorSupport.SHARED_PTH_MANAGER) {
                    return PTHManagerDriver.Create((PTHManagerDriver.PTHProducer)$CachedTokensProducer, null, (DiagnosticsEngine)Diags);
                }
            } else {
                return null;
            }
        }
        LinkedList<std_pair.pair<std.string, std_pair.pair<PTHManager, MemoryBuffer>>> linkedList = $ManagedPTH;
        synchronized (linkedList) {
            std_pair.pair PTHMgrPair = null;
            for (std_pair.pair pair2 : $ManagedPTH) {
                if (!TokenCacheFilePath.$eq(pair2.first)) continue;
                PTHMgrPair = (std_pair.pair)pair2.second;
                PTHManager mgr = (PTHManager)((std_pair.pair)pair2.second).first;
                if (mgr == null) continue;
                ((std_pair.pair)pair2.second).first = null;
                return mgr;
            }
            Object var5_6 = null;
            if (PTHMgrPair == null) {
                void var5_8;
                ErrorOr FileOrErr;
                if (!TokenCacheFilePath.empty() && (FileOrErr = PTHManager.CreateMemoryBuffer((std.string)TokenCacheFilePath)).$bool()) {
                    MemoryBuffer memoryBuffer = (MemoryBuffer)((std_ptr.unique_ptr)FileOrErr.get()).release();
                }
                PTHMgrPair = std.make_pair((Object)null, (Object)var5_8);
                $ManagedPTH.addFirst((std_pair.pair<std.string, std_pair.pair<PTHManager, MemoryBuffer>>)std.make_pair((Object)TokenCacheFilePath, (Object)PTHMgrPair));
            }
            assert (PTHMgrPair.first == null) : "should not have PTHManager at this phase; see while check above";
            assert (PTHMgrPair.second != null || TokenCacheFilePath.empty() && PreprocessorSupport.USE_PTH_DRIVER);
            if (PTHMgrPair.second == null && !TokenCacheFilePath.empty()) {
                BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)Diags.Report(739), (StringRef)new StringRef(TokenCacheFilePath));
            }
            MemoryBuffer memoryBuffer = (MemoryBuffer)PTHMgrPair.second;
            PTHManager PTHMgr = null;
            if (PreprocessorSupport.USE_PTH_DRIVER) {
                PTHMgr = PTHManagerDriver.Create((PTHManagerDriver.PTHProducer)$CachedTokensProducer, (MemoryBuffer)memoryBuffer, (DiagnosticsEngine)Diags);
            } else if (memoryBuffer != null) {
                PTHMgr = PTHManager.Create((MemoryBuffer)memoryBuffer, (DiagnosticsEngine)Diags);
            }
            if (PTHMgr != null) {
                MemoryBuffer sharedMemBuffer = PTHMgr.$markShared(PreprocessorSupport.SHARED_PTH_MANAGER);
                assert (sharedMemBuffer == memoryBuffer);
            }
            return PTHMgr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void $releasePTHManager(std.string TokenCache, PTHManager PTHMgr) {
        if (PTHMgr != null && PreprocessorSupport.SHARED_PTH_MANAGER) {
            LinkedList<std_pair.pair<std.string, std_pair.pair<PTHManager, MemoryBuffer>>> linkedList = $ManagedPTH;
            synchronized (linkedList) {
                if (NativeTrace.isDebugMode()) {
                    for (std_pair.pair pair2 : $ManagedPTH) {
                        assert (((std_pair.pair)pair2.second).first != PTHMgr) : "can not release twice ";
                    }
                }
                for (std_pair.pair pair3 : $ManagedPTH) {
                    if (!TokenCache.$eq(pair3.first)) continue;
                    assert (((std_pair.pair)pair3.second).second != null || TokenCache.empty() && PreprocessorSupport.USE_PTH_DRIVER);
                    if (((std_pair.pair)pair3.second).first != null) continue;
                    ((std_pair.pair)pair3.second).first = PTHMgr;
                    return;
                }
                assert (PreprocessorSupport.USE_PTH_DRIVER) : "empty pair must be found as added by $getPTHManager(TokenCache)";
                std_pair.pair PTHMgrPair = std.make_pair((Object)PTHMgr, (Object)PTHMgr.$getTokenCache());
                $ManagedPTH.addFirst((std_pair.pair<std.string, std_pair.pair<PTHManager, MemoryBuffer>>)std.make_pair((Object)TokenCache, (Object)PTHMgrPair));
            }
        }
    }
}

