/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger.breakpoints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ant.debugger.AntDebugger;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class AntBreakpoint
extends Breakpoint {
    private boolean enabled = true;
    private Line line;

    AntBreakpoint(Line line) {
        this.line = line;
    }

    public Line getLine() {
        return this.line;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        this.firePropertyChange("enabled", Boolean.TRUE, Boolean.FALSE);
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        this.firePropertyChange("enabled", Boolean.FALSE, Boolean.TRUE);
    }

    public Breakpoint.GroupProperties getGroupProperties() {
        return new AntGroupProperties();
    }

    private final class AntGroupProperties
    extends Breakpoint.GroupProperties {
        private AntEngineListener engineListener;

        private AntGroupProperties() {
        }

        public String getLanguage() {
            return "ANT";
        }

        public String getType() {
            return NbBundle.getMessage(AntBreakpoint.class, (String)"LineBrkp_Type");
        }

        private FileObject getFile() {
            return (FileObject)AntBreakpoint.this.line.getLookup().lookup(FileObject.class);
        }

        public FileObject[] getFiles() {
            FileObject fo = this.getFile();
            if (fo != null) {
                return new FileObject[]{fo};
            }
            return null;
        }

        public Project[] getProjects() {
            FileObject f = this.getFile();
            while (!(f == null || (f = f.getParent()) != null && ProjectManager.getDefault().isProject(f))) {
            }
            if (f != null) {
                try {
                    return new Project[]{ProjectManager.getDefault().findProject(f)};
                }
                catch (IOException iOException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return null;
        }

        public DebuggerEngine[] getEngines() {
            DebuggerEngine[] engines;
            if (this.engineListener == null) {
                this.engineListener = new AntEngineListener();
                DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)WeakListeners.create(DebuggerManagerListener.class, (EventListener)((Object)this.engineListener), (Object)DebuggerManager.getDebuggerManager()));
            }
            if ((engines = DebuggerManager.getDebuggerManager().getDebuggerEngines()).length == 0) {
                return null;
            }
            if (engines.length == 1) {
                if (this.isAntEngine(engines[0])) {
                    return engines;
                }
                return null;
            }
            ArrayList<DebuggerEngine> antEngines = null;
            for (DebuggerEngine e : engines) {
                if (!this.isAntEngine(e)) continue;
                if (antEngines == null) {
                    antEngines = new ArrayList<DebuggerEngine>();
                }
                antEngines.add(e);
            }
            if (antEngines == null) {
                return null;
            }
            return antEngines.toArray(new DebuggerEngine[0]);
        }

        private boolean isAntEngine(DebuggerEngine e) {
            return e.lookupFirst(null, AntDebugger.class) != null;
        }

        public boolean isHidden() {
            return false;
        }

        private final class AntEngineListener
        extends DebuggerManagerAdapter {
            private AntEngineListener() {
            }

            public void engineAdded(DebuggerEngine engine) {
                if (AntGroupProperties.this.isAntEngine(engine)) {
                    AntBreakpoint.this.firePropertyChange("groupProperties", null, (Object)AntGroupProperties.this);
                }
            }

            public void engineRemoved(DebuggerEngine engine) {
                if (AntGroupProperties.this.isAntEngine(engine)) {
                    AntBreakpoint.this.firePropertyChange("groupProperties", null, (Object)AntGroupProperties.this);
                }
            }
        }
    }
}

