/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.io.FastStringWriter;
import com.sun.faces.renderkit.RenderKitUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectOne;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

public class DebugUtil {
    private static boolean keepWaiting = true;
    private static int curDepth = 0;

    public DebugUtil() {
        this.init();
    }

    protected void init() {
    }

    public static void setKeepWaiting(boolean keepWaiting) {
        DebugUtil.keepWaiting = keepWaiting;
    }

    public static void waitForDebugger() {
        while (keepWaiting) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                System.out.println("DebugUtil.waitForDebugger(): Exception: " + e.getMessage());
            }
        }
    }

    private static void indentPrintln(Writer out, String str) {
        int i = 0;
        try {
            for (i = 0; i < curDepth; ++i) {
                out.write("  ");
            }
            out.write(str + "\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String printTree(UIComponent root) {
        FastStringWriter writer = new FastStringWriter(1024);
        DebugUtil.printTree(root, (Writer)writer);
        return ((Object)writer).toString();
    }

    public static void printTree(UIComponent root, PrintStream out) {
        PrintWriter writer = new PrintWriter(out);
        DebugUtil.printTree(root, (Writer)writer);
        writer.flush();
    }

    public static void printTree(UIComponent root, Logger logger, Level level) {
        StringWriter sw = new StringWriter();
        DebugUtil.printTree(root, (Writer)sw);
        logger.log(level, sw.toString());
    }

    public static void printTree(UIComponent root, Writer out) {
        Iterator<Object> it;
        if (null == root) {
            return;
        }
        boolean i = false;
        Object value = null;
        DebugUtil.indentPrintln(out, "id:" + root.getId());
        DebugUtil.indentPrintln(out, "type:" + root.toString());
        Iterator<SelectItem> items = null;
        SelectItem curItem = null;
        boolean j = false;
        if (root instanceof UISelectOne) {
            items = RenderKitUtils.getSelectItems(FacesContext.getCurrentInstance(), root);
            DebugUtil.indentPrintln(out, " {");
            while (items.hasNext()) {
                curItem = items.next();
                DebugUtil.indentPrintln(out, "\t value=" + curItem.getValue() + " label=" + curItem.getLabel() + " description=" + curItem.getDescription());
            }
            DebugUtil.indentPrintln(out, " }");
        } else {
            if (root instanceof ValueHolder) {
                value = ((ValueHolder)root).getValue();
            }
            DebugUtil.indentPrintln(out, "value= " + value);
            it = root.getAttributes().keySet().iterator();
            if (it != null) {
                while (it.hasNext()) {
                    String attrValue = null;
                    String attrName = (String)it.next();
                    Object attrObj = root.getAttributes().get(attrName);
                    if (null != attrObj) {
                        attrValue = attrObj.toString();
                        int at = 0;
                        boolean doTruncate = false;
                        at = attrValue.indexOf("$");
                        if (-1 == at) {
                            at = attrValue.indexOf("@");
                            if (-1 != at) {
                                doTruncate = true;
                            }
                        } else {
                            doTruncate = true;
                        }
                        if (doTruncate) {
                            attrValue = attrValue.substring(0, at);
                        }
                    } else {
                        attrValue = (String)attrObj;
                    }
                    DebugUtil.indentPrintln(out, "attr=" + attrName + " : " + attrValue);
                }
            }
        }
        ++curDepth;
        it = root.getChildren().iterator();
        Iterator facets = root.getFacets().values().iterator();
        while (facets.hasNext()) {
            DebugUtil.printTree((UIComponent)facets.next(), out);
        }
        while (it.hasNext()) {
            DebugUtil.printTree((UIComponent)it.next(), out);
        }
        --curDepth;
    }

    public static void simplePrintTree(UIComponent root, String duplicateId, Writer out) {
        if (null == root) {
            return;
        }
        if (duplicateId.equals(root.getId())) {
            DebugUtil.indentPrintln(out, "+id: " + root.getId() + "  <===============");
        } else {
            DebugUtil.indentPrintln(out, "+id: " + root.getId());
        }
        DebugUtil.indentPrintln(out, " type: " + root.toString());
        ++curDepth;
        for (UIComponent uiComponent : root.getFacets().values()) {
            DebugUtil.simplePrintTree(uiComponent, duplicateId, out);
        }
        for (UIComponent uiComponent : root.getChildren()) {
            DebugUtil.simplePrintTree(uiComponent, duplicateId, out);
        }
        --curDepth;
    }

    public static void printTree(Object[] root, Writer out) {
        if (null == root) {
            DebugUtil.indentPrintln(out, "null");
            return;
        }
        int i = 0;
        Object value = null;
        boolean foundBottom = false;
        Object state = null;
        Object[] myState = root;
        while (!foundBottom) {
            state = myState[0];
            foundBottom = !state.getClass().isArray();
            if (foundBottom) continue;
            myState = (Object[])state;
        }
        DebugUtil.indentPrintln(out, "type:" + myState[8]);
        ++curDepth;
        root = (Object[])root[1];
        for (i = 0; i < root.length; ++i) {
            DebugUtil.printTree((Object[])root[i], out);
        }
        --curDepth;
    }
}

