/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.cnd.remote.utils.RemoteUtil;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;

public class WindowsSupport {
    static final String NFS_NETWORK_PROVIDER_NAME = "NFS Network";

    static Map<String, String> findMappings(ExecutionEnvironment execEnv, ExecutionEnvironment otherExecEnv, String providerName, boolean localToRemoteMap) {
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder("wmic", "/locale:ms_409", "netuse", "list", "full");
            File file = File.createTempFile("wmic_output", "" + System.currentTimeMillis());
            pb.redirectOutput(file);
            Process exec = ProcessUtils.ignoreProcessError((Process)pb.start());
            try {
                int waitFor = exec.waitFor();
                if (waitFor != 0) {
                    if (providerName == null) {
                        return WindowsSupport.findMappingsNetUse(execEnv, otherExecEnv, localToRemoteMap);
                    }
                    return Collections.emptyMap();
                }
            }
            catch (InterruptedException ex) {
                RemoteUtil.LOGGER.log(Level.FINE, null, ex);
                return Collections.emptyMap();
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("Unicode")));
            ArrayList<String> netOutput = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                netOutput.add(line);
            }
            reader.close();
            Map<String, String> mappings = WindowsSupport.parseWmicNetUseOutput(otherExecEnv, netOutput, providerName, localToRemoteMap);
            if (mappings.isEmpty()) {
                return WindowsSupport.findMappingsNetUse(execEnv, otherExecEnv, localToRemoteMap);
            }
            return mappings;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return WindowsSupport.findMappingsNetUse(execEnv, otherExecEnv, localToRemoteMap);
        }
    }

    static Map<String, String> parseWmicNetUseOutput(ExecutionEnvironment execEnv, List<String> output, String providerName, boolean localToRemoteMap) throws IOException {
        return WindowsSupport.parseWmicNetUseOutput(execEnv.getHost(), output, providerName, true, localToRemoteMap);
    }

    static Map<String, String> parseWmicNetUseOutput(String host, List<String> output, String providerName, boolean isUnixStyle, boolean localToRemoteMap) throws IOException {
        ArrayList<NetUseStructure> elements = new ArrayList<NetUseStructure>();
        NetUseStructure currentElement = null;
        for (String line : output) {
            String[] values = line.split("=");
            if (values == null || values.length != 2) continue;
            String name = values[0];
            String value = values[1];
            switch (name) {
                case "AccessMask": {
                    if (currentElement != null) {
                        elements.add(currentElement);
                    }
                    currentElement = new NetUseStructure();
                    break;
                }
                case "LocalName": {
                    if (currentElement == null) break;
                    currentElement.localDiskName = value;
                    break;
                }
                case "RemotePath": {
                    if (currentElement == null) break;
                    currentElement.setRemotePath(value);
                    break;
                }
                case "ConnectionState": {
                    if (currentElement == null) break;
                    currentElement.isConnected = !"Disconnected".equals(value);
                    break;
                }
                case "ProviderName": {
                    if (currentElement == null) break;
                    currentElement.isNFS = NFS_NETWORK_PROVIDER_NAME.equals(value);
                    currentElement.providerName = value;
                }
            }
        }
        if (currentElement != null) {
            elements.add(currentElement);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (NetUseStructure element : elements) {
            if (!host.equals(element.host) || !element.isConnected && !element.isNFS || providerName != null && !providerName.equals(element.providerName)) continue;
            if (localToRemoteMap) {
                result.put(element.localDiskName, isUnixStyle ? element.remoteFolder.replace('\\', '/') : element.remoteFolder);
                continue;
            }
            result.put(isUnixStyle ? element.remoteFolder.replace('\\', '/') : element.remoteFolder, element.localDiskName);
        }
        return result;
    }

    private static Map<String, String> findMappingsNetUse(ExecutionEnvironment execEnv, ExecutionEnvironment otherExecEnv, boolean localToRemoteMap) {
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder("net", "use");
            File file = File.createTempFile("netuse_output", "" + System.currentTimeMillis());
            pb.redirectOutput(file);
            Process exec = ProcessUtils.ignoreProcessError((Process)pb.start());
            try {
                int waitFor = exec.waitFor();
                if (waitFor != 0) {
                    return Collections.emptyMap();
                }
            }
            catch (InterruptedException ex) {
                RemoteUtil.LOGGER.log(Level.FINE, null, ex);
                return Collections.emptyMap();
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("Unicode")));
            ArrayList<String> netOutput = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                netOutput.add(line);
            }
            reader.close();
            Map<String, String> mappings = WindowsSupport.parseNetUseOutput(otherExecEnv.getHost(), netOutput, localToRemoteMap);
            return mappings;
        }
        catch (IOException iOException) {
            return Collections.emptyMap();
        }
    }

    static Map<String, String> parseNetUseOutput(String hostName, List<String> output, boolean localToRemoteMap) throws IOException {
        String line;
        String lastNonEmptyLine = null;
        Iterator<String> iterator = output.iterator();
        while (iterator.hasNext() && (line = iterator.next()) != null && !line.contains("----------------")) {
            if (line.length() <= 0) continue;
            lastNonEmptyLine = line;
        }
        if (lastNonEmptyLine == null) {
            return Collections.emptyMap();
        }
        String[] words = lastNonEmptyLine.split("[ \t]+");
        if (words.length < 4) {
            return Collections.emptyMap();
        }
        int nLocal = lastNonEmptyLine.indexOf(words[1]);
        int nRemote = lastNonEmptyLine.indexOf(words[2]);
        int nNetwork = lastNonEmptyLine.indexOf(words[3]);
        ArrayList<NetUseStructure> elements = new ArrayList<NetUseStructure>();
        NetUseStructure currentElement = null;
        while (iterator.hasNext()) {
            line = iterator.next();
            if (line.indexOf(58) == -1) continue;
            if (currentElement != null) {
                elements.add(currentElement);
            }
            currentElement = new NetUseStructure();
            currentElement.localDiskName = line.substring(nLocal, nRemote - 1).trim();
            String remote = line.substring(nRemote).trim();
            if (remote.length() > nNetwork - 1 - nRemote && nNetwork - 1 - nRemote > 0 && remote.charAt(nNetwork - 2 - nRemote) == ' ') {
                remote = remote.substring(0, nNetwork - 1 - nRemote).trim();
            }
            currentElement.setRemotePath(remote);
            currentElement.isConnected = true;
        }
        if (currentElement != null) {
            elements.add(currentElement);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (NetUseStructure element : elements) {
            if (!hostName.equals(element.host) || !element.isConnected && !element.isNFS) continue;
            if (localToRemoteMap) {
                result.put(element.localDiskName, element.remoteFolder.replace('\\', '/'));
                continue;
            }
            result.put(element.remoteFolder.replace('\\', '/'), element.localDiskName);
        }
        return result;
    }

    static class NetUseStructure {
        String localDiskName;
        String host;
        String remoteFolder;
        boolean isConnected;
        boolean isNFS = false;
        String providerName;

        NetUseStructure() {
        }

        void setRemotePath(String remote) {
            if (remote.length() > 2) {
                String remotePath = remote.substring(2);
                int indexOf = remotePath.indexOf("\\");
                if (indexOf <= 0) {
                    this.host = null;
                    this.remoteFolder = null;
                    this.isConnected = false;
                    return;
                }
                this.host = remotePath.substring(0, indexOf);
                this.remoteFolder = remotePath.substring(indexOf);
            }
        }

        private String getRemoteFolder(ExecutionEnvironment execEnv) {
            return execEnv == null ? this.remoteFolder : CndPathUtilities.naturalizeSlashes((FileSystem)FileSystemProvider.getFileSystem((ExecutionEnvironment)execEnv), (String)this.remoteFolder);
        }
    }
}

