/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.tooling.networkmonitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.netbeans.modules.web.webkit.tooling.networkmonitor.Bundle;
import org.netbeans.modules.web.webkit.tooling.networkmonitor.Model;
import org.netbeans.modules.web.webkit.tooling.networkmonitor.ModelItem;
import org.openide.awt.Mnemonics;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.IOContainer;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.RetainLocation;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="NetworkMonitorTopComponent", persistenceType=2)
@RetainLocation(value="output")
public final class NetworkMonitorTopComponent
extends TopComponent
implements TableModelListener,
ChangeListener {
    private Model model;
    private final InputOutput io;
    private final MyProvider ioProvider;
    private final UIUpdater updater;
    private boolean debuggingSession;
    private JPanel jCallStackPanel;
    private JButton jClear;
    private JTextPane jFrames;
    private JPanel jFramesPanel;
    private JTextPane jHeaders;
    private JPanel jHeadersPanel;
    private JPanel jIOContainerPlaceholder;
    private JLabel jNoConnection;
    private JLabel jNoData;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JCheckBox jRawResponseFrames;
    private JCheckBox jRawResponseRequest;
    private JCheckBox jRawResponseResponse;
    private JEditorPane jRequest;
    private JPanel jRequestPanel;
    private JEditorPane jResponse;
    private JPanel jResponsePanel;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JSplitPane jSplitPane;
    private JTabbedPane jTabbedPane1;
    private JTable requestTable;
    private JScrollPane requestTableScrollPane;
    private ModelItem lastSelectedItem = null;

    NetworkMonitorTopComponent(Model m, boolean debuggingSession) {
        assert (SwingUtilities.isEventDispatchThread());
        this.debuggingSession = debuggingSession;
        this.initComponents();
        this.jResponse.setEditorKit(CloneableEditorSupport.getEditorKit((String)"text/plain"));
        this.setName(Bundle.CTL_NetworkMonitorTopComponent());
        this.setToolTipText(Bundle.HINT_NetworkMonitorTopComponent());
        this.updater = new UIUpdater(this);
        this.setModel(m, debuggingSession);
        this.initRequestTable();
        this.jSplitPane.setDividerLocation(NbPreferences.forModule(NetworkMonitorTopComponent.class).getInt("separator", 200));
        this.selectedItemChanged();
        this.updateVisibility();
        this.ioProvider = new MyProvider(this.jIOContainerPlaceholder);
        IOContainer container = IOContainer.create((IOContainer.Provider)this.ioProvider);
        this.io = IOProvider.getDefault().getIO("callstack", new Action[0], container);
    }

    private void initRequestTable() {
        this.requestTable.getSelectionModel().setSelectionMode(0);
        this.requestTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                NetworkMonitorTopComponent.this.selectedItemChanged();
            }
        });
    }

    void setModel(Model model, boolean debuggingSession) {
        this.model = model;
        this.debuggingSession = debuggingSession;
        TableModel tableModel = this.requestTable.getModel();
        if (tableModel != null) {
            tableModel.removeTableModelListener(this);
        }
        this.requestTable.setModel(model);
        this.requestTable.setRowSorter(new TriStateRowSorter(model));
        model.addTableModelListener(this);
        this.selectedItemChanged();
        this.updateVisibility();
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jClear = new JButton();
        this.requestTableScrollPane = new JScrollPane();
        this.requestTable = new JTable();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jHeadersPanel = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.jHeaders = new JTextPane();
        this.jRequestPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jRequest = new JEditorPane();
        this.jRawResponseRequest = new JCheckBox();
        this.jResponsePanel = new JPanel();
        this.jRawResponseResponse = new JCheckBox();
        this.jScrollPane3 = new JScrollPane();
        this.jResponse = new JEditorPane();
        this.jFramesPanel = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.jFrames = new JTextPane();
        this.jRawResponseFrames = new JCheckBox();
        this.jCallStackPanel = new JPanel();
        this.jIOContainerPlaceholder = new JPanel();
        this.jNoData = new JLabel();
        this.jNoConnection = new JLabel();
        this.jClear.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/web/webkit/tooling/networkmonitor/delete.gif")));
        this.jClear.setToolTipText(NbBundle.getMessage(NetworkMonitorTopComponent.class, (String)"NetworkMonitorTopComponent.jClear.tooltip"));
        this.jClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetworkMonitorTopComponent.this.jClearActionPerformed(evt);
            }
        });
        this.requestTableScrollPane.setViewportView(this.requestTable);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jClear).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.requestTableScrollPane));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jClear).addGap(0, 0, 0).addComponent(this.requestTableScrollPane)));
        this.jSplitPane.setLeftComponent(this.jPanel3);
        this.jHeadersPanel.setName(NbBundle.getMessage(NetworkMonitorTopComponent.class, (String)"NetworkMonitorTopComponent.jHeadersPanel.TabConstraints.tabTitle"));
        this.jHeaders.setEditable(false);
        this.jScrollPane5.setViewportView(this.jHeaders);
        GroupLayout jHeadersPanelLayout = new GroupLayout(this.jHeadersPanel);
        this.jHeadersPanel.setLayout(jHeadersPanelLayout);
        jHeadersPanelLayout.setHorizontalGroup(jHeadersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane5));
        jHeadersPanelLayout.setVerticalGroup(jHeadersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane5));
        this.jTabbedPane1.addTab(NbBundle.getMessage(NetworkMonitorTopComponent.class, (String)"NetworkMonitorTopComponent.jHeadersPanel.TabConstraints.tabTitle"), this.jHeadersPanel);
        this.jRequestPanel.setName(NbBundle.getMessage(NetworkMonitorTopComponent.class, (String)"NetworkMonitorTopComponent.Request Data.TabConstraints.tabTitle"));
        this.jRequest.setEditable(false);
        this.jScrollPane2.setViewportView(this.jRequest);
        Mnemonics.setLocalizedText((AbstractButton)this.jRawResponseRequest, (String)NbBundle.getMessage(NetworkMonitorTopComponent.class, (String)"NetworkMonitorTopComponent.jRawResponseRequest.text"));
        this.jRawResponseRequest.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                NetworkMonitorTopComponent.this.jRawResponseRequestItemStateChanged(evt);
            }
        });
        GroupLayout jRequestPanelLayout = new GroupLayout(this.jRequestPanel);
        this.jRequestPanel.setLayout(jRequestPanelLayout);
        jRequestPanelLayout.setHorizontalGroup(jRequestPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2).addGroup(jRequestPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jRawResponseRequest)));
        jRequestPanelLayout.setVerticalGroup(jRequestPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jRequestPanelLayout.createSequentialGroup().addComponent(this.jScrollPane2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRawResponseRequest)));
        this.jTabbedPane1.addTab(NbBundle.getMessage(NetworkMonitorTopComponent.class, (String)"NetworkMonitorTopComponent.jRequestPanel.TabConstraints.tabTitle"), this.jRequestPanel);
        this.jResponsePanel.setName(NbBundle.getMessage(NetworkMonitorTopComponent.class, (String)"NetworkMonitorTopComponent.jResponsePanel.TabConstraints.tabTitle"));
        Mnemonics.setLocalizedText((AbstractButton)this.jRawResponseResponse, (String)NbBundle.getMessage(NetworkMonitorTopComponent.class, (String)"NetworkMonitorTopComponent.jRawResponseResponse.text"));
        this.jRawResponseResponse.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                NetworkMonitorTopComponent.this.jRawResponseResponseItemStateChanged(evt);
            }
        });
        this.jResponse.setEditable(false);
        this.jScrollPane3.setViewportView(this.jResponse);
        GroupLayout jResponsePanelLayout = new GroupLayout(this.jResponsePanel);
        this.jResponsePanel.setLayout(jResponsePanelLayout);
        jResponsePanelLayout.setHorizontalGroup(jResponsePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jResponsePanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jRawResponseResponse)).addComponent(this.jScrollPane3));
        jResponsePanelLayout.setVerticalGroup(jResponsePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jResponsePanelLayout.createSequentialGroup().addComponent(this.jScrollPane3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRawResponseResponse)));
        this.jTabbedPane1.addTab(NbBundle.getMessage(NetworkMonitorTopComponent.class, (String)"NetworkMonitorTopComponent.jResponsePanel.TabConstraints.tabTitle"), this.jResponsePanel);
        this.jFramesPanel.setName(NbBundle.getMessage(NetworkMonitorTopComponent.class, (String)"NetworkMonitorTopComponent.jFramesPanel.TabConstraints.tabTitle"));
        this.jScrollPane4.setViewportView(this.jFrames);
        Mnemonics.setLocalizedText((AbstractButton)this.jRawResponseFrames, (String)NbBundle.getMessage(NetworkMonitorTopComponent.class, (String)"NetworkMonitorTopComponent.jRawResponseFrames.text"));
        this.jRawResponseFrames.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                NetworkMonitorTopComponent.this.jRawResponseFramesItemStateChanged(evt);
            }
        });
        GroupLayout jFramesPanelLayout = new GroupLayout(this.jFramesPanel);
        this.jFramesPanel.setLayout(jFramesPanelLayout);
        jFramesPanelLayout.setHorizontalGroup(jFramesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jFramesPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jRawResponseFrames)).addComponent(this.jScrollPane4));
        jFramesPanelLayout.setVerticalGroup(jFramesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jFramesPanelLayout.createSequentialGroup().addComponent(this.jScrollPane4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRawResponseFrames)));
        this.jTabbedPane1.addTab(NbBundle.getMessage(NetworkMonitorTopComponent.class, (String)"NetworkMonitorTopComponent.jFramesPanel.TabConstraints.tabTitle"), this.jFramesPanel);
        this.jCallStackPanel.setName(NbBundle.getMessage(NetworkMonitorTopComponent.class, (String)"NetworkMonitorTopComponent.jCallStackPanel.TabConstraints.tabTitle"));
        GroupLayout jIOContainerPlaceholderLayout = new GroupLayout(this.jIOContainerPlaceholder);
        this.jIOContainerPlaceholder.setLayout(jIOContainerPlaceholderLayout);
        jIOContainerPlaceholderLayout.setHorizontalGroup(jIOContainerPlaceholderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jIOContainerPlaceholderLayout.setVerticalGroup(jIOContainerPlaceholderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout jCallStackPanelLayout = new GroupLayout(this.jCallStackPanel);
        this.jCallStackPanel.setLayout(jCallStackPanelLayout);
        jCallStackPanelLayout.setHorizontalGroup(jCallStackPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jIOContainerPlaceholder, -1, -1, Short.MAX_VALUE));
        jCallStackPanelLayout.setVerticalGroup(jCallStackPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jIOContainerPlaceholder, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.jTabbedPane1.addTab(NbBundle.getMessage(NetworkMonitorTopComponent.class, (String)"NetworkMonitorTopComponent.jCallStackPanel.TabConstraints.tabTitle"), this.jCallStackPanel);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)));
        this.jSplitPane.setRightComponent(this.jPanel1);
        Mnemonics.setLocalizedText((JLabel)this.jNoData, (String)NbBundle.getMessage(NetworkMonitorTopComponent.class, (String)"NetworkMonitorTopComponent.jNoData.text"));
        this.jNoData.setVerticalAlignment(1);
        this.jNoData.setBorder(BorderFactory.createEmptyBorder(12, 12, 1, 1));
        Mnemonics.setLocalizedText((JLabel)this.jNoConnection, (String)NbBundle.getMessage(NetworkMonitorTopComponent.class, (String)"NetworkMonitorTopComponent.jNoConnection.text"));
        this.jNoConnection.setVerticalAlignment(1);
        this.jNoConnection.setBorder(BorderFactory.createEmptyBorder(12, 12, 1, 1));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane).addComponent(this.jNoData).addComponent(this.jNoConnection));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jSplitPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNoData, -2, 123, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNoConnection, -2, -1, -2)));
    }

    private void jRawResponseResponseItemStateChanged(ItemEvent evt) {
        ModelItem mi = this.lastSelectedItem;
        if (mi != null) {
            this.refreshDetailsView(mi);
        }
    }

    private void jRawResponseRequestItemStateChanged(ItemEvent evt) {
        ModelItem mi = this.lastSelectedItem;
        if (mi != null) {
            this.refreshDetailsView(mi);
        }
    }

    private void jRawResponseFramesItemStateChanged(ItemEvent evt) {
        ModelItem mi = this.lastSelectedItem;
        if (mi != null) {
            this.refreshDetailsView(mi);
        }
    }

    private void jClearActionPerformed(ActionEvent evt) {
        this.resetModel();
    }

    public void componentClosed() {
        NetworkMonitorTopComponent.setReopenNetworkComponent(false);
        this.model.passivate();
        this.model.removeTableModelListener(this);
        this.requestTable.setModel(new DefaultTableModel());
        this.ioProvider.close();
        NbPreferences.forModule(NetworkMonitorTopComponent.class).putInt("separator", this.jSplitPane.getDividerLocation());
    }

    static boolean canReopenNetworkComponent() {
        return NbPreferences.forModule(NetworkMonitorTopComponent.class).getBoolean("reopen", true);
    }

    static void setReopenNetworkComponent(boolean b) {
        NbPreferences.forModule(NetworkMonitorTopComponent.class).putBoolean("reopen", b);
    }

    private void selectedItemChanged() {
        ModelItem mi;
        assert (SwingUtilities.isEventDispatchThread());
        int index = this.requestTable.getSelectedRow();
        if (index != -1) {
            index = this.requestTable.convertRowIndexToModel(index);
        }
        if (this.lastSelectedItem == (mi = this.model.getItem(index))) {
            return;
        }
        if (this.lastSelectedItem != null) {
            this.lastSelectedItem.setChangeListener(null);
        }
        this.lastSelectedItem = mi;
        if (this.lastSelectedItem != null) {
            this.lastSelectedItem.setChangeListener(this);
        }
        this.refreshDetailsView(this.lastSelectedItem);
    }

    private void refreshDetailsView(ModelItem mi) {
        this.updater.showItem(mi);
    }

    private void _refreshDetailsView(ModelItem mi) {
        assert (SwingUtilities.isEventDispatchThread());
        if (mi != null) {
            mi.updateHeadersPane(this.jHeaders);
            mi.updateResponsePane(this.jResponse, this.jRawResponseResponse.isSelected());
            mi.updateFramesPane(this.jFrames, this.jRawResponseFrames.isSelected());
            mi.updatePostDataPane(this.jRequest, this.jRawResponseRequest.isSelected());
            mi.updateCallStack(this.io);
        }
        this.updateTabVisibility(mi);
    }

    private void updateVisibility() {
        boolean empty = this.model.getRowCount() == 0;
        this.jSplitPane.setVisible(!empty);
        this.jNoData.setVisible(empty && this.debuggingSession);
        this.jNoConnection.setVisible(empty && !this.debuggingSession);
        if (!empty && this.requestTable.getSelectedRow() == -1) {
            this.refreshDetailsView(null);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateVisibility();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refreshDetailsView(this.lastSelectedItem);
    }

    void resetModel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NetworkMonitorTopComponent.this.model.reset();
            }
        });
    }

    private void updateTabVisibility(ModelItem mi) {
        int index = 0;
        boolean showHeaders = mi != null;
        index = this.showHideTab(this.jHeadersPanel, showHeaders, index);
        boolean postDataVisible = mi != null && mi.hasPostData();
        index = this.showHideTab(this.jRequestPanel, postDataVisible, index);
        boolean hasResponseData = mi != null && mi.hasResponseData();
        index = this.showHideTab(this.jResponsePanel, hasResponseData, index);
        boolean hasFrames = mi != null && mi.hasFrames();
        index = this.showHideTab(this.jFramesPanel, hasFrames, index);
        boolean hasCallStack = mi != null && mi.hasCallStack();
        this.showHideTab(this.jCallStackPanel, hasCallStack, index);
    }

    private int showHideTab(JPanel jPanel, boolean show, int index) {
        Component comp;
        Component component = comp = index < this.jTabbedPane1.getTabCount() ? this.jTabbedPane1.getComponentAt(index) : null;
        if (show) {
            if (jPanel != comp) {
                this.jTabbedPane1.add((Component)jPanel, index);
            }
            return index + 1;
        }
        if (jPanel == comp) {
            this.jTabbedPane1.remove(index);
        }
        return index;
    }

    public static class TriStateRowSorter
    extends TableRowSorter<TableModel> {
        public TriStateRowSorter(TableModel model) {
            super(model);
        }

        @Override
        public void toggleSortOrder(int column) {
            RowSorter.SortKey sortKey;
            List<RowSorter.SortKey> sortKeys = this.getSortKeys();
            if (!sortKeys.isEmpty() && (sortKey = sortKeys.get(0)).getColumn() == column && sortKey.getSortOrder() == SortOrder.DESCENDING) {
                this.setSortKeys(null);
                return;
            }
            super.toggleSortOrder(column);
        }
    }

    private static class MyProvider
    implements IOContainer.Provider {
        private JPanel parent;

        public MyProvider(JPanel parent) {
            this.parent = parent;
        }

        public void open() {
        }

        public void requestActive() {
        }

        public void requestVisible() {
        }

        public boolean isActivated() {
            return false;
        }

        public void add(JComponent comp, IOContainer.CallBacks cb) {
            assert (this.parent != null);
            this.parent.setLayout(new BorderLayout());
            this.parent.add((Component)comp, "Center");
        }

        public void remove(JComponent comp) {
            assert (this.parent != null);
            this.parent.remove(comp);
        }

        public void select(JComponent comp) {
        }

        public JComponent getSelected() {
            return null;
        }

        public void setTitle(JComponent comp, String name) {
        }

        public void setToolTipText(JComponent comp, String text) {
        }

        public void setIcon(JComponent comp, Icon icon) {
        }

        public void setToolbarActions(JComponent comp, Action[] toolbarActions) {
        }

        public boolean isCloseable(JComponent comp) {
            return false;
        }

        private void close() {
            this.parent = null;
        }
    }

    public static class JTextPaneNonWrapping
    extends JTextPane {
        @Override
        public boolean getScrollableTracksViewportWidth() {
            Container parent = this.getParent();
            return parent != null ? this.getUI().getPreferredSize((JComponent)this).width <= parent.getSize().width : true;
        }
    }

    private static class UIUpdater
    implements ActionListener {
        private final Timer t;
        private final NetworkMonitorTopComponent comp;
        private ModelItem modelItem;

        public UIUpdater(NetworkMonitorTopComponent comp) {
            this.comp = comp;
            this.t = new Timer(200, this);
            this.t.setRepeats(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.comp._refreshDetailsView(this.modelItem);
        }

        public synchronized void showItem(ModelItem mi) {
            this.t.stop();
            this.modelItem = mi;
            this.t.start();
        }
    }
}

