/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.newproject;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.ide.ergonomics.fod.FoDLayersProvider;
import org.netbeans.modules.ide.ergonomics.newproject.DescriptionStep;
import org.netbeans.modules.ide.ergonomics.newproject.EnableStep;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class FeatureOnDemandWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    public static final String CHOSEN_ELEMENTS_FOR_INSTALL = "chosen-elements-for-install";
    public static final String CHOSEN_ELEMENTS_FOR_ENABLE = "chosen-elements-for-enable";
    public static final String APPROVED_ELEMENTS = "approved-elements";
    public static final String CHOSEN_TEMPLATE = "chosen-template";
    public static final String DELEGATE_ITERATOR = "delegate-iterator";
    private WizardDescriptor.InstantiatingIterator delegateIterator;
    private Boolean doEnable = null;
    private FileObject template;
    private boolean autoEnable = true;
    private int index;
    private List<WizardDescriptor.Panel<WizardDescriptor>> panels = null;
    private String[] names;
    private WizardDescriptor wiz;

    public FeatureOnDemandWizardIterator(FileObject template) {
        this.template = template;
    }

    public static WizardDescriptor.InstantiatingIterator newProject(FileObject fo) {
        try {
            WizardDescriptor.InstantiatingIterator it = FeatureOnDemandWizardIterator.getRealNewMakeProjectWizardIterator(fo);
            if (it != null) {
                return it;
            }
        }
        catch (Exception it) {
            // empty catch block
        }
        Object obj = fo.getAttribute("templateWizardIterator");
        if (obj != null) {
            return null;
        }
        return new FeatureOnDemandWizardIterator(fo);
    }

    private static WizardDescriptor.InstantiatingIterator getRealNewMakeProjectWizardIterator(FileObject template) {
        WizardDescriptor.InstantiatingIterator res = null;
        if (FoDLayersProvider.getInstance().getDelegateFileSystem(template) != null) {
            return null;
        }
        FileObject fo = FileUtil.getConfigFile((String)template.getPath());
        if (fo != null) {
            Object o = fo.getAttribute("instantiatingIterator");
            if (o == null) {
                o = fo.getAttribute("templateWizardIterator");
            }
            assert (o != null && o instanceof WizardDescriptor.InstantiatingIterator) : o + " is not null and instanceof WizardDescriptor.InstantiatingIterator";
            WizardDescriptor.InstantiatingIterator iterator = (WizardDescriptor.InstantiatingIterator)o;
            if (!FeatureOnDemandWizardIterator.class.equals(o.getClass())) {
                return iterator;
            }
        }
        return res;
    }

    private List<WizardDescriptor.Panel<WizardDescriptor>> getPanels() {
        assert (EventQueue.isDispatchThread());
        if (this.panels == null) {
            this.panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
            this.panels.add(new DescriptionStep(this.autoEnable));
            this.names = new String[]{NbBundle.getMessage(FeatureOnDemandWizardIterator.class, (String)"DescriptionStep_Name")};
            String[] steps = new String[this.panels.size()];
            assert (steps.length == this.names.length) : "As same names as steps must be";
            int i = 0;
            for (WizardDescriptor.Panel<WizardDescriptor> p : this.panels) {
                Component c = p.getComponent();
                steps[i] = c.getName();
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                    jc.putClientProperty("WizardPanel_contentData", steps);
                }
                ++i;
            }
        }
        return this.panels;
    }

    private void createPanelsForEnable() {
        if (this.getPanels() == null) {
            this.panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
            this.getPanels().add(new DescriptionStep(this.autoEnable));
            this.getPanels().add((WizardDescriptor.Panel<WizardDescriptor>)new EnableStep());
            this.names = new String[]{NbBundle.getMessage(FeatureOnDemandWizardIterator.class, (String)"DescriptionStep_Name"), NbBundle.getMessage(FeatureOnDemandWizardIterator.class, (String)"EnableStep_Name")};
            String[] steps = new String[this.getPanels().size()];
            assert (steps.length == this.names.length) : "As same names as steps must be";
            int i = 0;
            for (WizardDescriptor.Panel<WizardDescriptor> p : this.getPanels()) {
                Component c = p.getComponent();
                steps[i] = c.getName();
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                    jc.putClientProperty("WizardPanel_contentData", steps);
                }
                ++i;
            }
        }
    }

    public Set instantiate() throws IOException {
        if (this.getDelegateIterator() != null) {
            return this.getDelegateIterator().instantiate();
        }
        return null;
    }

    public Set instantiate(ProgressHandle handle) throws IOException {
        WizardDescriptor.InstantiatingIterator it = this.getDelegateIterator();
        if (it != null) {
            if (it instanceof WizardDescriptor.ProgressInstantiatingIterator) {
                return ((WizardDescriptor.ProgressInstantiatingIterator)this.getDelegateIterator()).instantiate(handle);
            }
            return this.getDelegateIterator().instantiate();
        }
        return null;
    }

    public void initialize(WizardDescriptor wiz) {
        if (WizardDescriptor.CLOSED_OPTION.equals(wiz.getValue())) {
            this.autoEnable = false;
        }
        this.wiz = wiz;
        wiz.putProperty(CHOSEN_TEMPLATE, (Object)this.template);
        wiz.putProperty(DELEGATE_ITERATOR, null);
        this.index = 0;
    }

    public void uninitialize(WizardDescriptor wiz) {
        if (this.getDelegateIterator() != null) {
            this.getDelegateIterator().uninitialize(wiz);
        }
        this.wiz = null;
        this.panels = null;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        if (this.getDelegateIterator() != null && this.getDelegateIterator() != this) {
            return this.getDelegateIterator().current();
        }
        assert (this.getPanels() != null);
        return this.getPanels().get(this.index);
    }

    public String name() {
        if (this.getDelegateIterator() != null) {
            return this.getDelegateIterator().name();
        }
        this.getPanels();
        return this.names[this.index];
    }

    public boolean hasNext() {
        if (this.getDelegateIterator() != null) {
            return this.getDelegateIterator().hasNext();
        }
        return this.index < this.getPanels().size() - 1;
    }

    public boolean hasPrevious() {
        if (this.getDelegateIterator() != null) {
            return this.getDelegateIterator().hasPrevious();
        }
        return this.index > 0;
    }

    public void nextPanel() {
        if (this.getDelegateIterator() != null) {
            if (this.getDelegateIterator().hasNext()) {
                this.getDelegateIterator().nextPanel();
            }
            return;
        }
        if (!this.hasNext()) {
            return;
        }
        ++this.index;
    }

    public void previousPanel() {
        if (this.getDelegateIterator() != null) {
            if (this.getDelegateIterator().hasPrevious()) {
                this.getDelegateIterator().previousPanel();
            }
            return;
        }
        if (!this.hasPrevious()) {
            return;
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
        if (this.getDelegateIterator() != null) {
            this.getDelegateIterator().addChangeListener(l);
        }
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.getDelegateIterator() != null) {
            this.getDelegateIterator().removeChangeListener(l);
        }
    }

    private WizardDescriptor.InstantiatingIterator getDelegateIterator() {
        if (this.wiz != null && this.delegateIterator == null) {
            Object o = this.wiz.getProperty(DELEGATE_ITERATOR);
            assert (o == null || o instanceof WizardDescriptor.InstantiatingIterator) : o + " is instanceof WizardDescriptor.InstantiatingIterator or null";
            this.delegateIterator = (WizardDescriptor.InstantiatingIterator)o;
            if (this.delegateIterator == null && this.doEnable == null && (o = this.wiz.getProperty(CHOSEN_ELEMENTS_FOR_ENABLE)) != null && !((Collection)o).isEmpty()) {
                this.doEnable = Boolean.TRUE;
                this.panels = null;
                this.createPanelsForEnable();
            }
        }
        return this.delegateIterator;
    }
}

