/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.testbench;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.repository.impl.spi.LayerKey;
import org.netbeans.modules.cnd.repository.testbench.Stats;

public class FileStatistics {
    private Map<LayerKey, ChunkStatistics> map;

    public FileStatistics() {
        if (Stats.fileStatisticsLevel > 0) {
            this.map = new HashMap<LayerKey, ChunkStatistics>();
        }
    }

    private ChunkStatistics getStat(LayerKey key) {
        ChunkStatistics stat = this.map.get(key);
        if (stat == null) {
            stat = new ChunkStatistics();
            this.map.put(key, stat);
        }
        return stat;
    }

    public int getReadCount(LayerKey key) {
        return Stats.fileStatisticsLevel == 0 ? 0 : this.getStat((LayerKey)key).readCount;
    }

    public void incrementReadCount(LayerKey key) {
        if (Stats.fileStatisticsLevel > 0) {
            ++this.getStat((LayerKey)key).readCount;
        }
    }

    public int getWriteCount(LayerKey key) {
        return Stats.fileStatisticsLevel == 0 ? 0 : this.getStat((LayerKey)key).writeCount;
    }

    public void incrementWriteCount(LayerKey key, int oldSize, int newSize) {
        if (Stats.fileStatisticsLevel > 0) {
            ChunkStatistics stat = this.getStat(key);
            ++stat.writeCount;
            if (oldSize > 0 && newSize != oldSize) {
                ++stat.resized;
            }
        }
    }

    public void removeNotify(LayerKey key) {
        if (Stats.fileStatisticsLevel > 0) {
            this.map.remove(key);
        }
    }

    private static class ChunkStatistics {
        public int readCount;
        public int writeCount;
        public int resized;

        private ChunkStatistics() {
        }
    }
}

