/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.installer.utils.DateUtils;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;

public final class LogManager {
    public static final int DEFAULT_LOG_LEVEL = 4;
    public static final boolean DEFAULT_LOG_TO_CONSOLE = true;
    private static File logFile;
    private static PrintWriter logWriter;
    private static int logLevel;
    private static boolean logToConsole;
    private static int indent;
    private static boolean started;
    private static List<String> logCache;
    public static final String LOG_LEVEL_PROPERTY = "nbi.utils.log.level";
    public static final String LOG_TO_CONSOLE_PROPERTY = "nbi.utils.log.to.console";
    public static final String LOG_FILE_PROPERTY = "nbi.utils.log.file";
    public static final String INDENT = "    ";
    public static final String ERROR_CANNOT_WRITE_KEY = "LM.error.cannot.write";

    public static synchronized void start() {
        if (System.getProperty(LOG_LEVEL_PROPERTY) != null) {
            try {
                logLevel = Integer.parseInt(System.getProperty(LOG_LEVEL_PROPERTY));
            }
            catch (NumberFormatException e) {
                logLevel = 4;
            }
        } else {
            logLevel = 4;
        }
        LogManager.initializeConsoleLogging();
        try {
            if (logFile != null) {
                logFile.getParentFile().mkdirs();
                if (logFile.exists()) {
                    logFile.delete();
                }
                logFile.createNewFile();
                logWriter = new PrintWriter(new FileWriter(logFile));
                System.setProperty(LOG_FILE_PROPERTY, logFile.getAbsolutePath());
            }
            for (String string : logCache) {
                LogManager.write(string);
            }
            logCache.clear();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            logWriter = null;
        }
        started = true;
    }

    private static void initializeConsoleLogging() {
        logToConsole = System.getProperty(LOG_TO_CONSOLE_PROPERTY) != null ? new Boolean(System.getProperty(LOG_TO_CONSOLE_PROPERTY)) : true;
    }

    public static synchronized void stop() {
        started = false;
        LogManager.stopFileLog();
        LogManager.stopConsoleLog();
    }

    private static final void stopConsoleLog() {
        if (!logCache.isEmpty()) {
            LogManager.initializeConsoleLogging();
            if (logToConsole) {
                for (String string : logCache) {
                    try {
                        LogManager.write(string);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                logCache.clear();
            }
        }
    }

    private static synchronized void stopFileLog() {
        if (logWriter != null) {
            logWriter.close();
            logWriter = null;
        }
    }

    public static synchronized void indent() {
        ++indent;
    }

    public static synchronized void unindent() {
        --indent;
    }

    public static synchronized void log(int level, String message) {
        if (level <= logLevel) {
            BufferedReader reader = new BufferedReader(new StringReader(message));
            try {
                String line = reader.readLine();
                while (line != null) {
                    String string = "[" + DateUtils.getFormattedTimestamp() + "]: " + StringUtils.pad(INDENT, indent) + line;
                    if (started) {
                        LogManager.write(string);
                    } else {
                        logCache.add(string);
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                logWriter = null;
                ErrorManager.notifyWarning(ResourceUtils.getString(LogManager.class, ERROR_CANNOT_WRITE_KEY));
            }
        }
    }

    public static synchronized void log(int level, Throwable exception) {
        LogManager.log(level, StringUtils.asString(exception));
    }

    public static synchronized void log(int level, Object object) {
        LogManager.log(level, object.toString());
    }

    public static synchronized void log(String message) {
        LogManager.log(3, message);
    }

    public static synchronized void log(Throwable exception) {
        LogManager.log(3, exception);
    }

    public static synchronized void log(Object object) {
        LogManager.log(3, object);
    }

    public static synchronized void log(String message, Throwable exception) {
        LogManager.log(message);
        LogManager.log(exception);
    }

    public static synchronized void logEntry(String message) {
        StackTraceElement traceElement = Thread.currentThread().getStackTrace()[3];
        LogManager.log(4, "entering -- " + (traceElement.isNativeMethod() ? "[native] " : "") + traceElement.getClassName() + "." + traceElement.getMethodName() + "():" + traceElement.getLineNumber());
        LogManager.log(3, message);
        LogManager.indent();
    }

    public static synchronized void logExit(String message) {
        StackTraceElement traceElement = Thread.currentThread().getStackTrace()[3];
        LogManager.unindent();
        LogManager.log(message);
        LogManager.log(4, "exiting -- " + (traceElement.isNativeMethod() ? "[native] " : "") + traceElement.getClassName() + "." + traceElement.getMethodName() + "():" + traceElement.getLineNumber());
    }

    public static synchronized void logIndent(String message) {
        LogManager.log(message);
        LogManager.indent();
    }

    public static synchronized void logUnindent(String message) {
        LogManager.unindent();
        LogManager.log(message);
    }

    public static File getLogFile() {
        return logFile;
    }

    public static void setLogFile(File logFile) {
        LogManager.logFile = logFile;
    }

    private static void write(String string) throws IOException {
        if (logWriter != null) {
            logWriter.println(string);
            logWriter.flush();
        }
        if (logToConsole) {
            System.out.println(string);
        }
    }

    private LogManager() {
    }

    static {
        logLevel = 4;
        logToConsole = true;
        started = false;
        logCache = new LinkedList<String>();
    }
}

