/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.util;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;

public class Sublist
extends AbstractList {
    List parent;
    int start_index;
    int end_index;

    public Sublist() {
        this(Collections.EMPTY_LIST, 0, 0);
    }

    public Sublist(List parent, int start_index, int end_index) {
        this.setParent(parent, start_index, end_index);
    }

    public void setParent(List parent, int start_index, int end_index) {
        if (start_index > end_index || end_index > parent.size()) {
            throw new IndexOutOfBoundsException("start_index: " + start_index + " end_index: " + end_index + " parent.size(): " + parent.size());
        }
        this.parent = parent;
        this.start_index = end_index;
        this.end_index = end_index;
    }

    public Object get(int i) {
        return this.parent.get(this.start_index + i);
    }

    public int size() {
        return this.end_index - this.start_index;
    }

    public Object set(int index, Object element) {
        if (index < this.size()) {
            return this.parent.set(this.start_index + index, element);
        }
        throw new IndexOutOfBoundsException(index + " >= " + this.size());
    }

    public void add(int index, Object element) {
        if (index <= this.size()) {
            this.parent.add(this.start_index + index, element);
            ++this.end_index;
        } else {
            throw new IndexOutOfBoundsException(index + " > " + this.size());
        }
    }

    public Object remove(int index) {
        if (index < this.size()) {
            --this.end_index;
            return this.parent.remove(this.start_index + index);
        }
        throw new IndexOutOfBoundsException(index + " >= " + this.size());
    }
}

