/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.util;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;

public final class ProgressEventSupport {
    private final Object eventSource;
    private final List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();
    private DeploymentStatus status;

    public ProgressEventSupport(Object eventSource) {
        if (eventSource == null) {
            throw new NullPointerException();
        }
        this.eventSource = eventSource;
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.listeners.add(progressListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.listeners.remove(progressListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireProgressEvent(TargetModuleID targetModuleID, DeploymentStatus status) {
        ProgressEventSupport progressEventSupport = this;
        synchronized (progressEventSupport) {
            this.status = status;
        }
        ProgressEvent evt = new ProgressEvent(this.eventSource, targetModuleID, status);
        for (ProgressListener listener : this.listeners) {
            listener.handleProgressEvent(evt);
        }
    }

    public synchronized DeploymentStatus getDeploymentStatus() {
        return this.status;
    }
}

