/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.config;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.jboss4.config.JBossDatasource;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JB7DatasourceHandler
extends DefaultHandler {
    private final List<JBossDatasource> datasources = new ArrayList<JBossDatasource>();
    private StringBuilder content = new StringBuilder();
    private boolean isDatasources;
    private boolean isDatasource;
    private boolean isSecurity;
    private String jndiName;
    private String url;
    private String driverClass;
    private String username;
    private String password;

    public List<JBossDatasource> getDatasources() {
        return this.datasources;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.content.setLength(0);
        if ("datasources".equals(qName)) {
            this.isDatasources = true;
        } else if (this.isDatasources && "datasource".equals(qName)) {
            this.isDatasource = true;
            this.jndiName = attributes.getValue("jndi-name");
        } else if (this.isDatasource && "security".equals(qName)) {
            this.isSecurity = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.isSecurity) {
            if ("security".equals(qName)) {
                this.isSecurity = false;
            } else if ("user-name".equals(qName)) {
                this.username = this.content.toString();
            } else if ("password".equals(qName)) {
                this.password = this.content.toString();
            }
        } else if (this.isDatasource) {
            if ("datasource".equals(qName)) {
                this.isDatasource = false;
                if (this.jndiName != null && this.url != null) {
                    this.datasources.add(new JBossDatasource(this.jndiName, this.url, this.username, this.password, this.driverClass));
                } else {
                    Logger.getLogger(JB7DatasourceHandler.class.getName()).log(Level.INFO, "Malformed datasource found");
                }
            } else if ("connection-url".equals(qName)) {
                this.url = this.content.toString();
            } else if ("driver-class".equals(qName)) {
                this.driverClass = this.content.toString();
            }
        } else if (this.isDatasources && "datasources".equals(qName)) {
            this.isSecurity = false;
            this.isDatasource = false;
            this.isDatasources = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isDatasource) {
            this.content.append(ch, start, length);
        }
    }
}

