/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.fetch;

import java.text.MessageFormat;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitRemoteConfig;
import org.netbeans.modules.git.remote.options.AnnotationColorProvider;
import org.netbeans.modules.git.remote.ui.selectors.ItemSelector;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.openide.util.NbBundle;

public class BranchMapping
extends ItemSelector.Item {
    private final String label;
    private final String tooltip;
    private final String remoteBranchName;
    private final GitBranch localBranch;
    private final GitRemoteConfig remote;
    private static final String BRANCH_MAPPING_LABEL = "{0} -> {1}/{0} [{2}]";
    private static final String BRANCH_DELETE_MAPPING_LABEL = "{0} [{1}]";
    private static final String BRANCH_MAPPING_LABEL_UPTODATE = "{0} -> {1}/{0}";
    private static final String COLOR_NEW = GitUtils.getColorString(AnnotationColorProvider.getInstance().ADDED_FILE.getActualColor());
    private static final String COLOR_MODIFIED = GitUtils.getColorString(AnnotationColorProvider.getInstance().MODIFIED_FILE.getActualColor());
    private static final String COLOR_REMOVED = GitUtils.getColorString(AnnotationColorProvider.getInstance().REMOVED_FILE.getActualColor());

    public BranchMapping(String remoteBranchName, String remoteBranchId, GitBranch localBranch, GitRemoteConfig remote, boolean preselected) {
        super(preselected, remoteBranchName == null);
        this.remoteBranchName = remoteBranchName;
        this.localBranch = localBranch;
        this.remote = remote;
        if (this.isDeletion()) {
            this.label = MessageFormat.format(BRANCH_DELETE_MAPPING_LABEL, localBranch.getName(), "<font color=\"" + COLOR_REMOVED + "\">R</font>");
            this.tooltip = NbBundle.getMessage(BranchMapping.class, (String)"LBL_FetchBranchesPanel.BranchMapping.description", (Object[])new Object[]{localBranch.getName(), NbBundle.getMessage(BranchMapping.class, (String)"LBL_FetchBranchesPanel.BranchMapping.Mode.deleted.description")});
        } else if (localBranch == null) {
            this.label = MessageFormat.format(BRANCH_MAPPING_LABEL, remoteBranchName, remote.getRemoteName(), "<font color=\"" + COLOR_NEW + "\">A</font>");
            this.tooltip = NbBundle.getMessage(BranchMapping.class, (String)"LBL_FetchBranchesPanel.BranchMapping.description", (Object[])new Object[]{remote.getRemoteName() + "/" + remoteBranchName, NbBundle.getMessage(BranchMapping.class, (String)"LBL_FetchBranchesPanel.BranchMapping.Mode.added.description")});
        } else if (localBranch.getId().equals(remoteBranchId)) {
            this.label = MessageFormat.format(BRANCH_MAPPING_LABEL_UPTODATE, remoteBranchName, remote.getRemoteName());
            this.tooltip = NbBundle.getMessage(BranchMapping.class, (String)"LBL_FetchBranchesPanel.BranchMapping.Mode.uptodate.description", (Object)localBranch.getName());
        } else {
            this.label = MessageFormat.format(BRANCH_MAPPING_LABEL, remoteBranchName, remote.getRemoteName(), "<font color=\"" + COLOR_MODIFIED + "\">U</font>");
            this.tooltip = NbBundle.getMessage(BranchMapping.class, (String)"LBL_FetchBranchesPanel.BranchMapping.description", (Object[])new Object[]{localBranch.getName(), NbBundle.getMessage(BranchMapping.class, (String)"LBL_FetchBranchesPanel.BranchMapping.Mode.updated.description")});
        }
    }

    public String getRefSpec() {
        if (this.isDeletion()) {
            return GitUtils.getDeletedRefSpec(this.localBranch);
        }
        return GitUtils.getRefSpec(this.remoteBranchName, this.remote.getRemoteName());
    }

    @Override
    public String getText() {
        return this.label;
    }

    @Override
    public String getTooltipText() {
        return this.tooltip;
    }

    public String getRemoteBranchName() {
        return this.remoteBranchName;
    }

    public String getRemoteName() {
        return this.remote.getRemoteName();
    }

    @Override
    public int compareTo(ItemSelector.Item t) {
        if (t == null) {
            return 1;
        }
        if (t instanceof BranchMapping) {
            BranchMapping other = (BranchMapping)t;
            if (this.isDeletion() && other.isDeletion()) {
                return this.localBranch.getName().compareTo(other.localBranch.getName());
            }
            if (this.isDeletion() && !other.isDeletion()) {
                return 1;
            }
            if (!this.isDeletion() && other.isDeletion()) {
                return -1;
            }
            return this.remoteBranchName.compareTo(other.remoteBranchName);
        }
        return 0;
    }

    public GitBranch getLocalBranch() {
        return this.localBranch;
    }
}

