/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.clone;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitClient;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRemoteConfig;
import org.netbeans.modules.git.remote.cli.GitSubmoduleStatus;
import org.netbeans.modules.git.remote.cli.GitTransportUpdate;
import org.netbeans.modules.git.remote.cli.GitURI;
import org.netbeans.modules.git.remote.client.CredentialsCallback;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.ContextHolder;
import org.netbeans.modules.git.remote.ui.clone.Bundle;
import org.netbeans.modules.git.remote.ui.clone.CloneWizard;
import org.netbeans.modules.git.remote.ui.output.OutputLogger;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.remotefs.versioning.api.ProjectUtilities;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CloneAction
implements ActionListener,
HelpCtx.Provider {
    private final VCSContext ctx;
    private static final Logger LOG = Logger.getLogger(CloneAction.class.getName());

    public CloneAction(ContextHolder ctx) {
        this.ctx = ctx.getContext();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.git.remote.ui.clone.CloneAction");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        Utils.logVCSActionEvent((String)"Git");
        String cloneFromPath = null;
        FileSystem fs = null;
        if (this.ctx != null) {
            Set roots = this.ctx.getRootFiles();
            if (roots.size() == 1) {
                VCSFileProxy file;
                FileObject fo;
                Collection nodes;
                Lookup l = this.ctx.getElements();
                Project project = null;
                if (l != null && (nodes = l.lookupAll(Node.class)) != null && !nodes.isEmpty()) {
                    project = (Project)((Node)nodes.iterator().next()).getLookup().lookup(Project.class);
                }
                if (project == null && (fo = ((VCSFileProxy)roots.iterator().next()).toFileObject()) != null && fo.isFolder()) {
                    try {
                        project = ProjectManager.getDefault().findProject(fo);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if (project != null && (file = VCSFileProxy.createFileProxy((FileObject)(fo = project.getProjectDirectory()))) != null && Git.getInstance().isManaged(file)) {
                    cloneFromPath = Git.getInstance().getRepositoryRoot(file).getPath();
                }
            }
            if (roots.size() > 1) {
                fs = VCSFileProxySupport.getFileSystem((VCSFileProxy)((VCSFileProxy)roots.iterator().next()));
            }
        }
        if (fs != null) {
            CloneAction.performClone(fs, cloneFromPath, null);
        }
    }

    private static void performClone(FileSystem fs, String url, PasswordAuthentication pa) throws MissingResourceException {
        CloneAction.performClone(fs, url, pa, false);
    }

    public static VCSFileProxy performClone(FileSystem fs, String url, PasswordAuthentication pa, boolean waitFinished) throws MissingResourceException {
        final CloneWizard wiz = new CloneWizard(fs, pa, url);
        Boolean ok = (Boolean)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                return wiz.show();
            }
        });
        if (Boolean.TRUE.equals(ok)) {
            List<String> refSpecs;
            final GitURI remoteUri = wiz.getRemoteURI();
            final VCSFileProxy destination = wiz.getDestination();
            final String remoteName = wiz.getRemoteName();
            List<String> branches = wiz.getBranchNames();
            if (branches == CloneWizard.ALL_BRANCHES) {
                refSpecs = Collections.singletonList(GitUtils.getGlobalRefSpec(remoteName));
            } else {
                refSpecs = new ArrayList<String>(branches.size());
                for (String branchName : branches) {
                    refSpecs.add(GitUtils.getRefSpec(branchName, remoteName));
                }
            }
            final GitBranch branch = wiz.getBranch();
            final boolean scan = wiz.scanForProjects();
            GitProgressSupport supp = new GitProgressSupport(10){

                @Override
                protected void perform() {
                    try {
                        GitUtils.runWithoutIndexing(new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                GitClient client = this.getClient();
                                this.setDisplayName(Bundle.MSG_Clone_progress_initializingRepository());
                                client.init(this.getProgressMonitor());
                                this.setDisplayName(Bundle.MSG_Clone_progress_fetchingCommits(), 1);
                                Map<String, GitTransportUpdate> updates = client.fetch(remoteUri.toPrivateString(), refSpecs, this.getProgressMonitor());
                                this.log(updates);
                                if (this.isCanceled()) {
                                    return null;
                                }
                                List<String> refs = Arrays.asList(GitUtils.getGlobalRefSpec(remoteName));
                                this.setDisplayName(Bundle.MSG_Clone_progress_settingRemote(remoteName), 2);
                                String username = new CredentialsCallback().getUsername(remoteUri.toString(), "");
                                GitURI uriToSave = remoteUri;
                                if (username != null && !username.isEmpty()) {
                                    uriToSave = uriToSave.setUser(username);
                                }
                                client.setRemote(new CloneRemoteConfig(remoteName, uriToSave, refs).toGitRemote(), this.getProgressMonitor());
                                Utils.logVCSExternalRepository((String)"GIT", (String)remoteUri.getHost());
                                if (branch == null) {
                                    this.setDisplayName(Bundle.MSG_Clone_progress_creatingBranch("master"), 1);
                                    client.createBranch("master", "refs/remotes/" + remoteName + "/" + "master", this.getProgressMonitor());
                                } else {
                                    this.setDisplayName(Bundle.MSG_Clone_progress_checkingoutBranch(branch.getName()), 1);
                                    client.createBranch(branch.getName(), remoteName + "/" + branch.getName(), this.getProgressMonitor());
                                    client.checkoutRevision(branch.getName(), true, this.getProgressMonitor());
                                    client.reset(branch.getName(), GitClient.ResetType.HARD, this.getProgressMonitor());
                                }
                                this.setDisplayName(Bundle.MSG_Clone_progress_refreshingFiles(), 2);
                                Git.getInstance().getFileStatusCache().refreshAllRoots(destination);
                                if (!this.isCanceled()) {
                                    this.initSubmodules();
                                }
                                Git.getInstance().versionedFilesChanged();
                                if (scan && !this.isCanceled()) {
                                    this.setDisplayName(Bundle.MSG_Clone_progress_scanningForProjects(), 1);
                                    this.scanForProjects(destination);
                                }
                                return null;
                            }

                            private void initSubmodules() {
                                try {
                                    GitClient client = this.getClient();
                                    this.setDisplayName(Bundle.MSG_Clone_progress_checkingForSubmodules(), 1);
                                    Map<VCSFileProxy, GitSubmoduleStatus> statuses = client.getSubmoduleStatus(new VCSFileProxy[0], this.getProgressMonitor());
                                    ArrayList<VCSFileProxy> toInit = new ArrayList<VCSFileProxy>(statuses.size());
                                    for (Map.Entry<VCSFileProxy, GitSubmoduleStatus> e : statuses.entrySet()) {
                                        if (e.getValue().getStatus() != GitSubmoduleStatus.StatusType.UNINITIALIZED) continue;
                                        toInit.add(e.getKey());
                                    }
                                    if (!this.isCanceled() && !toInit.isEmpty() && this.confirmSubmoduleInit(toInit)) {
                                        this.setDisplayName(Bundle.MSG_Clone_progress_initializingSubmodules(), 1);
                                        client.initializeSubmodules(toInit.toArray(new VCSFileProxy[toInit.size()]), this.getProgressMonitor());
                                        this.setDisplayName(Bundle.MSG_Clone_progress_updatingSubmodules(), 1);
                                        for (VCSFileProxy submoduleRoot : toInit) {
                                            if (this.isCanceled()) {
                                                return;
                                            }
                                            try {
                                                this.setProgress(Bundle.MSG_Clone_progress_updatingSubmodule(submoduleRoot.getName()));
                                                client.updateSubmodules(new VCSFileProxy[]{submoduleRoot}, this.getProgressMonitor());
                                            }
                                            catch (GitException ex) {
                                                LOG.log(Level.INFO, null, ex);
                                            }
                                        }
                                    } else {
                                        this.updateProgress(2);
                                    }
                                }
                                catch (GitException ex) {
                                    LOG.log(Level.INFO, null, ex);
                                }
                            }

                            private boolean confirmSubmoduleInit(List<VCSFileProxy> subrepos) {
                                return 0 == JOptionPane.showConfirmDialog(null, Bundle.MSG_Clone_confirmSubmoduleInit_text(), Bundle.LBL_Clone_confirmSubmoduleInit_title(), 0, 3);
                            }
                        }, destination);
                    }
                    catch (GitException ex) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                }

                private void log(Map<String, GitTransportUpdate> updates) {
                    OutputLogger logger = this.getLogger();
                    if (updates.isEmpty()) {
                        logger.outputLine(NbBundle.getMessage(CloneAction.class, (String)"MSG_CloneAction.updates.noChange"));
                    } else {
                        for (Map.Entry<String, GitTransportUpdate> e : updates.entrySet()) {
                            GitTransportUpdate update = e.getValue();
                            if (update.getType() == GitTransportUpdate.Type.BRANCH) {
                                logger.outputLine(NbBundle.getMessage(CloneAction.class, (String)"MSG_CloneAction.updates.updateBranch", (Object[])new Object[]{update.getLocalName(), update.getOldObjectId(), update.getNewObjectId(), update.getResult()}));
                                continue;
                            }
                            logger.outputLine(NbBundle.getMessage(CloneAction.class, (String)"MSG_CloneAction.updates.updateTag", (Object[])new Object[]{update.getLocalName(), update.getResult()}));
                        }
                    }
                }

                public void scanForProjects(VCSFileProxy workingFolder) {
                    HashMap checkedOutProjects = new HashMap();
                    checkedOutProjects.put(null, new HashSet());
                    VCSFileProxy normalizedWorkingFolder = workingFolder.normalizeFile();
                    FileObject fo = normalizedWorkingFolder.toFileObject();
                    if (fo == null || !fo.isFolder()) {
                        return;
                    }
                    org.netbeans.modules.versioning.util.ProjectUtilities.scanForProjects((FileObject)fo, checkedOutProjects);
                    if (this.isCanceled()) {
                        return;
                    }
                    ProjectUtilities.openClonedOutProjects(checkedOutProjects, (VCSFileProxy)workingFolder);
                }
            };
            RequestProcessor.Task task = supp.start(Git.getInstance().getRequestProcessor(destination), destination, NbBundle.getMessage(CloneAction.class, (String)"LBL_CloneAction.progressName"));
            if (waitFinished) {
                task.waitFinished();
            }
            return destination;
        }
        return null;
    }

    private boolean isEnabled() {
        Set rootFiles = this.ctx.getRootFiles();
        if (rootFiles.isEmpty()) {
            return false;
        }
        VCSFileProxy root = (VCSFileProxy)rootFiles.iterator().next();
        return VCSFileProxySupport.isConnectedFileSystem((FileSystem)VCSFileProxySupport.getFileSystem((VCSFileProxy)root));
    }

    private static class CloneRemoteConfig {
        private final String remoteName;
        private final GitURI remoteUri;
        private final List<String> refSpecs;

        public CloneRemoteConfig(String remoteName, GitURI remoteUri, List<String> refSpecs) {
            this.remoteName = remoteName;
            this.remoteUri = remoteUri;
            this.refSpecs = refSpecs;
        }

        public String getRemoteName() {
            return this.remoteName;
        }

        public List<String> getUris() {
            return Arrays.asList(this.remoteUri.toPrivateString());
        }

        public List<String> getPushUris() {
            return Collections.emptyList();
        }

        public List<String> getFetchRefSpecs() {
            return this.refSpecs;
        }

        public List<String> getPushRefSpecs() {
            return Collections.emptyList();
        }

        private GitRemoteConfig toGitRemote() {
            return new GitRemoteConfig(this.remoteName, this.getUris(), this.getPushUris(), this.getFetchRefSpecs(), this.getPushRefSpecs());
        }
    }
}

