/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.classpath.AptSourcePath;
import org.netbeans.modules.java.source.classpath.CacheClassPath;
import org.netbeans.modules.java.source.classpath.SourcePath;
import org.netbeans.modules.java.source.indexing.TransactionContext;
import org.netbeans.modules.java.source.parsing.AptSourceFileManager;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.CachingFileManager;
import org.netbeans.modules.java.source.parsing.FileManagerTransaction;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.netbeans.modules.java.source.parsing.MemoryFileManager;
import org.netbeans.modules.java.source.parsing.OutputFileManager;
import org.netbeans.modules.java.source.parsing.ProcessorGenerated;
import org.netbeans.modules.java.source.parsing.ProxyFileManager;
import org.netbeans.modules.java.source.parsing.SiblingSource;
import org.netbeans.modules.java.source.parsing.SiblingSupport;
import org.netbeans.modules.java.source.parsing.SourceFileManager;
import org.netbeans.modules.java.source.parsing.TreeLoaderOutputFileManager;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class ClasspathInfo {
    private static final Logger log;
    private final CachingArchiveProvider archiveProvider;
    private final ClassPath srcClassPath;
    private final ClassPath bootClassPath;
    private final ClassPath compileClassPath;
    private final ClassPath cachedAptSrcClassPath;
    private final ClassPath cachedSrcClassPath;
    private final ClassPath cachedBootClassPath;
    private final ClassPath cachedCompileClassPath;
    private final ClassPath outputClassPath;
    private final ClassPathListener cpListener;
    private final boolean useModifiedFiles;
    private final boolean ignoreExcludes;
    private final JavaFileFilterImplementation filter;
    private final MemoryFileManager memoryFileManager;
    private final ChangeSupport listenerList;
    private final FileManagerTransaction fmTx;
    private final ProcessorGenerated pgTx;
    private final Function<JavaFileManager.Location, JavaFileManager> jfmProvider;
    private ClassIndex usagesQuery;

    private ClasspathInfo(@NonNull CachingArchiveProvider archiveProvider, @NonNull ClassPath bootCp, @NonNull ClassPath compileCp, @NullAllowed ClassPath srcCp, @NullAllowed JavaFileFilterImplementation filter, boolean backgroundCompilation, boolean ignoreExcludes, boolean hasMemoryFileManager, boolean useModifiedFiles, @NullAllowed Function<JavaFileManager.Location, JavaFileManager> jfmProvider) {
        assert (archiveProvider != null);
        assert (bootCp != null);
        assert (compileCp != null);
        this.cpListener = new ClassPathListener();
        this.archiveProvider = archiveProvider;
        this.bootClassPath = bootCp;
        this.compileClassPath = compileCp;
        this.listenerList = new ChangeSupport((Object)this);
        this.cachedBootClassPath = CacheClassPath.forBootPath(this.bootClassPath, backgroundCompilation);
        this.cachedCompileClassPath = CacheClassPath.forClassPath(this.compileClassPath, backgroundCompilation);
        if (!backgroundCompilation) {
            this.cachedBootClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpListener, (Object)this.cachedBootClassPath));
            this.cachedCompileClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpListener, (Object)this.cachedCompileClassPath));
        }
        if (srcCp == null) {
            this.srcClassPath = this.outputClassPath = ClassPath.EMPTY;
            this.cachedSrcClassPath = this.outputClassPath;
            this.cachedAptSrcClassPath = null;
        } else {
            this.srcClassPath = srcCp;
            ClassPathImplementation noApt = AptSourcePath.sources(srcCp);
            this.cachedSrcClassPath = ClassPathFactory.createClassPath((ClassPathImplementation)SourcePath.filtered(noApt, backgroundCompilation));
            this.cachedAptSrcClassPath = ClassPathFactory.createClassPath((ClassPathImplementation)SourcePath.filtered(AptSourcePath.aptCache(srcCp), backgroundCompilation));
            this.outputClassPath = CacheClassPath.forSourcePath(ClassPathFactory.createClassPath((ClassPathImplementation)noApt), backgroundCompilation);
            if (!backgroundCompilation) {
                this.cachedSrcClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpListener, (Object)this.cachedSrcClassPath));
            }
        }
        this.ignoreExcludes = ignoreExcludes;
        this.useModifiedFiles = useModifiedFiles;
        this.filter = filter;
        if (hasMemoryFileManager) {
            if (srcCp == null) {
                throw new IllegalStateException();
            }
            this.memoryFileManager = new MemoryFileManager();
        } else {
            this.memoryFileManager = null;
        }
        if (backgroundCompilation) {
            TransactionContext txCtx = TransactionContext.get();
            this.fmTx = txCtx.get(FileManagerTransaction.class);
            this.pgTx = txCtx.get(ProcessorGenerated.class);
        } else {
            this.fmTx = FileManagerTransaction.treeLoaderOnly();
            this.pgTx = ProcessorGenerated.nullWrite();
        }
        assert (this.fmTx != null) : "No file manager transaction.";
        assert (this.pgTx != null) : "No processor generated transaction.";
        this.jfmProvider = jfmProvider;
    }

    public String toString() {
        return String.format("ClasspathInfo [boot: %s, compile: %s, src: %s, internal boot: %s, internal compile: %s, internal src: %s, internal out: %s]", this.bootClassPath, this.compileClassPath, this.srcClassPath, this.cachedBootClassPath, this.cachedCompileClassPath, this.cachedSrcClassPath, this.outputClassPath);
    }

    public int hashCode() {
        return Arrays.hashCode(ClasspathInfo.toURIs(this.srcClassPath));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClasspathInfo)) {
            return false;
        }
        ClasspathInfo other = (ClasspathInfo)obj;
        return Arrays.equals(ClasspathInfo.toURIs(this.srcClassPath), ClasspathInfo.toURIs(other.srcClassPath)) && Arrays.equals(ClasspathInfo.toURIs(this.compileClassPath), ClasspathInfo.toURIs(other.compileClassPath)) && Arrays.equals(ClasspathInfo.toURIs(this.bootClassPath), ClasspathInfo.toURIs(other.bootClassPath));
    }

    @NullUnknown
    public static ClasspathInfo create(@NonNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot pass null as parameter of ClasspathInfo.create(java.io.File)");
        }
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            return null;
        }
        return ClasspathInfo.create(fo);
    }

    @NullUnknown
    public static ClasspathInfo create(@NonNull Document doc) {
        Parameters.notNull((CharSequence)"doc", (Object)doc);
        FileObject fileObject = Utilities.getFileObject((Document)doc);
        if (fileObject != null) {
            return ClasspathInfo.create(fileObject);
        }
        return null;
    }

    @NonNull
    public static ClasspathInfo create(@NonNull FileObject fo) {
        return ClasspathInfo.create(fo, null, false, false, false, true);
    }

    @NonNull
    public static ClasspathInfo create(@NonNull ClassPath bootPath, @NonNull ClassPath classPath, @NullAllowed ClassPath sourcePath) {
        Parameters.notNull((CharSequence)"bootPath", (Object)bootPath);
        Parameters.notNull((CharSequence)"classPath", (Object)classPath);
        return ClasspathInfo.create(bootPath, classPath, sourcePath, null, false, false, false, true, null);
    }

    @NonNull
    private static ClasspathInfo create(@NonNull FileObject fo, @NullAllowed JavaFileFilterImplementation filter, boolean backgroundCompilation, boolean ignoreExcludes, boolean hasMemoryFileManager, boolean useModifiedFiles) {
        ClassPath compilePath;
        ClassPath bootPath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/boot");
        if (bootPath == null) {
            bootPath = JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries();
        }
        if ((compilePath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile")) == null) {
            compilePath = ClassPath.EMPTY;
        }
        ClassPath srcPath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        return ClasspathInfo.create(bootPath, compilePath, srcPath, filter, backgroundCompilation, ignoreExcludes, hasMemoryFileManager, useModifiedFiles, null);
    }

    @NonNull
    private static ClasspathInfo create(@NonNull ClassPath bootPath, @NonNull ClassPath classPath, @NullAllowed ClassPath sourcePath, @NullAllowed JavaFileFilterImplementation filter, boolean backgroundCompilation, boolean ignoreExcludes, boolean hasMemoryFileManager, boolean useModifiedFiles, @NullAllowed Function<JavaFileManager.Location, JavaFileManager> jfmProvider) {
        return new ClasspathInfo(CachingArchiveProvider.getDefault(), bootPath, classPath, sourcePath, filter, backgroundCompilation, ignoreExcludes, hasMemoryFileManager, useModifiedFiles, jfmProvider);
    }

    public void addChangeListener(@NonNull ChangeListener listener) {
        this.listenerList.addChangeListener(listener);
    }

    public synchronized void removeChangeListener(@NonNull ChangeListener listener) {
        this.listenerList.removeChangeListener(listener);
    }

    public ClassPath getClassPath(@NonNull PathKind pathKind) {
        switch (pathKind) {
            case BOOT: {
                return this.bootClassPath;
            }
            case COMPILE: {
                return this.compileClassPath;
            }
            case SOURCE: {
                return this.srcClassPath;
            }
        }
        assert (false) : "Unknown path type";
        return null;
    }

    ClassPath getCachedClassPath(PathKind pathKind) {
        switch (pathKind) {
            case BOOT: {
                return this.cachedBootClassPath;
            }
            case COMPILE: {
                return this.cachedCompileClassPath;
            }
            case SOURCE: {
                return this.cachedSrcClassPath;
            }
            case OUTPUT: {
                return this.outputClassPath;
            }
        }
        assert (false) : "Unknown path type";
        return null;
    }

    @NonNull
    public synchronized ClassIndex getClassIndex() {
        if (this.usagesQuery == null) {
            this.usagesQuery = new ClassIndex(this.bootClassPath, this.compileClassPath, this.cachedSrcClassPath);
        }
        return this.usagesQuery;
    }

    @NonNull
    private synchronized JavaFileManager createFileManager() {
        JavaFileManager tmp;
        boolean hasSources = this.cachedSrcClassPath != ClassPath.EMPTY;
        SiblingSource siblings = SiblingSupport.create();
        JavaFileManager outFm = hasSources ? (this.jfmProvider != null && (tmp = this.jfmProvider.apply(StandardLocation.CLASS_OUTPUT)) != null ? tmp : new OutputFileManager(this.archiveProvider, this.outputClassPath, this.cachedSrcClassPath, this.cachedAptSrcClassPath, siblings.getProvider(), this.fmTx)) : null;
        ProxyFileManager fileManager = new ProxyFileManager(new CachingFileManager(this.archiveProvider, this.cachedBootClassPath, true, true), new CachingFileManager(this.archiveProvider, this.cachedCompileClassPath, false, true), hasSources ? (!this.useModifiedFiles ? new CachingFileManager(this.archiveProvider, this.cachedSrcClassPath, this.filter, false, this.ignoreExcludes) : new SourceFileManager(this.cachedSrcClassPath, this.ignoreExcludes)) : null, this.cachedAptSrcClassPath != null ? new AptSourceFileManager(this.cachedSrcClassPath, this.cachedAptSrcClassPath, siblings.getProvider(), this.fmTx) : null, outFm, new TreeLoaderOutputFileManager(this.archiveProvider, this.fmTx), this.memoryFileManager, this.pgTx, siblings);
        return fileManager;
    }

    private void fireChangeListenerStateChanged() {
        this.listenerList.fireChange();
    }

    @CheckForNull
    private static URI[] toURIs(@NullAllowed ClassPath cp) {
        if (cp == null) {
            return null;
        }
        List entries = cp.entries();
        ArrayList<URI> roots = new ArrayList<URI>(entries.size());
        for (ClassPath.Entry entry : entries) {
            try {
                roots.add(entry.getURL().toURI());
            }
            catch (URISyntaxException ex) {
                log.log(Level.INFO, "Cannot convert {0} to URI.", entry.getURL());
            }
        }
        return roots.toArray(new URI[roots.size()]);
    }

    static {
        block2: {
            log = Logger.getLogger(ClasspathInfo.class.getName());
            ClasspathInfoAccessor.setINSTANCE(new ClasspathInfoAccessorImpl());
            try {
                Class.forName(ClassIndex.class.getName(), true, CompilationInfo.class.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                if (!log.isLoggable(Level.SEVERE)) break block2;
                log.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public static interface Provider {
        public ClasspathInfo getClasspathInfo();
    }

    private static class ClasspathInfoAccessorImpl
    extends ClasspathInfoAccessor {
        private ClasspathInfoAccessorImpl() {
        }

        @Override
        @NonNull
        public JavaFileManager createFileManager(@NonNull ClasspathInfo cpInfo) {
            return cpInfo.createFileManager();
        }

        @Override
        @NonNull
        public FileManagerTransaction getFileManagerTransaction(@NonNull ClasspathInfo cpInfo) {
            return cpInfo.fmTx;
        }

        @Override
        public ClassPath getCachedClassPath(ClasspathInfo cpInfo, PathKind kind) {
            return cpInfo.getCachedClassPath(kind);
        }

        @Override
        public ClasspathInfo create(ClassPath bootPath, ClassPath classPath, ClassPath sourcePath, JavaFileFilterImplementation filter, boolean backgroundCompilation, boolean ignoreExcludes, boolean hasMemoryFileManager, boolean useModifiedFiles, @NullAllowed Function<JavaFileManager.Location, JavaFileManager> jfmProvider) {
            return ClasspathInfo.create(bootPath, classPath, sourcePath, filter, backgroundCompilation, ignoreExcludes, hasMemoryFileManager, useModifiedFiles, jfmProvider);
        }

        @Override
        public ClasspathInfo create(@NonNull FileObject fo, JavaFileFilterImplementation filter, boolean backgroundCompilation, boolean ignoreExcludes, boolean hasMemoryFileManager, boolean useModifiedFiles) {
            return ClasspathInfo.create(fo, filter, backgroundCompilation, ignoreExcludes, hasMemoryFileManager, useModifiedFiles);
        }

        @Override
        public boolean registerVirtualSource(ClasspathInfo cpInfo, InferableJavaFileObject jfo) throws UnsupportedOperationException {
            if (cpInfo.memoryFileManager == null) {
                throw new UnsupportedOperationException("The ClassPathInfo doesn't support memory JavacFileManager");
            }
            return cpInfo.memoryFileManager.register(jfo);
        }

        @Override
        public boolean unregisterVirtualSource(ClasspathInfo cpInfo, String fqn) throws UnsupportedOperationException {
            if (cpInfo.memoryFileManager == null) {
                throw new UnsupportedOperationException();
            }
            return cpInfo.memoryFileManager.unregister(fqn);
        }
    }

    private class ClassPathListener
    implements PropertyChangeListener {
        private ClassPathListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("roots".equals(event.getPropertyName())) {
                ClasspathInfo.this.fireChangeListenerStateChanged();
            }
        }
    }

    public static enum PathKind {
        BOOT,
        COMPILE,
        SOURCE,
        OUTPUT;

    }
}

