/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.deep;

import java.util.Collection;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.deep.CsmCondition;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmSwitchStatement;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ConditionDeclarationImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ConditionExpressionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.DeepUtil;
import org.netbeans.modules.cnd.modelimpl.csm.deep.StatementBase;

public final class SwitchStatementImpl
extends StatementBase
implements CsmSwitchStatement {
    private CsmCondition condition;
    private StatementBase body;

    private SwitchStatementImpl(AST ast, CsmFile file, CsmScope scope) {
        super(ast, file, scope);
    }

    private SwitchStatementImpl(CsmScope scope, CsmFile file, int start, int end) {
        super(file, start, end, scope);
    }

    public static SwitchStatementImpl create(AST ast, CsmFile file, CsmScope scope) {
        SwitchStatementImpl stmt = new SwitchStatementImpl(ast, file, scope);
        stmt.init(ast);
        return stmt;
    }

    private void init(AST ast) {
        AST token = AstUtil.findChildOfType(ast, 610);
        if (token != null) {
            this.condition = new AstRenderer((FileImpl)this.getContainingFile()).renderCondition(token, (CsmScope)this);
        }
        for (AST token2 = ast.getFirstChild(); token2 != null; token2 = token2.getNextSibling()) {
            if (!AstRenderer.isStatement(token2)) continue;
            this.body = AstRenderer.renderStatement(token2, this.getContainingFile(), (CsmScope)this);
            break;
        }
    }

    public CsmStatement.Kind getKind() {
        return CsmStatement.Kind.SWITCH;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.condition instanceof Disposable) {
            ((Disposable)this.condition).dispose();
        }
        if (this.body != null) {
            this.body.dispose();
        }
    }

    public CsmCondition getCondition() {
        return this.condition;
    }

    public CsmStatement getBody() {
        return this.body;
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return DeepUtil.merge(this.getCondition(), this.getBody());
    }

    public static class SwitchStatementBuilder
    extends StatementBase.StatementBuilder
    implements StatementBase.StatementBuilderContainer {
        ConditionExpressionImpl.ConditionExpressionBuilder conditionExpression;
        ConditionDeclarationImpl.ConditionDeclarationBuilder conditionDeclaration;
        StatementBase.StatementBuilder body;

        public void setConditionExpression(ConditionExpressionImpl.ConditionExpressionBuilder conditionExpression) {
            this.conditionExpression = conditionExpression;
        }

        public void setConditionDeclaration(ConditionDeclarationImpl.ConditionDeclarationBuilder conditionDeclaration) {
            this.conditionDeclaration = conditionDeclaration;
        }

        public void setBody(StatementBase.StatementBuilder body) {
            this.body = body;
        }

        @Override
        public SwitchStatementImpl create() {
            SwitchStatementImpl stmt = new SwitchStatementImpl(this.getScope(), this.getFile(), this.getStartOffset(), this.getEndOffset());
            if (this.body != null) {
                this.body.setScope((CsmScope)stmt);
                stmt.body = this.body.create();
            }
            if (this.conditionDeclaration != null) {
                this.conditionDeclaration.setScope((CsmScope)stmt);
                stmt.condition = this.conditionDeclaration.create();
            } else if (this.conditionExpression != null) {
                this.conditionExpression.setScope((CsmScope)stmt);
                stmt.condition = this.conditionExpression.create();
            }
            return stmt;
        }

        @Override
        public void addStatementBuilder(StatementBase.StatementBuilder builder) {
            this.body = builder;
        }
    }
}

