/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.PrintWriter;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmStandaloneFileProvider;
import org.netbeans.modules.cnd.api.project.DefaultSystemSettings;
import org.netbeans.modules.cnd.api.project.IncludePath;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.api.project.NativeProjectRegistry;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.trace.NativeProjectProvider;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndLanguageStandards;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Pair;

public class CsmStandaloneFileProviderImpl
extends CsmStandaloneFileProvider {
    private static final boolean TRACE = Boolean.getBoolean("cnd.standalone.trace");
    private static final Lock lock = new Lock();
    private static final Set<String> toBeRmoved = new HashSet<String>();
    private static final String PROP_LANG_STANDARD = "standard";
    private final CsmModelListener listener = new CsmModelListener(){

        public void projectOpened(CsmProject project) {
        }

        public void projectClosed(CsmProject project) {
        }

        public void modelChanged(CsmChangeEvent e) {
            for (CsmFile file : e.getNewFiles()) {
                CsmStandaloneFileProviderImpl.this.clean(file);
            }
            for (CsmFile file : e.getRemovedFiles()) {
                CsmStandaloneFileProviderImpl.this.onFileRemove(file);
            }
        }
    };
    private final CsmProgressListener progressListener = new CsmProgressAdapter(){

        public void projectLoaded(CsmProject project) {
            CsmStandaloneFileProviderImpl.this.clean((ProjectBase)project);
        }

        public void projectParsingFinished(CsmProject project) {
        }
    };

    public CsmStandaloneFileProviderImpl() {
        CsmListeners.getDefault().addModelListener(this.listener);
        CsmListeners.getDefault().addProgressListener(this.progressListener);
    }

    static CsmStandaloneFileProviderImpl getDefaultImpl() {
        return (CsmStandaloneFileProviderImpl)CsmStandaloneFileProvider.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmFile getCsmFile(FileObject fo) {
        if (fo == null || !fo.isValid() || !CsmUtilities.isCsmSuitable((FileObject)fo)) {
            return null;
        }
        CsmModelState modelState = CsmModelAccessor.getModelState();
        if (modelState != CsmModelState.ON) {
            if (TRACE) {
                CsmStandaloneFileProviderImpl.trace("model is %s, no extra work for %s", modelState, fo.getPath());
            }
            return null;
        }
        String absPath = CndFileUtils.normalizePath((FileObject)fo);
        ProjectBase project = null;
        CsmFile csmFile = ModelImpl.instance().findFile(FSPath.toFSPath((FileObject)fo), true, false);
        if (csmFile != null) {
            if (TRACE) {
                CsmStandaloneFileProviderImpl.trace("returns file %s", csmFile);
            }
            return csmFile;
        }
        Lock lock = CsmStandaloneFileProviderImpl.lock;
        synchronized (lock) {
            if (toBeRmoved.contains(absPath)) {
                return null;
            }
            NativeProject platformProject = NativeProjectImpl.getNativeProjectImpl(fo);
            if (platformProject != null) {
                project = ModelImpl.instance().addProject(platformProject, absPath, true);
                if (TRACE) {
                    CsmStandaloneFileProviderImpl.trace("added project %s", project);
                }
                if (project != null) {
                    project.ensureFilesCreated();
                }
            }
        }
        if (project != null && project.isValid()) {
            try {
                FileImpl out = project.getFile(absPath, false);
                if (TRACE) {
                    CsmStandaloneFileProviderImpl.trace("RETURNS STANALONE FILE %s", out);
                }
                return out;
            }
            catch (BufferUnderflowException ex) {
                DiagnosticExceptoins.register(ex);
            }
            catch (IllegalStateException ex) {
                DiagnosticExceptoins.register(ex);
            }
        }
        return null;
    }

    private void clean(ProjectBase projectOpened) {
        if (projectOpened.getPlatformProject() instanceof NativeProjectImpl) {
            return;
        }
        if (TRACE) {
            CsmStandaloneFileProviderImpl.trace("checking project %s", projectOpened.toString());
        }
        for (CsmProject dummy : ModelImpl.instance().projects()) {
            if (!(dummy.getPlatformProject() instanceof NativeProjectImpl)) continue;
            for (CsmFile file : dummy.getAllFiles()) {
                if (TRACE) {
                    CsmStandaloneFileProviderImpl.trace("\nchecking file %s", file.getAbsolutePath());
                }
                if (projectOpened.getFile(((FileImpl)file).getAbsolutePath(), false) == null) continue;
                this.scheduleProjectRemoval(dummy);
            }
        }
    }

    private void clean(CsmFile file) {
        if (!(file.getProject().getPlatformProject() instanceof NativeProjectImpl)) {
            this.notifyClosed(file);
        }
    }

    void onFileRemove(CsmFile file) {
        FileObject fo = CsmUtilities.getFileObject((CsmFile)file);
        if (fo != null && this.isOpen(fo)) {
            this.getCsmFile(fo);
        }
    }

    private boolean isOpen(FileObject fo) {
        try {
            DataObject dao = DataObject.find((FileObject)fo);
            if (dao != null) {
                return CsmUtilities.findOpenedEditor((DataObject)dao) != null;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClosed(CsmFile csmFile) {
        String closedFilePath = csmFile.getAbsolutePath().toString();
        Lock lock = CsmStandaloneFileProviderImpl.lock;
        synchronized (lock) {
            for (CsmProject csmProject : ModelImpl.instance().projects()) {
                NativeProjectImpl nativeProject;
                Object platformProject = csmProject.getPlatformProject();
                if (!(platformProject instanceof NativeProjectImpl) || !(nativeProject = (NativeProjectImpl)platformProject).getProjectRoot().equals(closedFilePath)) continue;
                for (CsmFile csmf : csmProject.getAllFiles()) {
                    NativeFileItemSet set;
                    FileObject fo = ((FileImpl)csmf).getFileObject();
                    DataObject dao = NativeProjectProvider.getDataObject(fo);
                    if (dao == null || (set = (NativeFileItemSet)dao.getLookup().lookup(NativeFileItemSet.class)) == null) continue;
                    set.remove((NativeFileItem)nativeProject.findFileItem(fo));
                }
                this.scheduleProjectRemoval(csmProject);
            }
        }
    }

    public boolean isStandalone(CsmFile file) {
        NativeFileItem nfi;
        return file instanceof FileImpl && (nfi = ((FileImpl)file).getNativeFileItem()) instanceof NativeFileItemImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleProjectRemoval(final CsmProject project) {
        if (!project.isValid()) {
            return;
        }
        Object nativeProject = project.getPlatformProject();
        if (!(nativeProject instanceof NativeProject)) {
            return;
        }
        final String root = ((NativeProject)nativeProject).getProjectRoot();
        if (TRACE) {
            CsmStandaloneFileProviderImpl.trace("schedulling removal %s", project.toString());
        }
        Lock lock = CsmStandaloneFileProviderImpl.lock;
        synchronized (lock) {
            toBeRmoved.add(root);
        }
        ModelImpl.instance().enqueueModelTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (project.isValid()) {
                    if (TRACE) {
                        CsmStandaloneFileProviderImpl.trace("removing %s", new Object[]{project.toString()});
                    }
                    ProjectBase projectBase = (ProjectBase)project;
                    ModelImpl.instance().closeProjectBase(projectBase, false);
                    Lock lock = lock;
                    synchronized (lock) {
                        toBeRmoved.remove(root);
                    }
                    if (TRACE) {
                        CsmStandaloneFileProviderImpl.trace("removed %s", new Object[]{project.toString()});
                    }
                }
            }
        }, "Standalone project removal.");
    }

    private static void trace(String pattern, Object ... args) {
        assert (TRACE) : "Should not be called if TRACE is off!";
        System.err.printf("### Standalone provider:  %s%n", String.format(pattern, args));
    }

    public void dumpInfo(PrintWriter printOut) {
        printOut.printf("SAProvider %s has toBeRemoved=%d entries%n", ((Object)((Object)this)).getClass().getSimpleName(), toBeRmoved.size());
        int ind = 1;
        for (String str : toBeRmoved) {
            printOut.printf("[%d] %s%n", ind++, str);
        }
    }

    private static final class NativeFileItemImpl
    implements NativeFileItem {
        private final FileObject fileObject;
        private final NativeProjectImpl project;
        private final NativeFileItem.Language lang;
        private NativeFileItem.LanguageFlavor flavor;

        public NativeFileItemImpl(FileObject file, NativeProjectImpl project, NativeFileItem.Language language, NativeFileItem.LanguageFlavor flavor) {
            this.project = project;
            this.fileObject = file;
            this.lang = language;
            this.flavor = flavor;
        }

        public NativeProject getNativeProject() {
            return this.project;
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }

        public String getAbsolutePath() {
            return CndFileUtils.normalizePath((FileObject)this.fileObject);
        }

        public String getName() {
            return this.fileObject.getNameExt();
        }

        public List<IncludePath> getSystemIncludePaths() {
            List<IncludePath> result = this.project.getSystemIncludePaths();
            this.checkAbsoluteItemPath(result);
            return result;
        }

        public List<IncludePath> getUserIncludePaths() {
            List<IncludePath> result = this.project.getUserIncludePaths();
            this.checkAbsoluteItemPath(result);
            return result;
        }

        public List<FSPath> getSystemIncludeHeaders() {
            List<FSPath> result = this.project.getSystemIncludeHeaders();
            this.checkAbsolute(result);
            return result;
        }

        public List<FSPath> getIncludeFiles() {
            return this.project.getIncludeFiles();
        }

        private void checkAbsolute(List<FSPath> orig) {
            for (FSPath path : orig) {
                CndUtils.assertAbsolutePathInConsole((String)path.getPath());
            }
        }

        private void checkAbsoluteItemPath(List<IncludePath> orig) {
            for (IncludePath path : orig) {
                CndUtils.assertAbsolutePathInConsole((String)path.getFSPath().getPath());
            }
        }

        public List<String> getSystemMacroDefinitions() {
            return this.project.getSystemMacroDefinitions();
        }

        public List<String> getUserMacroDefinitions() {
            return this.project.getUserMacroDefinitions();
        }

        public NativeFileItem.Language getLanguage() {
            return this.lang;
        }

        public NativeFileItem.LanguageFlavor getLanguageFlavor() {
            return this.flavor;
        }

        public void setLanguageFlavor(NativeFileItem.LanguageFlavor flavor) {
            this.flavor = flavor;
        }

        public boolean isExcluded() {
            return false;
        }

        public String toString() {
            return "SA " + this.fileObject + " " + System.identityHashCode(this) + " " + this.lang + " from project:" + this.project;
        }
    }

    static final class NativeProjectImpl
    implements NativeProject,
    ChangeListener,
    FileChangeListener {
        private final List<IncludePath> sysIncludes;
        private final List<IncludePath> usrIncludes;
        private final List<FSPath> sysIncludeHeaders;
        private final List<FSPath> usrFiles;
        private final List<String> sysMacros;
        private final List<String> usrMacros;
        private final List<NativeFileItemImpl> files = new ArrayList<NativeFileItemImpl>();
        private final FileObject projectRoot;
        private final FileSystem fileSystem;
        private final List<NativeProjectItemsListener> listeners = new ArrayList<NativeProjectItemsListener>();
        private final Object listenersLock = new Lock();

        static NativeProject getNativeProjectImpl(FileObject file) {
            NativeFileItem.LanguageFlavor standardToFlavor;
            FileSystem fs;
            Pair flavorExt;
            NativeFileItem.Language lang;
            DataObject dao = NativeProjectProvider.getDataObject(file);
            if (dao == null) {
                return null;
            }
            NativeFileItemSet set = (NativeFileItemSet)dao.getLookup().lookup(NativeFileItemSet.class);
            if (set == null) {
                return null;
            }
            NativeFileItem itemPrototype = null;
            if (!set.isEmpty()) {
                Iterator iterator = set.getItems().iterator();
                Collection openProjects = NativeProjectRegistry.getDefault().getOpenProjects();
                while (iterator.hasNext()) {
                    itemPrototype = (NativeFileItem)iterator.next();
                    if (!openProjects.contains(itemPrototype.getNativeProject())) continue;
                    return null;
                }
            }
            ModelImpl model = ModelImpl.instance();
            ArrayList<IncludePath> sysIncludes = new ArrayList<IncludePath>();
            ArrayList<IncludePath> usrIncludes = new ArrayList<IncludePath>();
            ArrayList<FSPath> sysIncludeHeaders = new ArrayList<FSPath>();
            ArrayList<FSPath> usrFiles = new ArrayList<FSPath>();
            ArrayList<String> sysMacros = new ArrayList<String>();
            ArrayList<String> usrMacros = new ArrayList<String>();
            ArrayList<String> undefinedMacros = new ArrayList<String>();
            if (itemPrototype != null) {
                lang = itemPrototype.getLanguage();
                flavorExt = Pair.of((Object)itemPrototype.getLanguageFlavor(), null);
            } else {
                lang = NativeProjectProvider.getLanguage(file, dao);
                flavorExt = NativeProjectImpl.getDefaultStandard(lang);
            }
            NativeProject prototype = null;
            for (CsmProject csmProject : model.projects()) {
                Object p = csmProject.getPlatformProject();
                if (!(p instanceof NativeProject)) continue;
                NativeProject project = (NativeProject)p;
                if (file.getPath().startsWith(project.getProjectRoot())) {
                    prototype = project;
                    break;
                }
                for (String root : project.getSourceRoots()) {
                    if (!file.getPath().startsWith(root)) continue;
                    prototype = project;
                    break;
                }
                if (prototype == null) continue;
                break;
            }
            if (prototype != null && ModelImpl.instance().isProjectDisabled(prototype)) {
                return null;
            }
            try {
                fs = file.getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                fs = CndFileUtils.getLocalFileSystem();
            }
            NativeProjectImpl impl = new NativeProjectImpl(file, sysIncludes, usrIncludes, sysIncludeHeaders, usrFiles, sysMacros, usrMacros, undefinedMacros);
            if (itemPrototype != null) {
                sysIncludes.addAll(itemPrototype.getSystemIncludePaths());
                sysMacros.addAll(itemPrototype.getSystemMacroDefinitions());
                sysIncludeHeaders.addAll(itemPrototype.getSystemIncludeHeaders());
                usrIncludes.addAll(itemPrototype.getUserIncludePaths());
                usrFiles.addAll(itemPrototype.getIncludeFiles());
                usrMacros.addAll(itemPrototype.getUserMacroDefinitions());
            } else if (prototype != null) {
                sysIncludes.addAll(prototype.getSystemIncludePaths());
                sysMacros.addAll(prototype.getSystemMacroDefinitions());
                sysIncludeHeaders.addAll(prototype.getSystemIncludeHeaders());
                usrIncludes.addAll(prototype.getUserIncludePaths());
                usrFiles.addAll(prototype.getIncludeFiles());
                usrMacros.addAll(prototype.getUserMacroDefinitions());
            } else {
                sysIncludes.addAll(IncludePath.toIncludePathList((FileSystem)fs, (Collection)DefaultSystemSettings.getDefault().getSystemIncludes(lang, (NativeProject)impl)));
                sysIncludeHeaders.addAll(CndFileUtils.toFSPathList((FileSystem)fs, (Collection)DefaultSystemSettings.getDefault().getSystemIncludeHeaders(lang, (NativeProject)impl)));
                sysMacros.addAll(DefaultSystemSettings.getDefault().getSystemMacros(lang, (NativeProject)impl));
            }
            impl.checkPaths();
            NativeFileItem.LanguageFlavor resultingFlavor = (NativeFileItem.LanguageFlavor)flavorExt.first();
            CndLanguageStandards.CndLanguageStandard standard = impl.getStandard(file);
            if (standard != null && (standardToFlavor = NativeProjectImpl.standardToFlavor(standard)) != NativeFileItem.LanguageFlavor.UNKNOWN) {
                resultingFlavor = standardToFlavor;
            }
            impl.addFile(file, lang, resultingFlavor);
            set.add((NativeFileItem)impl.findFileItem(file));
            MIMEExtensions me = (MIMEExtensions)flavorExt.second();
            if (me != null) {
                me.addChangeListener((ChangeListener)impl);
            }
            file.addFileChangeListener((FileChangeListener)impl);
            return impl;
        }

        private static Pair<NativeFileItem.LanguageFlavor, MIMEExtensions> getDefaultStandard(NativeFileItem.Language lang) {
            String key;
            String defFlavorTxt;
            CndLanguageStandards.CndLanguageStandard defaultStandard;
            NativeFileItem.LanguageFlavor flavor = NativeFileItem.LanguageFlavor.UNKNOWN;
            MIMEExtensions me = null;
            switch (lang) {
                case C: {
                    me = MIMEExtensions.get((String)"text/x-c");
                    break;
                }
                case CPP: {
                    me = MIMEExtensions.get((String)"text/x-c++");
                    break;
                }
                case C_HEADER: {
                    me = MIMEExtensions.get((String)"text/x-h");
                }
            }
            if (me != null && (defaultStandard = me.getDefaultStandard()) != null) {
                flavor = NativeProjectImpl.standardToFlavor(defaultStandard);
            }
            if (NativeFileItem.LanguageFlavor.UNKNOWN.equals((Object)flavor) && (defFlavorTxt = System.getProperty(key = "cnd.standalone.default.flavor." + lang.name())) != null) {
                try {
                    flavor = NativeFileItem.LanguageFlavor.valueOf((String)defFlavorTxt);
                }
                catch (IllegalArgumentException e) {
                    StringBuilder all = new StringBuilder();
                    for (NativeFileItem.LanguageFlavor lf : NativeFileItem.LanguageFlavor.values()) {
                        all.append(all.length() > 0 ? (char)',' : ' ').append(lf.name());
                    }
                    System.err.printf("Wrong parameter -J-D%s=%s. Should be one of %s%n", key, defFlavorTxt, all);
                }
            }
            return Pair.of((Object)flavor, (Object)me);
        }

        private static NativeFileItem.LanguageFlavor standardToFlavor(CndLanguageStandards.CndLanguageStandard defaultStandard) {
            NativeFileItem.LanguageFlavor flavor = NativeFileItem.LanguageFlavor.UNKNOWN;
            switch (defaultStandard) {
                case C89: {
                    flavor = NativeFileItem.LanguageFlavor.C89;
                    break;
                }
                case C99: {
                    flavor = NativeFileItem.LanguageFlavor.C99;
                    break;
                }
                case C11: {
                    flavor = NativeFileItem.LanguageFlavor.C11;
                    break;
                }
                case CPP98: {
                    flavor = NativeFileItem.LanguageFlavor.CPP;
                    break;
                }
                case CPP11: {
                    flavor = NativeFileItem.LanguageFlavor.CPP11;
                    break;
                }
                case CPP14: {
                    flavor = NativeFileItem.LanguageFlavor.CPP14;
                }
            }
            return flavor;
        }

        private NativeProjectImpl(FileObject projectRoot, List<IncludePath> sysIncludes, List<IncludePath> usrIncludes, List<FSPath> sysIncludeHeaders, List<FSPath> usrFiles, List<String> sysMacros, List<String> usrMacros, List<String> undefinedMacros) {
            this.projectRoot = projectRoot;
            this.fileSystem = NativeProjectImpl.getFileSystem(projectRoot);
            this.sysIncludes = sysIncludes;
            this.sysIncludeHeaders = sysIncludeHeaders;
            this.usrIncludes = usrIncludes;
            this.usrFiles = usrFiles;
            this.sysMacros = sysMacros;
            this.usrMacros = usrMacros;
        }

        private static FileSystem getFileSystem(FileObject fo) {
            try {
                return fo.getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return CndFileUtils.getLocalFileSystem();
            }
        }

        private void checkPaths() {
            this.check(this.sysIncludes);
            this.check(this.usrIncludes);
        }

        private void check(List<IncludePath> list) {
            Iterator<IncludePath> it = list.iterator();
            while (it.hasNext()) {
                IncludePath path = it.next();
                if (CndPathUtilities.isPathAbsolute((CharSequence)path.getFSPath().getPath())) continue;
                CndUtils.assertTrueInConsole((boolean)false, (String)("Can not convert " + path.getFSPath().getPath()));
                it.remove();
            }
        }

        private void addFile(FileObject file, NativeFileItem.Language lang, NativeFileItem.LanguageFlavor flavor) {
            NativeFileItemImpl item = new NativeFileItemImpl(file, this, lang, flavor);
            this.files.add(item);
        }

        public Lookup.Provider getProject() {
            return null;
        }

        public List<String> getSourceRoots() {
            return Collections.emptyList();
        }

        public String getProjectRoot() {
            return this.projectRoot.getPath();
        }

        public FileSystem getFileSystem() {
            try {
                return this.projectRoot.getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return CndFileUtils.getLocalFileSystem();
            }
        }

        public String getProjectDisplayName() {
            return this.getProjectRoot();
        }

        public List<NativeFileItem> getAllFiles() {
            return Collections.unmodifiableList(this.files);
        }

        public List<NativeFileItem> getStandardHeadersIndexers() {
            return Collections.emptyList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProjectItemsListener(NativeProjectItemsListener listener) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeProjectItemsListener(NativeProjectItemsListener listener) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            if (source instanceof MIMEExtensions) {
                FileObject fo;
                Object attribute;
                if (this.files.size() > 0 && (attribute = (fo = this.files.get(0).getFileObject()).getAttribute(CsmStandaloneFileProviderImpl.PROP_LANG_STANDARD)) instanceof String) {
                    return;
                }
                ArrayList<NativeProjectItemsListener> list = new ArrayList<NativeProjectItemsListener>();
                attribute = this.listenersLock;
                synchronized (attribute) {
                    list.addAll(this.listeners);
                }
                MIMEExtensions me = (MIMEExtensions)source;
                CndLanguageStandards.CndLanguageStandard defaultStandard = me.getDefaultStandard();
                for (NativeFileItemImpl nfi : this.files) {
                    NativeFileItem.LanguageFlavor flavor = NativeProjectImpl.standardToFlavor(defaultStandard);
                    if (flavor == NativeFileItem.LanguageFlavor.UNKNOWN) continue;
                    nfi.setLanguageFlavor(flavor);
                }
                for (NativeProjectItemsListener listener : list) {
                    listener.filesPropertiesChanged((NativeProject)this);
                }
            }
        }

        public NativeFileItemImpl findFileItem(FileObject fileObject) {
            for (NativeFileItemImpl item : this.files) {
                if (!item.getFileObject().equals(fileObject)) continue;
                return item;
            }
            return null;
        }

        public List<IncludePath> getSystemIncludePaths() {
            return this.sysIncludes;
        }

        public List<IncludePath> getUserIncludePaths() {
            return this.usrIncludes;
        }

        public List<FSPath> getSystemIncludeHeaders() {
            return this.sysIncludeHeaders;
        }

        public List<FSPath> getIncludeFiles() {
            return this.usrFiles;
        }

        public List<String> getSystemMacroDefinitions() {
            return this.sysMacros;
        }

        public List<String> getUserMacroDefinitions() {
            return this.usrMacros;
        }

        public List<NativeProject> getDependences() {
            return Collections.emptyList();
        }

        public void runOnProjectReadiness(NamedRunnable task) {
            task.run();
        }

        public void fireFilesPropertiesChanged() {
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
        }

        private CndLanguageStandards.CndLanguageStandard getStandard(FileObject fo) {
            if (fo == null) {
                return null;
            }
            String mimeType = FileUtil.getMIMEType((FileObject)fo);
            if (mimeType == null) {
                return null;
            }
            return CndLanguageStandards.StringToLanguageStandard((String)((String)fo.getAttribute(CsmStandaloneFileProviderImpl.PROP_LANG_STANDARD)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileAttributeChanged(FileAttributeEvent fe) {
            String name = fe.getName();
            if (!CsmStandaloneFileProviderImpl.PROP_LANG_STANDARD.equals(name)) {
                return;
            }
            FileObject fo = fe.getFile();
            if (fo == null) {
                return;
            }
            CndLanguageStandards.CndLanguageStandard standard = this.getStandard(fo);
            if (standard == null) {
                String mimeType = FileUtil.getMIMEType((FileObject)fo);
                if (mimeType == null) {
                    return;
                }
                MIMEExtensions me = MIMEExtensions.get((String)mimeType);
                if (me == null) {
                    return;
                }
                this.stateChanged(new ChangeEvent(me));
                return;
            }
            for (NativeFileItemImpl nfi : this.files) {
                NativeFileItem.LanguageFlavor flavor = NativeProjectImpl.standardToFlavor(standard);
                if (flavor == NativeFileItem.LanguageFlavor.UNKNOWN) continue;
                nfi.setLanguageFlavor(flavor);
            }
            ArrayList<NativeProjectItemsListener> list = new ArrayList<NativeProjectItemsListener>();
            Iterator iterator = this.listenersLock;
            synchronized (iterator) {
                list.addAll(this.listeners);
            }
            for (NativeProjectItemsListener listener : list) {
                listener.filesPropertiesChanged((NativeProject)this);
            }
        }

        public final String toString() {
            return "SA " + this.projectRoot + ' ' + this.getClass().getName() + " @" + this.hashCode() + ":" + System.identityHashCode(this);
        }

        private static final class Lock {
            private Lock() {
            }
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

