/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.launchers;

import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.launchers.Launcher;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.Env;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.UIGesturesSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public final class LauncherExecutor {
    private final Launcher launcher;
    private final ProjectActionEvent.PredefinedType actionType;
    private static final Logger LOG = Logger.getLogger("LauncherExecutor");
    private final ExecutionListener listener;
    private State state = State.STOPPED;
    private static final String USG_CND_LAUNCHER_EXECUTOR = "USG_CND_LAUNCHER_EXECUTOR";

    public static LauncherExecutor createExecutor(Launcher launcher, ProjectActionEvent.PredefinedType actionType, ExecutionListener listener) {
        return new LauncherExecutor(launcher, actionType, listener);
    }

    private LauncherExecutor(Launcher launcher, ProjectActionEvent.PredefinedType actionType, ExecutionListener listener) {
        this.launcher = launcher;
        this.actionType = actionType;
        this.listener = listener;
    }

    private static String preprocessValueField(String value, MakeConfiguration conf) {
        if ((value = value.trim()).startsWith("`") && value.endsWith("`")) {
            String command = value.substring(1, value.length() - 1);
            String[] execAndArgs = command.split(" ");
            String exec = execAndArgs[0];
            String[] args = Arrays.copyOfRange(execAndArgs, 1, execAndArgs.length);
            NativeProcessBuilder builder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)conf.getFileSystemHost()).setExecutable(exec).setArguments(args);
            ProcessUtils.ExitStatus status = ProcessUtils.execute((NativeProcessBuilder)builder);
            if (status.isOK()) {
                value = status.getOutputString();
            } else {
                LOG.info(status.getErrorString());
            }
        } else {
            value = conf.expandMacros(value);
        }
        return value;
    }

    private static MakeConfigurationDescriptor getProjectDescriptor(Project project) {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        return pdp.getConfigurationDescriptor();
    }

    private static String getMakeCommand(MakeConfigurationDescriptor pd, MakeConfiguration conf) {
        String cmd;
        CompilerSet cs = conf.getCompilerSet().getCompilerSet();
        if (cs != null) {
            cmd = cs.getTool((ToolKind)PredefinedToolKind.MakeTool).getPath();
        } else {
            CndUtils.assertFalse((boolean)true, (String)"Null compiler collection");
            cmd = "make";
        }
        return cmd;
    }

    private static String removeQuotes(String command) {
        if (command.startsWith("\"") && command.endsWith("\"")) {
            return command.substring(1, command.length() - 1);
        }
        if (command.startsWith("'") && command.endsWith("'")) {
            return command.substring(1, command.length() - 1);
        }
        return command;
    }

    private static int getArgsIndex(String command) {
        boolean inQuote = false;
        char quote = '\u0000';
        block4: for (int i = 0; i < command.length(); ++i) {
            char c = command.charAt(i);
            switch (c) {
                case ' ': {
                    if (inQuote) continue block4;
                    return i;
                }
                case '\"': 
                case '\'': {
                    if (inQuote) {
                        if (quote != c) continue block4;
                        quote = '\u0000';
                        inQuote = false;
                        continue block4;
                    }
                    quote = c;
                    inQuote = true;
                }
            }
        }
        return -1;
    }

    private void onBuild(Project project) {
        MakeConfigurationDescriptor pd = LauncherExecutor.getProjectDescriptor(project);
        MakeConfiguration conf = ConfigurationSupport.getProjectActiveConfiguration((Lookup.Provider)project).clone();
        MakeArtifact makeArtifact = new MakeArtifact(pd, conf);
        String buildCommand = this.launcher.getBuildCommand();
        if (buildCommand == null) {
            String makeCommand = LauncherExecutor.getMakeCommand(pd, conf);
            buildCommand = makeArtifact.getBuildCommand(makeCommand, "");
        } else {
            buildCommand = LauncherExecutor.preprocessValueField(buildCommand, conf);
        }
        String args = "";
        int index = LauncherExecutor.getArgsIndex(buildCommand);
        if (index >= 0) {
            args = buildCommand.substring(index + 1);
            buildCommand = LauncherExecutor.removeQuotes(buildCommand.substring(0, index));
        }
        Map<String, String> env = this.launcher.getEnv();
        Env e = new Env();
        if (env != null) {
            env.keySet().forEach(key -> {
                String value = (String)env.get(key);
                value = LauncherExecutor.preprocessValueField(value, conf);
                e.putenv((String)key, value);
            });
        }
        RunProfile profile = new RunProfile(makeArtifact.getWorkingDirectory(), conf.getDevelopmentHost().getBuildPlatform(), conf);
        profile.setArgs(args);
        profile.setEnvironment(e);
        Lookup context = Lookups.fixed((Object[])new Object[]{new ExecutionListenerImpl()});
        ProjectActionEvent projectActionEvent = new ProjectActionEvent(project, this.actionType, buildCommand, conf, profile, true, context);
        ProjectActionSupport.getInstance().fireActionPerformed(new ProjectActionEvent[]{projectActionEvent});
    }

    private void onDefault(Project project) {
        MakeConfiguration conf = ConfigurationSupport.getProjectActiveConfiguration((Lookup.Provider)project).clone();
        if (conf != null) {
            RunProfile profile = conf.getProfile();
            String runCommand = this.launcher.getCommand();
            runCommand = LauncherExecutor.preprocessValueField(runCommand, conf);
            profile.getRunCommand().setValue(runCommand);
            String runDir = this.launcher.getRunDir() != null ? this.launcher.getRunDir() : profile.getBaseDir();
            runDir = LauncherExecutor.preprocessValueField(runDir, conf);
            profile.setRunDir(runDir);
            Map<String, String> env = this.launcher.getEnv();
            Env e = new Env();
            if (env != null) {
                env.keySet().forEach(key -> {
                    String value = (String)env.get(key);
                    value = LauncherExecutor.preprocessValueField(value, conf);
                    e.putenv((String)key, value);
                });
            }
            profile.setEnvironment(e);
            String executable = "";
            if (this.launcher.getSymbolFiles() != null) {
                executable = this.launcher.getSymbolFiles().split(",")[0];
                executable = LauncherExecutor.preprocessValueField(executable, conf);
            }
            Lookup context = this.launcher.runInOwnTab() ? Lookups.fixed((Object[])new Object[]{new ExecutionListenerImpl(), executable, new MyType(this.actionType, this.launcher.getName())}) : Lookups.fixed((Object[])new Object[]{new ExecutionListenerImpl(), executable});
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(project, this.actionType, executable, conf, profile, false, context);
            ProjectActionSupport.getInstance().fireActionPerformed(new ProjectActionEvent[]{projectActionEvent});
        }
    }

    public void execute(Project project) {
        RequestProcessor.getDefault().post(() -> {
            switch (this.actionType) {
                case BUILD: {
                    this.onBuild(project);
                    break;
                }
                default: {
                    this.onDefault(project);
                }
            }
        });
        UIGesturesSupport.submit((String)USG_CND_LAUNCHER_EXECUTOR, (Object[])new Object[]{this.actionType});
    }

    public boolean isRunning() {
        return this.state.equals((Object)State.RUNNING);
    }

    private static final class MyType
    implements ProjectActionEvent.Type {
        private final ProjectActionEvent.Type delegate;
        private final String name;

        private MyType(ProjectActionEvent.Type delegate, String name) {
            this.delegate = delegate;
            this.name = name;
        }

        @Override
        public int ordinal() {
            return this.delegate.ordinal();
        }

        @Override
        public String name() {
            return this.delegate.name();
        }

        @Override
        public String getLocalizedName() {
            if (this.name == null || this.name.isEmpty()) {
                return this.delegate.getLocalizedName();
            }
            return this.delegate.getLocalizedName() + " " + this.name;
        }

        @Override
        public void setLocalizedName(String name) {
            throw new UnsupportedOperationException();
        }
    }

    private final class ExecutionListenerImpl
    implements ExecutionListener {
        private ExecutionListenerImpl() {
        }

        public void executionStarted(int pid) {
            LauncherExecutor.this.state = State.RUNNING;
            LauncherExecutor.this.listener.executionStarted(pid);
        }

        public void executionFinished(int rc) {
            LauncherExecutor.this.state = State.STOPPED;
            LauncherExecutor.this.listener.executionFinished(rc);
        }
    }

    private static enum State {
        RUNNING,
        STOPPED;

    }
}

