/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.messages;

import nu.validator.messages.Result;
import nu.validator.messages.ResultHandler;
import nu.validator.xml.XhtmlSaxEmitter;
import org.xml.sax.SAXException;

public class XhtmlResultHandler
implements ResultHandler {
    private final XhtmlSaxEmitter emitter;

    public XhtmlResultHandler(XhtmlSaxEmitter emitter) {
        this.emitter = emitter;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.emitter.characters(ch, start, length);
    }

    @Override
    public void endResult() throws SAXException {
        this.emitter.endElement("p");
    }

    @Override
    public void startResult(Result result) throws SAXException {
        switch (result) {
            case SUCCESS: {
                this.emitter.startElementWithClass("p", "success");
                break;
            }
            case FAILURE: {
                this.emitter.startElementWithClass("p", "failure");
                break;
            }
            case INDETERMINATE: {
                this.emitter.startElementWithClass("p", "indeterminate");
            }
        }
    }
}

