/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.util.List;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.refactoring.HibernateMappingRenameTransaction;
import org.netbeans.modules.hibernate.refactoring.HibernateRefactoringUtil;
import org.netbeans.modules.hibernate.refactoring.HibernateRenameRefactoringElement;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class HibernateMappingRenamePlugin
implements RefactoringPlugin {
    private RenameRefactoring refactoring;
    private FileObject fo;
    private String oldResourceName;
    private String newResourceName;

    public HibernateMappingRenamePlugin(RenameRefactoring refactoring) {
        this.refactoring = refactoring;
        this.fo = (FileObject)refactoring.getRefactoringSource().lookup(FileObject.class);
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        Project project;
        HibernateEnvironment hibernateEnv;
        List<String> mappingFiles;
        String newName;
        Problem fastCheckProblem = null;
        String oldName = this.fo.getName();
        if (oldName.equals(newName = this.refactoring.getNewName())) {
            fastCheckProblem = HibernateRefactoringUtil.createProblem(fastCheckProblem, true, NbBundle.getMessage(HibernateMappingRenamePlugin.class, (String)"MSG_NameNotChanged"));
            return fastCheckProblem;
        }
        if (!HibernateRefactoringUtil.isValidMappingFileName(newName)) {
            fastCheckProblem = HibernateRefactoringUtil.createProblem(fastCheckProblem, true, NbBundle.getMessage(HibernateMappingRenamePlugin.class, (String)"MSG_Invalid_Name"));
        }
        this.getOldNewResourceName();
        if (this.oldResourceName == null || this.newResourceName == null) {
            fastCheckProblem = HibernateRefactoringUtil.createProblem(fastCheckProblem, true, NbBundle.getMessage(HibernateMappingRenamePlugin.class, (String)"MSG_Invalid_Name"));
        }
        if ((mappingFiles = (hibernateEnv = (HibernateEnvironment)(project = FileOwnerQuery.getOwner((FileObject)this.fo)).getLookup().lookup(HibernateEnvironment.class)).getAllHibernateMappings()).contains(this.newResourceName)) {
            fastCheckProblem = HibernateRefactoringUtil.createProblem(fastCheckProblem, true, NbBundle.getMessage(HibernateMappingRenamePlugin.class, (String)"MSG_NameNotUnique", (Object)newName));
        }
        return fastCheckProblem;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        if (this.fo == null || !this.fo.getMIMEType().equals("text/x-hibernate-mapping+xml")) {
            return null;
        }
        Project proj = FileOwnerQuery.getOwner((FileObject)this.fo);
        HibernateEnvironment env = (HibernateEnvironment)proj.getLookup().lookup(HibernateEnvironment.class);
        List<FileObject> configFiles = env.getAllHibernateConfigFileObjects();
        if (configFiles.isEmpty()) {
            return null;
        }
        Map<FileObject, List<HibernateRefactoringUtil.OccurrenceItem>> occurrences = HibernateRefactoringUtil.getMappingResourceOccurrences(configFiles, this.oldResourceName, false);
        for (FileObject configFile : occurrences.keySet()) {
            List<HibernateRefactoringUtil.OccurrenceItem> foundPlaces = occurrences.get(configFile);
            for (HibernateRefactoringUtil.OccurrenceItem foundPlace : foundPlaces) {
                HibernateRenameRefactoringElement elem = new HibernateRenameRefactoringElement(configFile, this.oldResourceName, this.newResourceName, foundPlace.getLocation(), foundPlace.getText());
                refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)elem);
            }
        }
        refactoringElements.registerTransaction((Transaction)new HibernateMappingRenameTransaction(occurrences.keySet(), this.oldResourceName, this.newResourceName));
        return null;
    }

    private void getOldNewResourceName() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.fo);
        SourceGroup[] grp = SourceGroups.getJavaSourceGroups((Project)project);
        if (grp.length == 0) {
            return;
        }
        String srcRoot = grp[0].getRootFolder().getPath();
        String oldPath = this.fo.getPath();
        this.oldResourceName = oldPath.substring(srcRoot.length() + 1);
        String pkgPath = this.oldResourceName.substring(0, this.oldResourceName.lastIndexOf("/") + 1);
        this.newResourceName = pkgPath + this.refactoring.getNewName() + ".xml";
    }
}

