/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus;

import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmConstructor;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.completion.cplusplus.CsmCompletionUtils;
import org.netbeans.modules.cnd.completion.cplusplus.CsmFinderImpl;
import org.netbeans.modules.cnd.completion.cplusplus.NbCsmResultItem;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CompletionSupport;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionExpression;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionQuery;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmFinder;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmResultItem;
import org.netbeans.modules.cnd.completion.csm.CompletionResolver;
import org.netbeans.modules.cnd.completion.csm.CompletionResolverImpl;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;

public class NbCsmCompletionQuery
extends CsmCompletionQuery {
    private CsmFile csmFile;
    private Integer offsetInFile;
    private final CompletionResolver.QueryScope queryScope;
    private final FileReferencesContext fileReferencesContext;
    private final boolean forceCaseSensitiveMode;
    private static final int PRIORITY_SHIFT = 10;
    private static final int LOCAL_VAR_PRIORITY = 10;
    private static final int FIELD_PRIORITY = 20;
    private static final int CLASS_ENUMERATOR_PRIORITY = 20;
    private static final int METHOD_PRIORITY = 30;
    private static final int CONSTRUCTOR_PRIORITY = 40;
    private static final int CLASS_PRIORITY = 50;
    private static final int ENUM_PRIORITY = 50;
    private static final int TYPEDEF_PRIORITY = 50;
    private static final int FILE_LOCAL_VAR_PRIORITY = 60;
    private static final int FILE_LOCAL_ENUMERATOR_PRIORITY = 70;
    private static final int FILE_LOCAL_FUNCTION_PRIORITY = 80;
    private static final int FILE_LOCAL_MACRO_PRIORITY = 90;
    private static final int FILE_INCLUDED_PRJ_MACRO_PRIORITY = 100;
    private static final int GLOBAL_VAR_PRIORITY = 110;
    private static final int GLOBAL_ENUMERATOR_PRIORITY = 120;
    private static final int GLOBAL_MACRO_PRIORITY = 130;
    private static final int GLOBAL_FUN_PRIORITY = 140;
    private static final int GLOBAL_NAMESPACE_PRIORITY = 1000;
    private static final int GLOBAL_NAMESPACE_ALIAS_PRIORITY = 1000;
    private static final int LIB_CLASS_PRIORITY = 1010;
    private static final int LIB_ENUM_PRIORITY = 1010;
    private static final int LIB_TYPEDEF_PRIORITY = 1010;
    private static final int FILE_INCLUDED_LIB_MACRO_PRIORITY = 1020;
    private static final int LIB_MACRO_PRIORITY = 1030;
    private static final int LIB_VAR_PRIORITY = 1040;
    private static final int LIB_ENUMERATOR_PRIORITY = 1050;
    private static final int LIB_FUN_PRIORITY = 1060;
    private static final int LIB_NAMESPACE_PRIORITY = 1070;
    private static final int LIB_NAMESPACE_ALIAS_PRIORITY = 1070;
    public static final int KEYWORDS_PRIORITY = 5000;

    protected NbCsmCompletionQuery(CsmFile csmFile, CompletionResolver.QueryScope localContext, FileReferencesContext fileReferencesContext, boolean forceCaseSensitiveMode) {
        this.csmFile = csmFile;
        this.queryScope = localContext;
        this.fileReferencesContext = fileReferencesContext;
        this.forceCaseSensitiveMode = forceCaseSensitiveMode;
    }

    @Override
    protected CsmFinder getFinder() {
        CsmFinderImpl finder = null;
        if (this.getCsmFile() != null) {
            finder = this.fileReferencesContext != null || this.forceCaseSensitiveMode ? new CsmFinderImpl(this.getCsmFile(), "text/x-cnd+sourcefile", true) : new CsmFinderImpl(this.getCsmFile(), "text/x-cnd+sourcefile");
        }
        return finder;
    }

    @Override
    protected FileReferencesContext getFileReferencesContext() {
        return this.fileReferencesContext;
    }

    @Override
    public CsmFile getCsmFile() {
        BaseDocument bDoc;
        if (this.csmFile == null && (bDoc = this.getBaseDocument()) != null) {
            this.csmFile = CsmUtilities.getCsmFile((Document)bDoc, (boolean)true, (boolean)false);
            String mimeType = DocumentUtilities.getMimeType((Document)bDoc);
            if ("text/x-dialog-binding".equals(mimeType)) {
                InputAttributes inputAttributes = (InputAttributes)bDoc.getProperty(InputAttributes.class);
                if (inputAttributes != null) {
                    FileObject fo;
                    Document aDoc;
                    Integer lineInFile;
                    LanguagePath path = LanguagePath.get((Language)((Language)MimeLookup.getLookup((String)mimeType).lookup(Language.class)));
                    this.offsetInFile = (Integer)inputAttributes.getValue(path, (Object)"dialogBinding.offset");
                    Integer length = (Integer)inputAttributes.getValue(path, (Object)"dialogBinding.length");
                    if (this.offsetInFile != null && this.offsetInFile != -1 && length != null) {
                        this.offsetInFile = this.offsetInFile - length;
                    }
                    if ((this.offsetInFile == null || this.offsetInFile == -1) && (lineInFile = (Integer)inputAttributes.getValue(path, (Object)"dialogBinding.line")) != null && lineInFile >= 0 && (aDoc = CsmUtilities.getDocument((FileObject)(fo = (FileObject)inputAttributes.getValue(path, (Object)"dialogBinding.fileObject")))) instanceof StyledDocument) {
                        try {
                            this.offsetInFile = NbDocument.findLineOffset((StyledDocument)((StyledDocument)aDoc), (int)lineInFile);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }
                CompletionSupport sup = CompletionSupport.get((Document)bDoc);
                if (this.offsetInFile != null) {
                    sup.setContextOffset(this.offsetInFile);
                }
            }
        }
        return this.csmFile;
    }

    @Override
    protected CompletionResolver.QueryScope getCompletionQueryScope() {
        return this.queryScope;
    }

    @Override
    protected CompletionResolver getCompletionResolver(CsmScope contextScope, boolean openingSource, boolean sort, boolean inIncludeDirective) {
        return this.getCompletionResolver(this.getBaseDocument(), this.getCsmFile(), contextScope, openingSource, sort, this.queryScope, inIncludeDirective);
    }

    private CompletionResolver getCompletionResolver(BaseDocument bDoc, CsmFile csmFile, CsmScope contextScope, boolean openingSource, boolean sort, CompletionResolver.QueryScope queryScope, boolean inIncludeDirective) {
        CompletionResolverImpl resolver = null;
        if (csmFile != null) {
            String mimeType = CsmCompletionUtils.getMimeType((Document)bDoc);
            resolver = new CompletionResolverImpl(csmFile, openingSource || CsmCompletionUtils.isCaseSensitive(mimeType), sort, CsmCompletionUtils.isNaturalSort(mimeType), this.fileReferencesContext);
            resolver.setResolveScope(queryScope);
            resolver.setInIncludeDirective(inIncludeDirective);
            if (this.offsetInFile != null) {
                resolver.setContextOffset(this.offsetInFile);
            }
            if (contextScope != null) {
                resolver.setContextScope(contextScope);
            }
        }
        return resolver;
    }

    @Override
    protected boolean isProjectBeeingParsed(boolean openingSource) {
        CsmFile file;
        if (!openingSource && this.getFinder() != null && (file = this.getFinder().getCsmFile()) != null && file.getProject() != null) {
            return !file.getProject().isStable(file);
        }
        return false;
    }

    static {
        CsmCompletionQuery.setCsmItemFactory(new NbCsmItemFactory());
    }

    public static final class NbCsmItemFactory
    implements CsmCompletionQuery.CsmItemFactory {
        @Override
        public CsmResultItem.LocalVariableResultItem createLocalVariableResultItem(CsmVariable var) {
            return new NbCsmResultItem.NbLocalVariableResultItem(var, 10);
        }

        @Override
        public CsmResultItem.FieldResultItem createFieldResultItem(CsmField fld) {
            return new NbCsmResultItem.NbFieldResultItem(fld, 20);
        }

        @Override
        public CsmResultItem.EnumeratorResultItem createMemberEnumeratorResultItem(CsmEnumerator enmtr, int enumtrDisplayOffset, boolean displayFQN) {
            return new NbCsmResultItem.NbEnumeratorResultItem(enmtr, enumtrDisplayOffset, displayFQN, 20);
        }

        @Override
        public CsmResultItem.MethodResultItem createMethodResultItem(CsmMethod mtd, CsmCompletionExpression substituteExp, boolean isDeclaration, boolean instantiateTypes) {
            return new NbCsmResultItem.NbMethodResultItem(mtd, substituteExp, 30, isDeclaration, instantiateTypes);
        }

        @Override
        public CsmResultItem.ConstructorResultItem createConstructorResultItem(CsmConstructor ctr, CsmCompletionExpression substituteExp, boolean isDeclaration, boolean instantiateTypes) {
            return new NbCsmResultItem.NbConstructorResultItem(ctr, substituteExp, 40, isDeclaration, instantiateTypes);
        }

        @Override
        public CsmResultItem.ClassResultItem createClassResultItem(CsmClass cls, int classDisplayOffset, boolean displayFQN) {
            return new NbCsmResultItem.NbClassResultItem(cls, classDisplayOffset, displayFQN, 50);
        }

        @Override
        public CsmResultItem.ForwardClassResultItem createForwardClassResultItem(CsmClassForwardDeclaration cls, int classDisplayOffset, boolean displayFQN) {
            return new NbCsmResultItem.NbForwardClassResultItem(cls, classDisplayOffset, displayFQN, 50);
        }

        @Override
        public CsmResultItem.ForwardEnumResultItem createForwardEnumResultItem(CsmEnumForwardDeclaration cls, int classDisplayOffset, boolean displayFQN) {
            return new NbCsmResultItem.NbForwardEnumResultItem(cls, classDisplayOffset, displayFQN, 50);
        }

        @Override
        public CsmResultItem.EnumResultItem createEnumResultItem(CsmEnum enm, int enumDisplayOffset, boolean displayFQN) {
            return new NbCsmResultItem.NbEnumResultItem(enm, enumDisplayOffset, displayFQN, 50);
        }

        @Override
        public CsmResultItem.TypedefResultItem createTypedefResultItem(CsmTypedef def, int classDisplayOffset, boolean displayFQN) {
            return new NbCsmResultItem.NbTypedefResultItem(def, classDisplayOffset, displayFQN, 50);
        }

        @Override
        public CsmResultItem.FileLocalVariableResultItem createFileLocalVariableResultItem(CsmVariable var) {
            return new NbCsmResultItem.NbFileLocalVariableResultItem(var, 60);
        }

        @Override
        public CsmResultItem.EnumeratorResultItem createFileLocalEnumeratorResultItem(CsmEnumerator enmtr, int enumtrDisplayOffset, boolean displayFQN) {
            return new NbCsmResultItem.NbEnumeratorResultItem(enmtr, enumtrDisplayOffset, displayFQN, 70);
        }

        @Override
        public CsmResultItem.MacroResultItem createFileLocalMacroResultItem(CsmMacro mac) {
            return new NbCsmResultItem.NbMacroResultItem(mac, 90);
        }

        @Override
        public CsmResultItem.FileLocalFunctionResultItem createFileLocalFunctionResultItem(CsmFunction fun, CsmCompletionExpression substituteExp, boolean isDeclaration, boolean instantiateTypes) {
            return new NbCsmResultItem.NbFileLocalFunctionResultItem(fun, substituteExp, 80, isDeclaration, instantiateTypes);
        }

        @Override
        public CsmResultItem.MacroResultItem createFileIncludedProjectMacroResultItem(CsmMacro mac) {
            return new NbCsmResultItem.NbMacroResultItem(mac, 100);
        }

        @Override
        public CsmResultItem.GlobalVariableResultItem createGlobalVariableResultItem(CsmVariable var) {
            return new NbCsmResultItem.NbGlobalVariableResultItem(var, 110);
        }

        @Override
        public CsmResultItem.EnumeratorResultItem createGlobalEnumeratorResultItem(CsmEnumerator enmtr, int enumtrDisplayOffset, boolean displayFQN) {
            return new NbCsmResultItem.NbEnumeratorResultItem(enmtr, enumtrDisplayOffset, displayFQN, 120);
        }

        @Override
        public CsmResultItem.MacroResultItem createGlobalMacroResultItem(CsmMacro mac) {
            return new NbCsmResultItem.NbMacroResultItem(mac, 130);
        }

        @Override
        public CsmResultItem.GlobalFunctionResultItem createGlobalFunctionResultItem(CsmFunction fun, CsmCompletionExpression substituteExp, boolean isDeclaration, boolean instantiateTypes) {
            return new NbCsmResultItem.NbGlobalFunctionResultItem(fun, substituteExp, 140, isDeclaration, instantiateTypes);
        }

        @Override
        public CsmResultItem.NamespaceResultItem createNamespaceResultItem(CsmNamespace pkg, boolean displayFullNamespacePath) {
            return new NbCsmResultItem.NbNamespaceResultItem(pkg, displayFullNamespacePath, 1000);
        }

        @Override
        public CsmResultItem.NamespaceAliasResultItem createNamespaceAliasResultItem(CsmNamespaceAlias alias, boolean displayFullNamespacePath) {
            return new NbCsmResultItem.NbNamespaceAliasResultItem(alias, displayFullNamespacePath, 1000);
        }

        @Override
        public CsmResultItem.ClassResultItem createLibClassResultItem(CsmClass cls, int classDisplayOffset, boolean displayFQN) {
            return new NbCsmResultItem.NbClassResultItem(cls, classDisplayOffset, displayFQN, 1010);
        }

        @Override
        public CsmResultItem.EnumResultItem createLibEnumResultItem(CsmEnum enm, int enumDisplayOffset, boolean displayFQN) {
            return new NbCsmResultItem.NbEnumResultItem(enm, enumDisplayOffset, displayFQN, 1010);
        }

        @Override
        public CsmResultItem.TypedefResultItem createLibTypedefResultItem(CsmTypedef def, int classDisplayOffset, boolean displayFQN) {
            return new NbCsmResultItem.NbTypedefResultItem(def, classDisplayOffset, displayFQN, 1010);
        }

        @Override
        public CsmResultItem.MacroResultItem createFileIncludedLibMacroResultItem(CsmMacro mac) {
            return new NbCsmResultItem.NbMacroResultItem(mac, 1020);
        }

        @Override
        public CsmResultItem.MacroResultItem createLibMacroResultItem(CsmMacro mac) {
            return new NbCsmResultItem.NbMacroResultItem(mac, 1030);
        }

        @Override
        public CsmResultItem.GlobalVariableResultItem createLibGlobalVariableResultItem(CsmVariable var) {
            return new NbCsmResultItem.NbGlobalVariableResultItem(var, 1040);
        }

        @Override
        public CsmResultItem.EnumeratorResultItem createLibGlobalEnumeratorResultItem(CsmEnumerator enmtr, int enumtrDisplayOffset, boolean displayFQN) {
            return new NbCsmResultItem.NbEnumeratorResultItem(enmtr, enumtrDisplayOffset, displayFQN, 1050);
        }

        @Override
        public CsmResultItem.GlobalFunctionResultItem createLibGlobalFunctionResultItem(CsmFunction fun, CsmCompletionExpression substituteExp, boolean instantiateTypes) {
            return new NbCsmResultItem.NbGlobalFunctionResultItem(fun, substituteExp, 1060, false, instantiateTypes);
        }

        @Override
        public CsmResultItem.NamespaceResultItem createLibNamespaceResultItem(CsmNamespace pkg, boolean displayFullNamespacePath) {
            return new NbCsmResultItem.NbNamespaceResultItem(pkg, displayFullNamespacePath, 1070);
        }

        @Override
        public CsmResultItem.NamespaceAliasResultItem createLibNamespaceAliasResultItem(CsmNamespaceAlias alias, boolean displayFullNamespacePath) {
            return new NbCsmResultItem.NbNamespaceAliasResultItem(alias, displayFullNamespacePath, 1070);
        }

        @Override
        public CsmResultItem.TemplateParameterResultItem createTemplateParameterResultItem(CsmTemplateParameter par) {
            return new NbCsmResultItem.NbTemplateParameterResultItem(par, 20);
        }

        @Override
        public CsmResultItem createLabelResultItem(CsmLabel csmStatement) {
            return new CsmResultItem.LabelResultItem(csmStatement, 10);
        }
    }
}

